<?php

namespace App\Http\Controllers;

use App\AppCharge;
use App\EbayAccount;
use App\EbayCategory;
use App\Helpers\AppHelper;
use App\Http\Controllers\Controller;
use App\Jobs\ProcessDatabaseMigration;
use App\Mail\Notification;
use App\Plan;
use App\Profile;
use App\ShopifyStore;
use App\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Log;
use Mail;
use PHPShopify;
use \DTS\eBaySDK\Trading\Services;
use \DTS\eBaySDK\Trading\Types;
use App\Helpers\mail2user;

class ShopifyController extends Controller
{

    protected $shopifyClient;
    protected $shopifyStore;
    protected $planFeatures;

    public function __construct(Request $request)
    {
        $this->middleware('tenanti', ['except' => ['install', 'installAuth', 'decryptData', 'error']]);
        $this->middleware('shopify.store', ['except' => ['error', 'acceptTos', 'getActivityLogs', 'getSummaryData', 'plans', 'addAppCharge', 'appCharge', 'decryptData']]);

        $this->middleware(function ($request, $next) {
            if (Auth::check() && Auth::user()) {
                $shopify_url = session('user_' . Auth::user()->id . '_shopify_url');
                if ($shopify_url) {
                    $this->shopifyStore = Auth::user()->shopifyStores()->with('user')->with('plan')->where('shopify_url', $shopify_url)->first();
                    if ($this->shopifyStore && $this->shopifyStore->plan) {
                        $this->planFeatures = json_decode($this->shopifyStore->plan->features);
                    }

                }
            }
            return $next($request);
        });
        $this->shopifyClient = new PHPShopify\ShopifySDK;
    }

    public function productUpdateWebhook(Request $request)
    {
        if (!isset($_SERVER['HTTP_X_SHOPIFY_HMAC_SHA256'])) {
            return response()->json(['status' => 'error', 'msg' => 'invalid webhook'], 200);
        }

        $hmac_header = $_SERVER['HTTP_X_SHOPIFY_HMAC_SHA256'];
        $data = file_get_contents('php://input');
        $sharedSecret = config('shopify.shared_secret');
        $calculated_hmac = base64_encode(hash_hmac('sha256', $data, $sharedSecret, true));
        if (hash_equals($hmac_header, $calculated_hmac)) {
            $jsonString = "";
            $jsonData = fopen('php://input', 'rb');
            while (!feof($jsonData)) {$jsonString .= fread($jsonData, 16384) . "\n";}
            fclose($jsonData);

            $jsonString = trim(str_replace("\n", "", $jsonString));

            $webhookData = json_decode($jsonString, true);
            if ($webhookData) {
                $product_id = $webhookData["id"];

            }
            return response()->json(['status' => 'success', 'msg' => 'webhook processed'], 200);
        } else {
            return response()->json(['status' => 'error', 'msg' => 'calculated hmac does not match with hmac header'], 200);
        }
    }

    public function productDeleteWebhook(Request $request)
    {
        if (!isset($_SERVER['HTTP_X_SHOPIFY_HMAC_SHA256'])) {
            return response()->json(['status' => 'error', 'msg' => 'invalid webhook'], 200);
        }

        $hmac_header = $_SERVER['HTTP_X_SHOPIFY_HMAC_SHA256'];
        $data = file_get_contents('php://input');
        $sharedSecret = config('shopify.shared_secret');
        $calculated_hmac = base64_encode(hash_hmac('sha256', $data, $sharedSecret, true));
        if (hash_equals($hmac_header, $calculated_hmac)) {
            $jsonString = "";
            $jsonData = fopen('php://input', 'rb');
            while (!feof($jsonData)) {$jsonString .= fread($jsonData, 16384) . "\n";}
            fclose($jsonData);

            $jsonString = trim(str_replace("\n", "", $jsonString));

            $webhookData = json_decode($jsonString, true);
            if ($webhookData) {
                $product_id = $webhookData["id"];

            }
            echo "200 OK";
            //return response()->json(['status' => 'success','msg' => 'webhook processed'],200);
        } else {
            return response()->json(['status' => 'error', 'msg' => 'calculated hmac does not match with hmac header'], 200);
        }
    }

    public function appUninstallWebhook(Request $request)
    {
        if (!isset($_SERVER['HTTP_X_SHOPIFY_HMAC_SHA256'])) {
            return response()->json(['status' => 'error', 'msg' => 'invalid webhook'], 200);
        }

        $hmac_header = (isset($_SERVER['HTTP_X_SHOPIFY_HMAC_SHA256'])) ? $_SERVER['HTTP_X_SHOPIFY_HMAC_SHA256'] : "";
        $data = file_get_contents('php://input');
        $sharedSecret = config('shopify.shared_secret');
        $calculated_hmac = base64_encode(hash_hmac('sha256', $data, $sharedSecret, true));
        $jsonString = "";
        $jsonData = fopen('php://input', 'rb');
        while (!feof($jsonData)) {$jsonString .= fread($jsonData, 16384) . "\n";}
        fclose($jsonData);

        $jsonString = trim(str_replace("\n", "", $jsonString));

        if (hash_equals($hmac_header, $calculated_hmac)) {
            try {
                $webhookData = json_decode($jsonString, true);
                if ($webhookData) {
                    $shopify_url = $webhookData["myshopify_domain"];
                    $shopifyStore = ($shopify_url) ? ShopifyStore::where('shopify_url', $shopify_url)->first() : array();
                    if ($shopifyStore) {
                        $shopifyStore->plan_id = 1;
                        $shopifyStore->status = "uninstalled";
                        $shopifyStore->uninstalled_at = date("Y-m-d H:i:s");
                        $shopifyStore->save();
                    } else {
                        try {
                            $mailData = array();
                            $mailData["mail_subject"] = "App Uninstall Webhook";
                            $mailData["title"] = "Shopify Store Not Found";
                            $mailData["description"] = "can't find shopify store<br>Webhook Data : " . $jsonString;
                            $mailData["link"] = "";
                            $mailData["link_text"] = "";
                            Mail::to(config('config.notify_email'))->send(new Notification($mailData));
                        } catch (\Exception $e) {
                            report($e);
                        }
                    }
                } else {
                    try {
                        $mailData = array();
                        $mailData["mail_subject"] = "App Uninstall Webhook";
                        $mailData["title"] = "Error Fetching Webhook Data";
                        $mailData["description"] = "json not decoded to array<br>Webhook Data : " . $jsonString;
                        $mailData["link"] = "";
                        $mailData["link_text"] = "";
                        Mail::to(config('config.notify_email'))->send(new Notification($mailData));
                    } catch (\Exception $e) {
                        report($e);
                    }
                }
            } catch (\Exception $e) {
                report($e);
                try {
                    $mailData = array();
                    $mailData["mail_subject"] = "App Uninstall Webhook";
                    $mailData["title"] = "Update Store Status Error";
                    $mailData["description"] = "Error : " . $e->getMessage() . "<br>Webhook Data : " . $jsonString;
                    $mailData["link"] = "";
                    $mailData["link_text"] = "";
                    Mail::to(config('config.notify_email'))->send(new Notification($mailData));
                } catch (\Exception $e) {
                    report($e);
                }
            }
            echo "200 OK";
            //return response()->json(['status' => 'success','msg' => 'webhook processed'],200);
        } else {
            try {
                $mailData = array();
                $mailData["mail_subject"] = "App Uninstall Webhook";
                $mailData["title"] = "Verifying App Uninstall Webhook Failed";
                $mailData["description"] = "Webhook Data : " . $jsonString;
                $mailData["link"] = "";
                $mailData["link_text"] = "";
                Mail::to(config('config.notify_email'))->send(new Notification($mailData));
            } catch (\Exception $e) {
                report($e);
            }
            return response()->json(['status' => 'error', 'msg' => 'calculated hmac does not match with hmac header'], 200);
        }
        exit(0);
    }

    public function index(Request $request)
    {
        if (Auth::check() && Auth::user() && $this->shopifyStore && $this->shopifyStore->status == "active") {

            /*
            try{
            $webhooks = array(
            array("topic" => "app/uninstalled","address" => route('appUninstallWebhook')),
            array("topic" => "products/create","address" => route('productUpdateWebhookShopify')),
            array("topic" => "products/update","address" => route('productUpdateWebhookShopify')),
            array("topic" => "products/delete","address" => route('productDeleteWebhookShopify')),
            array("topic" => "inventory_levels/update","address" => route('inventoryLevelWebhookShopify')),
            array("topic" => "orders/delete","address" => route('orderDeleteWebhookShopify')),
            array("topic" => "orders/cancelled","address" => route('orderCancelWebhookShopify')),
            array("topic" => "orders/fulfilled","address" => route('orderFulfilledWebhookShopify'))
            );

            foreach($webhooks as $webhook){
            try{
            $topic = $webhook["topic"];
            $address = "arn:aws:events:ap-south-1::event-source/aws.partner/shopify.com/2469719/Shopify-Webhook-Ebay-App";
            $webhookData = array("topic" => $topic,"address" => $address,"format" => "json");
            $this->shopifyClient->Webhook()->post($webhookData);
            sleep(1);
            }
            catch(\Exception $e){
            report($e);
            }
            }
            }
            catch(\Exception $e){
            report($e);
            }
             */

            /*
            $webhookData = array(
            "topic" => "products/update",
            "address" => "arn:aws:events:ap-south-1::event-source/aws.partner/shopify.com/2469719/Shopify-Webhook-Ebay-App",
            "format" => "json"
            );
            $response = $this->shopifyClient->Webhook()->post($webhookData);

            echo '<pre>';
            print_r($response);
            die();
             */

            /*
            $shopify_store_id = $this->shopifyStore->id;
            $store_database_name = config('config.store_db_prefix').$shopify_store_id;
            try{
            DB::statement('CREATE DATABASE IF NOT EXISTS `'.$store_database_name.'` CHARACTER SET '.config('database.connections.'.config('database.default').'.charset').' COLLATE '.config('database.connections.'.config('database.default').'.collation'));
            AppHelper::setConnection($store_database_name);
            }
            catch(\Exception $e){
            report($e);
            }
             */

            /*
            try{
            ProcessDatabaseMigration::dispatchNow($this->shopifyStore->shopify_url);
            }
            catch(\Exception $e){
            report($e);
            }
             */

            /*
            if(true){
            try{
            $webhooks = array(
            //array("topic" => "app/uninstalled","address" => route('appUninstallWebhook')),
            array("topic" => "products/create","address" => route('productUpdateWebhookShopify')),
            array("topic" => "products/update","address" => route('productUpdateWebhookShopify')),
            //array("topic" => "products/delete","address" => route('productDeleteWebhookShopify')),
            //array("topic" => "fulfillments/create","address" => route('fulfillmentUpdateWebhook')),
            //array("topic" => "fulfillments/update","address" => route('fulfillmentUpdateWebhook'))
            );
            foreach($webhooks as $webhook){
            try{
            $topic = $webhook["topic"];
            $address = $webhook["address"];
            $webhookData = array("topic" => $topic,"address" => $address,"format" => "json");
            $this->shopifyClient->Webhook()->post($webhookData);
            sleep(1);
            }
            catch(\Exception $e){
            report($e);
            }
            }
            }
            catch(\Exception $e){
            report($e);
            }
            }
             */

            /*
            $token = \Str::random(60);
            echo $token;

            Auth::user()->forceFill([
            'api_token' => hash('sha256',$token)
            ])->save();
             */
            //GFzc7jxvDSy5sGKZ7NgbVn14RRBOhrZLIoIdwicTTx4CHvheZ2RVThE4Qvkt

            //c9fe22113f7ac0ec798cf844b2b3c24105b20c5c74c20b8f8149d047ed7e7d93

            //return \Redirect::to('http://localhost:3000/?shop=infoshore.myshopify.com');
            //$frontend_url = config('config.frontend_url').'?shop='.$this->shopifyStore->shopify_url;
            $frontend_url = config('config.frontend_url') . '?' . http_build_query($_GET);

            $frontend_url = $frontend_url . "&login_token=" . $this->shopifyStore->login_token;

            echo '
			<script type="text/javascript">
				//window.parent.location.href = "http://localhost:3000/?shop=' . $this->shopifyStore->shopify_url . '";
				window.parent.location.href = "' . $frontend_url . '";
			</script>
			';
            die();
            //return view('home');
        } else if ($request->has('shop')) {
            $shopifyStore = $this->shopifyStore;
            $shopifyPlans = Plan::where("status", 1)->whereIn("type", array("shopify", "all"))->orderBy('porder')->get();
        } else {
            return response()->json(['status' => 'error', 'msg' => "invalid request"], 403);
        }
    }

    public function plansOld(Request $request)
    {
        $shopifyStore = $this->shopifyStore;
        $shopifyPlans = Plan::where("status", 1)->whereIn("type", array("shopify", "all"))->where(function ($query) use ($shopifyStore) {
            $query->whereNull('store_id')->orWhere('store_id', $shopifyStore->id);
        })->orderBy('porder')->get();
        return view('shopify.plans', array("request" => $request, "shopifyPlans" => $shopifyPlans));
    }

    public function ajaxHandler(Request $request)
    {
        $response = $request->all();
        $requestOp = ($request->has('op')) ? $request->input('op') : "";
        if ($requestOp == "addAppCharge") {
            $response = $this->addAppCharge($request);
            if (!$response) {
                $response = $request->all();
            }

            //$response = array("redirect_url" => $redirectUrl);
        }
        return response()->json($response);
    }

    public function installAuth(Request $request)
    {
        try {
            PHPShopify\ShopifySDK::config(array(
                'ShopUrl' => $request->input('shop'),
                'ApiKey' => config('shopify.api_key'),
                'SharedSecret' => config('shopify.shared_secret'),
                'ApiVersion' => config('shopify.api_version'))
            );
            //print_r($request);
            if ($request->has('code') && $request->has('shop') && PHPShopify\AuthHelper::verifyShopifyRequest()) {
                //echo "123";
                $plan_id = 1;

                $accessToken = PHPShopify\AuthHelper::getAccessToken();
                //    echo "tokensff".$accessToken;
                //$accessToken =
                if ($accessToken) {
                    $shopify_url = $request->input('shop');

                    try {

                        
                        // $shopifyClient = new PHPShopify\ShopifySDK(array('ShopUrl' => $shopify_url, 'AccessToken' => $accessToken, 'ApiVersion' => config('shopify.api_version')));

                        $config = array('ShopUrl' => $shopify_url, 'AccessToken' => $accessToken, 'ApiVersion' => config('shopify.api_version'));
                        $shopifyClient = new PHPShopify\ShopifySDK($config);

                        $shopData = $shopifyClient->Shop()->get();
                        sleep(1);
                        $frontend_url = (strpos($shopData["domain"], "http") === false) ? "http://" . $shopData["domain"] : $shopData["domain"];
                        if (strpos($frontend_url, "https://") === false) {
                            $frontend_url = "https://" . $shopData["domain"];
                        }

                        $store_name = $shopData["name"];

                        if (true) {
                            try {
                                $route = route('orderFulfilledWebhookShopify');
                                $route1 = $route . "?key=" . $shopify_url;
                                $webhooks = array(
                                    //array("topic" => "app/uninstalled","address" => route('appUninstallWebhook')),
                                    //    array("topic" => "products/create","address" => 'arn:aws:events:ap-south-1::event-source/aws.partner/shopify.com/51630178305/professionalebayimporter'),

                                    array("topic" => "products/create", "address" => route('productUpdateWebhookShopify')),
                                    array("topic" => "products/update", "address" => route('productUpdateWebhookShopify')),
                                    array("topic" => "products/delete", "address" => route('productDeleteWebhookShopify')),
                                    array("topic" => "inventory_levels/update", "address" => route('inventoryLevelWebhookShopify')),
                                    array("topic" => "orders/delete", "address" => route('orderDeleteWebhookShopify')),
                                    array("topic" => "orders/cancelled", "address" => route('orderCancelWebhookShopify')),
                                    //    array("topic" => "orders/fulfilled","address" => route('orderFulfilledWebhookShopify'))
                                    array("topic" => "orders/fulfilled", "address" => route('orderFulfilledWebhookShopify')),
                                );

                                foreach ($webhooks as $webhook) {
                                    try {
                                        $topic = $webhook["topic"];
                                        //    $address = "arn:aws:events:ap-south-1::event-source/aws.partner/shopify.com/2469719/Shopify-Webhook-Ebay-App";
                                        $webhookData = array("topic" => $topic, "address" => $address, "format" => "json");
                                        $shopifyClient->Webhook()->post($webhookData);
                                        sleep(1);
                                    } catch (\Exception $e) {
                                        report($e);
                                    }
                                }

                                try {
                                    $webhookData = array(
                                        "topic" => "app/uninstalled",
                                        "address" => route('appUninstallWebhook'),
                                        "format" => "json",
                                    );
                                    $shopifyClient->Webhook()->post($webhookData);
                                    sleep(1);
                                } catch (\Exception $e) {
                                    report($e);
                                }
                            } catch (\Exception $e) {
                                report($e);
                            }

                        }

                        //echo "Before data";

                        $createDatabase = false;
                        $user_id = 0;
                        $shopify_store_id = 0;
                        $status = "installed";
                        //$tokennew ='';
                        $shopifyStore = ShopifyStore::where("shopify_url", $shopify_url)->first();
                        if ($shopifyStore) {
                            $status = $shopifyStore->status;
                            $storeData = array("store_name" => $store_name, "frontend_url" => $frontend_url, "access_token" => $accessToken, "plan_id" => $plan_id, "import_products" => 1, "install_step" => 1, "installed_at" => date("Y-m-d H:i:s"), "status" => "active", "shop_data" => json_encode($shopData));
                            if ($status == "active") {
                                $storeData = array("store_name" => $store_name, "frontend_url" => $frontend_url, "access_token" => $accessToken, "shop_data" => json_encode($shopData));
                            } else {
                                $user_id = $shopifyStore->user_id;
                                $shopify_store_id = $shopifyStore->id;
                            }
                            $shopifyStore->update($storeData);
                            //echo "up122323";
                        } else {
                            $shopName = explode(" ", $shopData["name"]);
                            $name = $shopData["name"];
                            $sh_store_id = $shopData["id"];
                            $password = Hash::make("@" . $sh_store_id);
                            $email = $shopData["email"];
                            $user = User::where('email', $email)->first();
                            if ($user) {
                            } else {
                                $token = \Str::random(60) . time();
                                $api_token = hash('sha256', $token);
                                $userData = array("name" => $name, "email" => $shopData["email"], "password" => $password, "status" => "active", "type" => "user", "api_token" => $api_token);
                                $user = new User;
                                $user->fill($userData);
                                $user->save();
                            }
                            if (isset($user->id) && $user->id) {
                                try {
                                    $locations = array();
                                    try {
                                        $shLocations = $shopifyClient->Location()->get();
                                        if ($shLocations) {
                                            foreach ($shLocations as $shLocation) {
                                                if ($shLocation["active"]) {
                                                    $locations[] = $shLocation["id"];
                                                }

                                            }
                                        }
                                    } catch (\Exception $e) {report($e);}

                                    $locations = ($locations) ? implode(",", $locations) : null;

                                    $login_token = md5(microtime() . rand());

                                    $storeData = array("login_token" => $login_token, "source" => "app_store", "locations" => $locations, "shopify_store_id" => $shopData["id"], "store_name" => $store_name, "shopify_url" => $shopify_url, "frontend_url" => $frontend_url, "access_token" => $accessToken, "plan_id" => $plan_id, "install_step" => 1, "installed_at" => date("Y-m-d H:i:s"), "status" => "active", "shop_data" => json_encode($shopData), "user_id" => $user->id);

                                    $shopifyStore = new ShopifyStore;
                                    $shopifyStore->fill($storeData);
                                    $shopifyStore->save();
                                    $createDatabase = true;
                                    $user_id = $user->id;
                                    $shopify_store_id = $shopifyStore->id;
                                } catch (\Exception $e) {
                                    report($e);
                                    return response()->json(['status' => 'error', 'msg' => 'Unable to setup store'], 403);
                                }
                            } else {
                                return response()->json(['status' => 'error', 'msg' => 'Unable to register store'], 403);
                            }
                        }
                        //echo   "gsdghsfjkg".$createDatabase;
                        if ($createDatabase) {
                            $store_database_name = config('config.store_db_prefix') . $shopify_store_id;
                            try {
                                DB::statement('CREATE DATABASE IF NOT EXISTS `' . $store_database_name . '` CHARACTER SET ' . config('database.connections.' . config('database.default') . '.charset') . ' COLLATE ' . config('database.connections.' . config('database.default') . '.collation'));
                                AppHelper::setConnection($store_database_name, $shopifyStore);
                            } catch (\Exception $e) {
                                report($e);
                            }

                            try {
                                ProcessDatabaseMigration::dispatchNow($shopify_url);
                            } catch (\Exception $e) {
                                report($e);

                                try {
                                    $mailData = array();
                                    $mailData["mail_subject"] = "App Install Error";
                                    $mailData["title"] = "App Install Database Setup Error";
                                    $mailData["description"] = "Error : " . $e->getMessage() . " | Shopify URL : " . $shopify_url;
                                    $mailData["link"] = "";
                                    $mailData["link_text"] = "";
                                    Mail::to(config('config.notify_email'))->send(new Notification($mailData));
                                } catch (\Exception $e) {
                                    report($e);
                                }

                                return response()->json(['status' => 'error', 'msg' => 'error with installation'], 403);
                            }
                        }
                        //return redirect()->to("https://app1.ecomshore.com/cp?login_token=".$api_token."&shop=".$shopify_url);
                        //    return redirect()->to("https://".$shopify_url."/admin/apps/".config('shopify.api_key'));
                        return redirect()->to("https://app1.ecomshore.com/cp?login_token=" . $shopifyStore->login_token . "&shop=" . $shopify_url);
                    } catch (\Exception $e) {
                        report($e);
                        return response()->json(['status' => 'error', 'msg' => $e->getMessage()], 403);
                    }
                } else {
                    return response()->json(['status' => 'error', 'msg' => 'Unable to generate access token'], 403);
                }
            } else {
                return response()->json(['status' => 'error', 'msg' => "invalid request"], 403);
            }
        } catch (\Exception $e) {
            report($e);
            return response()->json(['status' => 'error', 'msg' => $e->getMessage()], 403);
        }
    }

    public function installAuthshtoebay(Request $request)
    {

        $ownername = "";
        $email = "";
        $shopify_url = "";
        $login_token1 = "";
        $token = "";
        $created_at = "";
        $updated_at = "";
        $sellerid = "";
        $Ebaytoken = "";
        $siteid = 0;
        $shopifylocationid = "";
        $shopifylocation = "";
        $postalcodefromshopify = 0;
        $frontend_url = "";
        $EbayItemId = "";
        $shopname = "";

        if ($request->input('tt')) {
            //print_r("helooooooooooo");
            $ddValue = $request->input('tt');
            $dataArray = base64_decode($ddValue);
            $decodedData = json_decode($dataArray, true);
            log::info("ygyuguyguyguyguy" . json_encode($decodedData, true));
            log::info("shopurl" . $decodedData['shopurl']);
            if (isset($decodedData['shopurl'])) {
                $shopify_url = $decodedData['shopurl'];
            }
            if (isset($decodedData['email'])) {
                log::info("email" . $decodedData['email']);
                $email = $decodedData['email'];
                $useralreadyexist = User::where('email', $email)->first();
                if ($useralreadyexist) {
                    log::info("user already exists");
                    return redirect()->to("https://cp.infoshoreapps.com/shopifytoeb.php?shop=" . $shopify_url);
                }//todo send true,200 
            }
            if (isset($decodedData['ownername'])) {
                log::info("ownername" . $decodedData['ownername']);
                $ownername = $decodedData['ownername'];
            }

            if (isset($decodedData['shopurl'])) {

                $shopify_url = $decodedData['shopurl'];
            }
            if (isset($decodedData['login_token'])) {
                log::info("login_token" . $decodedData['login_token']);
                $login_token1 = $decodedData['login_token'];
            }

            if ($decodedData['token']) {
                $shop_token = $decodedData['token'];
                log::info("token  is this -> " . $shop_token);
            }
            if (isset($decodedData['created_at'])) {
                $created_at = $decodedData['created_at'];
            }
            if (isset($decodedData['updated_at'])) {
                $updated_at = $decodedData['updated_at'];
            }
            if (isset($decodedData['sellerid'])) {
                $sellerid = $decodedData['sellerid'];
            }
            if (isset($decodedData['Ebaytoken'])) {
                $Ebaytoken = $decodedData['Ebaytoken'];
            }
            if (isset($decodedData['siteid'])) {
                $siteid = $decodedData['siteid'];
            }
            if (isset($decodedData['shopifylocationid'])) {
                $shopifylocationid = $decodedData['shopifylocationid'];
            }
            if (isset($decodedData['EbayItemId'])) {
                $EbayItemId = $decodedData['EbayItemId'];
            }

            log::info("shopify_url  is this -> " . $shopify_url);
            // $shopifyClient = new PHPShopify\ShopifySDK(array('ShopUrl' => $shopify_url, 'AccessToken' => $shop_token, 'ApiVersion' => config('shopify.api_version')));
            
            $config = array('ShopUrl' => $shopify_url, 'AccessToken' => $shop_token, 'ApiVersion' => config('shopify.api_version'));
            $shopifyClient = new PHPShopify\ShopifySDK($config);
            
            $shopData = $shopifyClient->Shop()->get();
            //         print_r($shopData);
            //         die();
            $token = \Str::random(60) . time();
            log::info("token  is this -> " . $token);
            $api_token = hash('sha256', $token);
          log::info("api_token  is this -> " . $api_token);
            $shopname = $shopData["name"];

            $postalcodefromshopify = $shopData["zip"];
            $shopifylocation = $shopData["city"];

            $users = new User;
            $users->name = $ownername;
            $users->email = $email;
            $users->api_token = $api_token;
            $users->status = "active";
            $users->save();
            $UserData = $users->where("api_token", $api_token)->first();
            //     print_r("here is the data ".$UserData);
            $logintoken = "yes";
            $shopifyStore = new ShopifyStore;
            $shopifyStore->store_name = $shopData["name"];
            $shopifyStore->shopify_store_id = $shopData["id"];
            $shopifyStore->shopify_url = $shopify_url;
            $shopifyStore->frontend_url = $frontend_url ? $frontend_url : $shopData["primary_location_id"];
            $shopifyStore->access_token = $shop_token;
            $shopifyStore->install_step = "done";
            $shopifyStore->user_id = $UserData->id;
            $shopifyStore->login_token = $logintoken;
            $shopifyStore->plan_id = 1;
            $shopifyStore->save();
            $shopifyStoredata = $shopifyStore->where("user_id", $UserData->id)->first();

            log::info("here is the data " . $shopifyStoredata);
            //   die();

            $ebayaccount = new EbayAccount;
            $ebayaccount->name = $shopData["name"];
            $ebayaccount->access_token = $Ebaytoken;
            $ebayaccount->token_type = "eBayAuthToken";
            $ebayaccount->siteid = $siteid;
            $ebayaccount->is_valid = 1;
            $ebayaccount->store_id = $shopifyStoredata->id;
            $ebayaccount->user_id = $UserData->id;
            $ebayaccount->sellerid = $sellerid;
            $ebayaccount->save();

        }

        if ($request->input('shop')) {
            $shopify_url = $request->input('shop');
        }

        if ($request->input('login_token')) {
            $login_token = $request->input('login_token');
        }

        $shopifyStore = ShopifyStore::where('shopify_url', $shopify_url)->first();

        //  if($shopifyStore){
        //      print_r($shopifyStore);

        //  }
        //  else{

        //      print_r("not");

        ////  }
        //echo $shopifyStore;

        $tolog = $shopifyStore->login_token;
        // echo $tolog;
        $login_tokenafter = 0;
        $accessToken = $shopifyStore->access_token;
        $plan_id = 1;
        log::info("here is the accessToken ".$accessToken);

        if ($tolog == 'yes') {

            Log::info(" In shopifycontroller  installAuthshtoebay  method ");

            // $shopifyClient = new PHPShopify\ShopifySDK(array('ShopUrl' => $shopify_url, 'AccessToken' => $accessToken, 'ApiVersion' => config('shopify.api_version')));

            $config = array('ShopUrl' => $shopify_url, 'AccessToken' => $accessToken, 'ApiVersion' => config('shopify.api_version'));
            $shopifyClient = new PHPShopify\ShopifySDK($config);

            $shopData = $shopifyClient->Shop()->get();
            log::info("here is the shopdata ".json_encode($shopData,true));
            sleep(1);
            $frontend_url = (strpos($shopData["domain"], "http") === false) ? "http://" . $shopData["domain"] : $shopData["domain"];

            //echo     $frontend_url;

            $createDatabase = false;
            // $webhookenable = false;
            $user_id = 0;
            $shopify_store_id = 0;
            $status = "installed";

            if ($shopifyStore) {
                $status = $shopifyStore->status;
                $login_token = md5(microtime() . rand());
                $tolog = $login_token;
                $locations = array();

                $shLocations = $shopifyClient->Location()->get();
                if ($shLocations) {
                    foreach ($shLocations as $shLocation) {
                        if ($shLocation["active"]) {
                            $locations[] = $shLocation["id"];
                        }

                    }
                }
                $locations = ($locations) ? implode(",", $locations) : null;
                $storeData = array("source" => "app_store", "login_token" => $login_token, "locations" => $locations, "frontend_url" => $frontend_url, "access_token" => $accessToken, "plan_id" => $plan_id, "import_products" => 1, "install_step" => 1, "installed_at" => date("Y-m-d H:i:s"), "status" => "active", "shop_data" => json_encode($shopData), "created_at" => date("Y-m-d H:i:s"), "updated_at" => date("Y-m-d H:i:s"));

                $user_id = $shopifyStore->user_id;
                $shopify_store_id = $shopifyStore->id;

                $shopifyStore->update($storeData);
                //$email = $shopData["email"];
               // if($email)
                $user = User::where('email', $email)->first();

                $token = \Str::random(60) . time();
                $api_token = hash('sha256', $token);
                $sh_store_id = $shopData["id"];
                $password = Hash::make("@" . $sh_store_id);
                
                 log::info("here is the api_token ".$api_token);
                  log::info("here is the password ".$password);
                  
                $userData = array("password" => $password, "api_token" => $api_token);
                  log::info("here is the userData array ->".json_encode($userData,true));

                $user->update($userData);

                $createDatabase = true;

                Log::info(" In shopifycontroller  installAuthshtoebay  method create db equal to true ");

            }
           // $user_id12 = $shopifyStore->user_id;
            if ($createDatabase) {
                $store_database_name = config('config.store_db_prefix') . $shopify_store_id;
                Log::info(" new db name 	$store_database_name ");
                try {
                    DB::statement('CREATE DATABASE IF NOT EXISTS `' . $store_database_name . '` CHARACTER SET ' . config('database.connections.' . config('database.default') . '.charset') . ' COLLATE ' . config('database.connections.' . config('database.default') . '.collation'));
                    AppHelper::setConnection($store_database_name, $shopifyStore);
                    Log::info(" new db name 	after apphelper try ");
                } catch (\Exception $e) {
                    report($e);
                }

                try {
                    ProcessDatabaseMigration::dispatchNow($shopify_url);
                    Log::info(" new db name 	ProcessDatabaseMigration ");
                } catch (\Exception $e) {
                    report($e);
                    Log::info(" new db name email ");
                    try {
                        $mailData = array();
                        $mailData["mail_subject"] = "App Install Error";
                        $mailData["title"] = "App Install Database Setup Error";
                        $mailData["description"] = "Error : " . $e->getMessage() . " | Shopify URL : " . $shopify_url;
                        $mailData["link"] = "";
                        $mailData["link_text"] = "";
                        Mail::to(config('config.notify_email'))->send(new Notification($mailData));
                    } catch (\Exception $e) {
                        report($e);
                    }

                    return response()->json(['status' => 'error', 'msg' => 'error with installation'], 403);
                }
                Log::info(" new db name created ");
            }

            if ($EbayItemId != "Not Found") {
                Log::info("here is the ebayitem id found in install auth to eb ");
                $ebay_environment = '';

                $ebayCredentials = array(
                    'credentials' => [
                        'devId' => config('ebay.' . $ebay_environment . 'devid'),
                        'appId' => config('ebay.' . $ebay_environment . 'appid'),
                        'certId' => config('ebay.' . $ebay_environment . 'certid'),
                    ],
                    'authToken' => '',
                    'oauthUserToken' => '',
                    'ruName' => config('ebay.' . $ebay_environment . 'RuName'),
                );

                $shopify_store_id = $shopifyStore->id;

                $store_database_name = config('config.store_db_prefix') . $shopify_store_id;
                //AppHelper::setConnection($store_database_name,$shopifyStore[0]);
                AppHelper::setConnection($store_database_name, $shopifyStore);

                $ebayService = new Services\TradingService([
                    'credentials' => $ebayCredentials['credentials'],
                    'sandbox' => ($ebay_environment == "sandbox_") ? true : false,
                    'siteId' => $siteid,
                ]);
                $ebayItem = [];
                $ebayItemRequest = new Types\GetItemRequestType();
                $ebayItemRequest->RequesterCredentials = new Types\CustomSecurityHeaderType();
                $ebayItemRequest->RequesterCredentials->eBayAuthToken = $Ebaytoken;
                $ebayItemRequest->ItemID = $EbayItemId;
                $ebayItemRequest->IncludeItemSpecifics = true;
                $ebayItemResponse = $ebayService->getItem($ebayItemRequest);
                $ebayItemResponse = $ebayItemResponse->toArray();
                if (isset($ebayItemResponse["Item"]) && $ebayItemResponse["Item"]) {
                    $ebayItem = $ebayItemResponse["Item"];
                }

                if (!$ebayItem);
                Log::info("here is the ebay response " . json_encode($ebayItem, true));

                if ((isset($ebayItem["SKU"]))) {
                    $sku = $ebayItem["SKU"];
                }

                if (!isset($ebayItem["Quantity"]) || !$ebayItem["Quantity"]) {
                    $ebayItem["Quantity"] = 0;
                }

                $item_site = (isset($ebayItem["Site"])) ? $ebayItem["Site"] : "";
                //    $item_site_id = ($item_site) ? EbayHelper::getEbaySiteIDFromSite($item_site) : null;
                $CategoryID = $ebayItem["PrimaryCategory"]["CategoryID"];
                $ebaycategory = EbayCategory::where('ebay_category_id', $CategoryID)->first();
                $eBayCategoryID = $ebaycategory->id;
                Log::info("here is the eBay Category ID " . $eBayCategoryID);
                $CategoryName = $ebayItem["PrimaryCategory"]["CategoryName"];
                //$CityName = $ebayItem["RegistrationAddress"]["CityName"];
                $CityName = $ebayItem["Location"];

                $PostalCode = $ebayItem["PostalCode"];
                Log::info("here is the Postal Code " . $PostalCode);
                Log::info("here is the Postal Code data type" . gettype($PostalCode));
                $ConditionID = $ebayItem["ConditionID"];
                $ListingDuration = $ebayItem["ListingDuration"];
                $listing_format = ($ebayItem["ListingType"] == "FixedPriceItem") ? "fixed_price" : "auction";

                ///////////////////////////////////////////////////////////////////
                //         $item_specific_data = EbayCategory::where('id',$eBayCategoryID)->where('ebay_site', $siteid)->first();

                //         $item_specifics = $item_specific_data->category_attributes;

                //   Log::info(' here is the item specifics '.json_encode($item_specifics,true));

                //          foreach(json_decode($item_specifics,true) as $item_specific){
                //         if(isset($item_specific['values'][0])){
                //          $name = $item_specific["name"];
                //               $values = $item_specific['values'][0];
                //       //$arr[] = array($name => $values);
                //         $arr[$name] = $values;
                //            Log::info(' here is the name '.$name . ' and here is the first value of it '.$values);
                //             }else{
                //               continue;
                //               }

                //          }
                //              Log::info(' here is the array '.json_encode($arr,true));

                /////////////////////////////////////////////////////////////////////////////////////

                $profile = new Profile;
                $profile->name = $shopname;
                $profile->trim_title = 1;
                $profile->is_default_profile = 1;
                // $profile->listing_title = "active";
                //  $profile->product_id_type = "active";
                $profile->item_condition = $ConditionID;
                $profile->ebay_category_1 = $eBayCategoryID;
                // $profile->store_category = "active";
                $profile->listing_format = $listing_format;
                $profile->listing_duration = $ListingDuration;
                $profile->domestic_shipping = "Flat";
                $profile->domestic_ship_service1 = "USPSFirstClass";
                $profile->domestic_free_shipping = 1;
                $profile->ship_fee1 = 100.00;
                $profile->x_ship_fee1 = 0.00;
                $profile->domestic_free_shipping = 0;
                $profile->domestic_local_pickup = 0;
                $profile->domestic_ships_within_handling_days = 2;
                $profile->domestic_pkg_handling_fee = 0.00;

                if ($shopifylocation != '') {
                    $profile->item_location = $shopifylocation;
                } else {
                    $profile->item_location = $CityName;
                }

                //  $profile->item_specifics  = json_encode($arr);

                if ($postalcodefromshopify != 0) {
                    $profile->postal_code = $postalcodefromshopify;
                } else {
                    $profile->postal_code = $PostalCode;
                }

                $profile->store_id = $shopifyStore->id;
                $profile->user_id = $shopifyStore->user_id;
                $profile->save();

            } else {
                /////////////////////////////////////////////////////////////////////////////////////////////

                //  $item_specific_data = EbayCategory::where('id',4408)->where('ebay_site', $siteid)->first();

                //                                 $item_specifics = $item_specific_data->category_attributes;

                //                           Log::info(' here is the item specifics '.json_encode($item_specifics,true));

                //                                  foreach(json_decode($item_specifics,true) as $item_specific){
                //                                 if(isset($item_specific['values'][0])){
                //                                  $name = $item_specific["name"];
                //                                       $values = $item_specific['values'][0];
                //                               //$arr[] = array($name => $values);
                //                                 $arr[$name] = $values;
                //                                        Log::info(' here is the name '.$name . ' and here is the first value of it '.$values);
                //                                     }else{
                //                                       continue;
                //                                       }

                //                                  }
                //                                      Log::info(' here is the array '.json_encode($arr,true));

                //////////////////////////////////////////////////////////////////////////////////////////

                Log::info("ebay item id not found ");
                $profile = new Profile;
                $profile->name = $shopname;
                $profile->trim_title = 1;
                $profile->is_default_profile = 1;
                // $profile->listing_title = "active";
                //  $profile->product_id_type = "active";
                $profile->item_condition = 1000;
                $profile->ebay_category_1 = 4408;
                // $profile->store_category = "active";
                $profile->listing_format = "fixed price";
                $profile->listing_duration = "GTC";

                $profile->domestic_shipping = "Flat";
                $profile->domestic_ship_service1 = "USPSFirstClass";
                $profile->domestic_free_shipping = 1;
                $profile->ship_fee1 = 100.00;
                $profile->x_ship_fee1 = 0.00;
                $profile->domestic_free_shipping = 0;
                $profile->domestic_local_pickup = 0;
                $profile->domestic_ships_within_handling_days = 2;
                $profile->domestic_pkg_handling_fee = 0.00;
                // $profile->item_specifics  = json_encode($arr);

                if ($shopifylocation != '') {
                    $profile->item_location = $shopifylocation;
                } else {
                    $profile->item_location = "United States";
                }

                //  $profile->item_specifics  = json_encode($arr);
                if ($postalcodefromshopify != 0) {
                    $profile->postal_code = $postalcodefromshopify;
                } else {
                    $profile->postal_code = 32792;
                }

                $profile->store_id = $shopifyStore->id;
                $profile->user_id = $shopifyStore->user_id;
                $profile->save();
            }

            $shopifyStore->import_products = 1;
            $shopifyStore->save();

            //    return redirect()->to("https://app1.ecomshore.com/cp?login_token=".$tolog."&shop=".$shopify_url);

            //return redirect()->to("https://cp.infoshoreapps.com/shopifytoeb.php?shop=".$shopify_url);
            return response()->json(["shop" => $shopify_url, 'token' => $tolog, "database" => "confirm"], 200);
            //    return redirect()->to("https://cp.infoshoreapps.com/shopifytoeb.php?shop=".$shopify_url."?token=".$tolog."?database=confirm");
            //    return redirect()->to("https://cp.infoshoreapps.com/shopifytoeb.php?shop=".$shopify_url."?login=true");
            //exit(0);

        } else {
           // return redirect()->to("https://cp.infoshoreapps.com/shopifytoeb.php");                /////////////////////////////////todo return error and mail 
            //    return redirect()->to("https://cp.infoshoreapps.com/shopifytoeb.php?shop=".$shopify_url."?login=true");
            // return redirect()->to("https://app1.ecomshore.com/cp?login_token=".$tolog."&shop=".$shopify_url);

        }

    }


        public function installAuthshtoebaytest(Request $request)
         {
    
            $ownername = "";
            $email = "";
            $shopify_url = "";
            $login_token1 = "";
            $token = "";
            $created_at = "";
            $updated_at = "";
            $sellerid = "";
            $Ebaytoken = "";
            $siteid = 0;
            $shopifylocationid = "";
            $shopifylocation = "";
            $postalcodefromshopify = 0;
            $frontend_url = "";
            $EbayItemId = "";
            $shopname = "";
            //////////////////////////
            $shopData = [];
            $users = new User;
            $shopifyStore = new ShopifyStore;
            /////////////////////////////

            if ($request->input('tt')) {
              
                $ddValue = $request->input('tt');
                $dataArray = base64_decode($ddValue);
                $decodedData = json_decode($dataArray, true);
               
                if (isset($decodedData['shopurl'])) {
                    $shopify_url = $decodedData['shopurl'];
                }
                if (isset($decodedData['email'])) {
                    log::info("email" . $decodedData['email']);
                    $email = $decodedData['email'];
                    $useralreadyexist = User::where('email', $email)->first();
                    if ($useralreadyexist) {
                        log::info("user already exists");
                        return response()->json(["database" => "Already Exist"], 200);
                    }
                }
                if (isset($decodedData['ownername'])) {
                    log::info("ownername" . $decodedData['ownername']);
                    $ownername = $decodedData['ownername'];
                }
    
                if (isset($decodedData['shopurl'])) {
    
                    $shopify_url = $decodedData['shopurl'];
                }
                if (isset($decodedData['login_token'])) {
                    log::info("login_token" . $decodedData['login_token']);
                    $login_token1 = $decodedData['login_token'];
                }
    
                if ($decodedData['token']) {
                    $shop_token = $decodedData['token'];
                    log::info("token  is this -> " . $shop_token);
                }
                if (isset($decodedData['created_at'])) {
                    $created_at = $decodedData['created_at'];
                }
                if (isset($decodedData['updated_at'])) {
                    $updated_at = $decodedData['updated_at'];
                }
                if (isset($decodedData['sellerid'])) {
                    $sellerid = $decodedData['sellerid'];
                }
                if (isset($decodedData['Ebaytoken'])) {
                    $Ebaytoken = $decodedData['Ebaytoken'];
                }
                if (isset($decodedData['siteid'])) {
                    $siteid = $decodedData['siteid'];
                }
                if (isset($decodedData['shopifylocationid'])) {
                    $shopifylocationid = $decodedData['shopifylocationid'];
                }
                if (isset($decodedData['EbayItemId'])) {
                    $EbayItemId = $decodedData['EbayItemId'];
                }
    
                log::info("shopify_url  is this -> " . $shopify_url);

                // $shopifyClient = new PHPShopify\ShopifySDK(array('ShopUrl' => $shopify_url, 'AccessToken' => $shop_token, 'ApiVersion' => config('shopify.api_version')));

                $config = array('ShopUrl' => $shopify_url, 'AccessToken' => $shop_token, 'ApiVersion' => config('shopify.api_version'));
                $shopifyClient = new PHPShopify\ShopifySDK($config);

                $shopData = $shopifyClient->Shop()->get();
            
                $token = \Str::random(60) . time();
                $api_token = hash('sha256', $token);
                $shopname = $shopData["name"];
    
                $postalcodefromshopify = $shopData["zip"];
                $shopifylocation = $shopData["city"];
    
                // $users = new User;
                $users->name = $ownername;
                $users->email = $email;
                $users->api_token = $api_token;
                $users->status = "active";
                $users->save();
                
                //please verify id
              //  $UserData = $users->where("api_token", $api_token)->first();
              
                // $shopifyStore = new ShopifyStore;
                $shopifyStore->store_name = $shopData["name"];
                $shopifyStore->shopify_store_id = $shopData["id"];
                $shopifyStore->shopify_url = $shopify_url;
                $shopifyStore->frontend_url = $frontend_url ? $frontend_url : $shopData["primary_location_id"];
                $shopifyStore->access_token = $shop_token;
                $shopifyStore->install_step = "done";
                $shopifyStore->user_id = $users->id;
                $shopifyStore->login_token = $login_token1;
                $shopifyStore->plan_id = 1;
                $shopifyStore->save();
                
                
                
             //   $shopifyStoredata = $shopifyStore->where("user_id", $UserData->id)->first();
    
              
    
                $ebayaccount = new EbayAccount;
                $ebayaccount->name = $shopData["name"];
                $ebayaccount->access_token = $Ebaytoken;
                $ebayaccount->token_type = "eBayAuthToken";
                $ebayaccount->siteid = $siteid;
                $ebayaccount->is_valid = 1;
                $ebayaccount->store_id = $shopifyStore->id;
                $ebayaccount->user_id = $users->id;
                $ebayaccount->sellerid = $sellerid;
                $ebayaccount->save();
    
            }
          
             $tolog = $login_token1;
            
            $accessToken = $shopifyStore->access_token;
            
            $plan_id = 1;
            log::info("here is the accessToken ".$accessToken);
    
            if ($tolog == 'yes') {
    
                sleep(1);
             try {
                       
                $frontend_url = (strpos($shopData["domain"], "http") === false) ? "http://" . $shopData["domain"] : $shopData["domain"];
    
                $createDatabase = false;
                // $webhookenable = false;
               
                $status = "installed";
    
                if ($shopifyStore) {
                    $status = $shopifyStore->status;
                    $login_token = md5(microtime() . rand());
                    $tolog = $login_token;
                    $locations = array();
    
                    $shLocations = $shopifyClient->Location()->get();
                    if ($shLocations) {
                        foreach ($shLocations as $shLocation) {
                            if ($shLocation["active"]) {
                                $locations[] = $shLocation["id"];
                            }
    
                        }
                    }
                    $locations = ($locations) ? implode(",", $locations) : null;
                    $storeData = array("source" => "app_store", "login_token" => $login_token, "locations" => $locations, "frontend_url" => $frontend_url, "access_token" => $accessToken, "plan_id" => $plan_id, "installed_at" => date("Y-m-d H:i:s"), "status" => "active", "shop_data" => json_encode($shopData), "created_at" => date("Y-m-d H:i:s"), "updated_at" => date("Y-m-d H:i:s"));
    
                    // $user_id = $shopifyStore->user_id;
                    // $shopify_store_id = $shopifyStore->id;
    
                    $shopifyStore->update($storeData);
                 
                    $sh_store_id = $shopData["id"];

                    $password = Hash::make("@" . $sh_store_id);
                    
                    $users_arr = array("password" => $password);
                  
                    $users->update($users_arr);
    
                    $createDatabase = true;
    
                    Log::info(" In shopifycontroller  installAuthshtoebay  method create db equal to true ");
    
                }
               
                if ($createDatabase) {
                    
                
                    $store_database_name = config('config.store_db_prefix') . $shopifyStore->id;
              
                    try {
                        DB::statement('CREATE DATABASE IF NOT EXISTS `' . $store_database_name . '` CHARACTER SET ' . config('database.connections.' . config('database.default') . '.charset') . ' COLLATE ' . config('database.connections.' . config('database.default') . '.collation'));
                        AppHelper::setConnection($store_database_name, $shopifyStore);
                        Log::info(" new db name	after apphelper try ");
                    } catch (\Exception $e) {
                        report($e);
                    }
    
                    try {
                        ProcessDatabaseMigration::dispatchNow($shopify_url);
                        Log::info(" new db name	ProcessDatabaseMigration ");
                    } catch (\Exception $e) {
                        report($e);
                     
                        try {
                    
                            $useremail = "pankajnarang81@gmail.com";
                            $errormsg = $e->getMessage();
                           	$sdfsjf = FailDBCreationMail::sendKeysMail($useremail,$errormsg);
                        } catch (\Exception $e) {
                            report($e);
                        }
    
                        return response()->json(['status' => 'error', 'msg' => 'error with installation'], 403);
                    }
                    Log::info(" new db name created ");
                }
    
                if ($EbayItemId != "Not Found") {
                    Log::info("here is the ebayitem id found in install auth to eb ");
                    $ebay_environment = '';
    
                    $ebayCredentials = array(
                        'credentials' => [
                            'devId' => config('ebay.' . $ebay_environment . 'devid'),
                            'appId' => config('ebay.' . $ebay_environment . 'appid'),
                            'certId' => config('ebay.' . $ebay_environment . 'certid'),
                        ],
                        'authToken' => '',
                        'oauthUserToken' => '',
                        'ruName' => config('ebay.' . $ebay_environment . 'RuName'),
                    );
    
                    $shopify_store_id = $shopifyStore->id;
    
                    $store_database_name = config('config.store_db_prefix') . $shopify_store_id;
                    //AppHelper::setConnection($store_database_name,$shopifyStore[0]);
                    AppHelper::setConnection($store_database_name, $shopifyStore);
    
                    $ebayService = new Services\TradingService([
                        'credentials' => $ebayCredentials['credentials'],
                        'sandbox' => ($ebay_environment == "sandbox_") ? true : false,
                        'siteId' => $siteid,
                    ]);
                    $ebayItem = [];
                    $ebayItemRequest = new Types\GetItemRequestType();
                    $ebayItemRequest->RequesterCredentials = new Types\CustomSecurityHeaderType();
                    $ebayItemRequest->RequesterCredentials->eBayAuthToken = $Ebaytoken;
                    $ebayItemRequest->ItemID = $EbayItemId;
                    $ebayItemRequest->IncludeItemSpecifics = true;
                    $ebayItemResponse = $ebayService->getItem($ebayItemRequest);
                    $ebayItemResponse = $ebayItemResponse->toArray();
                    if (isset($ebayItemResponse["Item"]) && $ebayItemResponse["Item"]) {
                        $ebayItem = $ebayItemResponse["Item"];
                    }
    
                    if (!$ebayItem);
                    Log::info("here is the ebay response " . json_encode($ebayItem, true));
    
                    if ((isset($ebayItem["SKU"]))) {
                        $sku = $ebayItem["SKU"];
                    }
    
                    if (!isset($ebayItem["Quantity"]) || !$ebayItem["Quantity"]) {
                        $ebayItem["Quantity"] = 0;
                    }
    
                    $item_site = (isset($ebayItem["Site"])) ? $ebayItem["Site"] : "";
                    //    $item_site_id = ($item_site) ? EbayHelper::getEbaySiteIDFromSite($item_site) : null;
                    $CategoryID = $ebayItem["PrimaryCategory"]["CategoryID"];
                    $ebaycategory = EbayCategory::where('ebay_category_id', $CategoryID)->first();
                    $eBayCategoryID = $ebaycategory->id;
                    Log::info("here is the eBay Category ID " . $eBayCategoryID);
                    $CategoryName = $ebayItem["PrimaryCategory"]["CategoryName"];
                    //$CityName = $ebayItem["RegistrationAddress"]["CityName"];
                    $CityName = $ebayItem["Location"];
    
                    $PostalCode = $ebayItem["PostalCode"];
                    Log::info("here is the Postal Code " . $PostalCode);
                    Log::info("here is the Postal Code data type" . gettype($PostalCode));
                    $ConditionID = $ebayItem["ConditionID"];
                    $ListingDuration = $ebayItem["ListingDuration"];
                    $listing_format = ($ebayItem["ListingType"] == "FixedPriceItem") ? "fixed_price" : "auction";
    
    
                    $profile = new Profile;
                    $profile->name = $shopname;
                    $profile->trim_title = 1;
                    $profile->is_default_profile = 1;
                    // $profile->listing_title = "active";
                    //  $profile->product_id_type = "active";
                    $profile->item_condition = $ConditionID;
                    $profile->ebay_category_1 = $eBayCategoryID;
                    // $profile->store_category = "active";
                    $profile->listing_format = $listing_format;
                    $profile->listing_duration = $ListingDuration;
                    $profile->domestic_shipping = "Flat";
                    $profile->domestic_ship_service1 = "USPSFirstClass";
                    $profile->domestic_free_shipping = 1;
                    $profile->ship_fee1 = 100.00;
                    $profile->x_ship_fee1 = 0.00;
                    $profile->domestic_free_shipping = 0;
                    $profile->domestic_local_pickup = 0;
                    $profile->domestic_ships_within_handling_days = 2;
                    $profile->domestic_pkg_handling_fee = 0.00;
    
                    if ($shopifylocation != '') {
                        $profile->item_location = $shopifylocation;
                    } else {
                        $profile->item_location = $CityName;
                    }
    
                    //  $profile->item_specifics  = json_encode($arr);
    
                    if ($postalcodefromshopify != 0) {
                        $profile->postal_code = $postalcodefromshopify;
                    } else {
                        $profile->postal_code = $PostalCode;
                    }
    
                    $profile->store_id = $shopifyStore->id;
                    $profile->user_id = $shopifyStore->user_id;
                    $profile->save();
    
                } else {
                        
                    Log::info("ebay item id not found ");
                    $profile = new Profile;
                    $profile->name = $shopname;
                    $profile->trim_title = 1;
                    $profile->is_default_profile = 1;
                    // $profile->listing_title = "active";
                    //  $profile->product_id_type = "active";
                    $profile->item_condition = 1000;
                    $profile->ebay_category_1 = 4408;
                    // $profile->store_category = "active";
                    $profile->listing_format = "fixed price";
                    $profile->listing_duration = "GTC";
    
                    $profile->domestic_shipping = "Flat";
                    $profile->domestic_ship_service1 = "USPSFirstClass";
                    $profile->domestic_free_shipping = 1;
                    $profile->ship_fee1 = 100.00;
                    $profile->x_ship_fee1 = 0.00;
                    $profile->domestic_free_shipping = 0;
                    $profile->domestic_local_pickup = 0;
                    $profile->domestic_ships_within_handling_days = 2;
                    $profile->domestic_pkg_handling_fee = 0.00;
                    // $profile->item_specifics  = json_encode($arr);
    
                    if ($shopifylocation != '') {
                        $profile->item_location = $shopifylocation;
                    } else {
                        $profile->item_location = "United States";
                    }
    
                    //  $profile->item_specifics  = json_encode($arr);
                    if ($postalcodefromshopify != 0) {
                        $profile->postal_code = $postalcodefromshopify;
                    } else {
                        $profile->postal_code = 32792;
                    }
    
                    $profile->store_id = $shopifyStore->id;
                    $profile->user_id = $shopifyStore->user_id;
                    $profile->save();
                }
    
                $shopifyStore->import_products = 1;
                $shopifyStore->save();
    
             
                return response()->json(["shop" => $shopify_url, 'token' => $tolog, "database" => "confirm"], 200);
              
    
            
            } catch (\Exception $e) {
                        report($e);
                      
                        try {
                           
                            $useremail = "pankajnarang81@gmail.com";
                            $errormsg = $e->getMessage();
                           	$sdfsjf = FailDBCreationMail::sendKeysMail($useremail,$errormsg);
                        } catch (\Exception $e) {
                            report($e);
                        }
        }
            }
}

    public function install(Request $request)
    {
        try {
            // Set up Shopify SDK configuration
            PHPShopify\ShopifySDK::config([
                'ShopUrl' => $request->input('shop'),
                'ApiKey' => config('shopify.api_key'),
                'SharedSecret' => config('shopify.shared_secret'),
                'ApiVersion' => config('shopify.api_version'),
            ]);

            // Check if it's a test installation or a regular installation
            if ($request->input('test_install') || ($request->input('shop') && PHPShopify\AuthHelper::verifyShopifyRequest())) {

                // Logout the current user if logged in
                if (Auth::check()) {
                    Auth::logout();
                }

                $scopes = config('shopify.app_scopes');
                $redirectUrl = route(config('shopify.redirect_route'));

                // Create Shopify authentication request
                PHPShopify\AuthHelper::createAuthRequest($scopes, $redirectUrl);

                // The script should exit after creating the authentication request
                exit(0);
            } else {
                // If neither 'test_install' nor 'shop' is present, show the installation view
                return view('shopify.install', ['request' => $request]);
            }
        } catch (\Exception $e) {
            // Handle exceptions
            echo "Error: " . $e->getMessage();
        }

    }

    public function acceptTos(Request $request)
    {
        $shopifyStore = AppHelper::getShopifyStore($request);
        if ($shopifyStore) {
            $update_install_step = false;
            if ($request->has("update_install_step")) {
                $update_install_step = (bool) $request->input("update_install_step");
            }

            if ($update_install_step && $shopifyStore->install_step == 1) {
                $shopifyStore->install_step = 2;
                $shopifyStore->save();
                return response()->json(['status' => 'success', 'msg' => 'tos accepted successfully'], 200);
            } else {
                return response()->json(['status' => 'error', 'msg' => "there was something wrong, please try again"], 403);
            }
        }
        return response()->json(['status' => 'error', 'msg' => "invalid request"], 403);
    }

    public function getStoreData(Request $request)
    {
        try {
            $shopify_url = $request->input('shop');
            $login_token = $request->input('login_token');
            $shopifyStore = ShopifyStore::where('login_token', $login_token)->where('shopify_url', $shopify_url)->with('appCharge')->with('user')->with('plan')->first();
             Log::info("ygyuguyguyguyguy" . json_encode( $shopifyStore, true));
            if ($shopifyStore) {
                $storeData = array();

                if ($shopifyStore->appCharge && $shopifyStore->appCharge->app_charge_data) {
                    $shopifyStore->appCharge->app_charge_data = json_decode($shopifyStore->appCharge->app_charge_data, true);
                }
                $storeData = $shopifyStore->toArray();

                $ordersCount = $shopifyStore->orders()->whereIn("status", array("pending", "processing"))->where("type", "ebay")->count();
                $storeData["pending_orders_count"] = $ordersCount;

                $ebayAccount = $shopifyStore->ebayAccounts()->select('siteid', 'name', 'is_valid', 'sellerid', 'status')->where("is_valid", 1)->first();
                if (!$ebayAccount) {
                    $storeData["is_ebay_account_valid"] = false;
                } else {
                    $storeData["ebay_account"] = $ebayAccount;
                }

                return response()->json($storeData, 200);
            }
        } catch (\Exception $e) {
            report($e);
        }

        return response()->json(["error" => "invalid request"], 403);
    }

    public function getActivityLogs(Request $request)
    {
        $shopifyStore = AppHelper::getShopifyStore($request);
        if ($shopifyStore) {
            $per_page = 20;

            $sort_by = ($request->input("sort_by")) ? $request->input("sort_by") : "created_at";
            $sort_order = ($request->input("sort_order")) ? $request->input("sort_order") : "desc";

            $remarks = $request->input("remarks");
            $log_type = $request->input("logtype");
            $log_date = $request->input("logdate");
            $status = $request->input("status");

            $conditions = array();
            if ($remarks) {
                $conditions[] = array("remarks", "like", "%" . $remarks . "%");
            }

            if ($log_type) {
                $conditions[] = array("log_type", "like", "%" . $log_type . "%");
            }

            if ($log_date) {
                $conditions[] = array("created_at", "like", "%" . $log_date . "%");
            }

            if ($status) {
                $conditions[] = array("status", "=", $status);
            }

            $logs = array();
            if ($conditions) {
                $logs = $shopifyStore->logs()->where($conditions)->orderBy($sort_by, $sort_order)->paginate($per_page);
            } else {
                $logs = $shopifyStore->logs()->orderBy($sort_by, $sort_order)->paginate($per_page);
            }
            return response()->json($logs, 200);
        }
        return response()->json(['status' => 'error', 'msg' => "invalid request"], 403);
    }

    public function getSummaryData(Request $request)
    {
        $shopifyStore = AppHelper::getShopifyStore($request);
        if ($shopifyStore) {
            $summaryData = array();

            $planFeatures = json_decode($shopifyStore->plan->features, true);

            $products_limit = (isset($planFeatures["credits"])) ? (int) $planFeatures["credits"] : 10;

            $products = $shopifyStore->products()->count();
            $published = $shopifyStore->products()->where("status", "published")->count();
            $submitted = $shopifyStore->products()->where("submit", 1)->count();
            $orders = $shopifyStore->orders()->where("type", "ebay")->count();

            $summaryData["products_count"] = $products;
            $summaryData["published_count"] = $published;
            $summaryData["submitted_count"] = $submitted;
            $summaryData["orders_count"] = $orders;

            $summaryData["products_limit"] = $products_limit;

            $logs = $shopifyStore->logs()->orderBy("created_at", "DESC")->paginate(5);
            $errorLogs = $shopifyStore->logs()->where("status", "error")->orderBy("created_at", "DESC")->paginate(10);

            $summaryData["logs"] = $logs;
            $summaryData["error_logs"] = $errorLogs;

            return response()->json($summaryData, 200);
        }
        return response()->json(['status' => 'error', 'msg' => "invalid request"], 403);
    }

    public function plans(Request $request)
    {
        $shopifyStore = AppHelper::getShopifyStore($request);
        if ($shopifyStore) {
            $plans = Plan::where("status", 1)->where(function ($query) use ($shopifyStore) {
                $query->whereNull('store_id')->orWhere('store_id', 0)->orWhere('store_id', $shopifyStore->id);
            })->orderBy('porder')->get();
            //["products_100","inventory_sync","price_sync","order_sync"]
            if ($plans->count()) {
                foreach ($plans as $key => $plan) {
                    $features = json_decode($plan->features, true);
                    $features_list = array();
                    $pro_count = isset($features["credits"]) ? (int) $features["credits"] : 10;
                    $features_list[] = $pro_count . " Credits / Products";
                    if (isset($features["inventory_sync"]) && $features["inventory_sync"]) {
                        $features_list[] = "Inventory Sync";
                    }

                    if (isset($features["price_sync"]) && $features["price_sync"]) {
                        $features_list[] = "Price Sync";
                    }

                    if (isset($features["order_sync"]) && $features["order_sync"]) {
                        $features_list[] = "Order Sync";
                    }

                    $plans[$key]->features = $features;
                    $plans[$key]->features_list = $features_list;

                }
            }
            return response()->json($plans, 200);
        }
        return response()->json(['status' => 'error', 'msg' => "invalid request"], 403);
    }

    public function addAppCharge(Request $request)
    {
        $shopifyStore = AppHelper::getShopifyStore($request);
        if ($shopifyStore && $request->has('plan_id')) {
            $shopify_url = $shopifyStore->shopify_url;
            $plan_id = $request->input('plan_id');
            $plan = Plan::where("status", 1)->find($plan_id);
            if ($plan) {
                
                // PHPShopify\ShopifySDK::config(array('ShopUrl' => $shopifyStore->shopify_url, 'AccessToken' => $shopifyStore->access_token, 'ApiVersion' => config('shopify.api_version')));
                // $shopifyClient = new PHPShopify\ShopifySDK;

                $config = array('ShopUrl' => $shopifyStore->shopify_url, 'AccessToken' => $shopifyStore->access_token, 'ApiVersion' => config('shopify.api_version'));
                $shopifyClient = new PHPShopify\ShopifySDK($config);

                try {
                    $frontend_url = config('config.frontend_url') . "?plan_activated=1";
                    if ($plan->price <= 0) {
                        $shopifyStore->update(array("activated_at" => date("Y-m-d H:i:s"), "plan_id" => $plan->id));
                        return response()->json(['status' => 'success', "msg" => "Plan activated successfully", "redirect_url" => $frontend_url], 200);
                    } else {
                          Log::info("Entered in else");
                        $test = 'false';
                        if ($shopify_url == "eeeitest.myshopify.com" || $shopify_url == "sandbox-store-apps.myshopify.com" || $shopify_url == "reviews-importify.myshopify.com" || $shopify_url == "infoshore.myshopify.com") {
                            $test = 'true';
                        }
                        Log::info("value of test $test");
                         Log::info("value of plan name $plan->name");
                          Log::info("value of plan price $plan->price");
                         
                        $chargeData = array(
                            'name' => $plan->name . " Plan",
                            'price' => (float) $plan->price,
                            'trial_days' => (int) $plan->trial_days,
                            'test' => $test,
                            'return_url' => route('shopifyAppCharge') . "?shopify_url=" . $shopify_url,
                        );
                        $applicationCharge = $shopifyClient->RecurringApplicationCharge()->post($chargeData);
                        
                       
                        if (isset($applicationCharge['confirmation_url']) && $applicationCharge['confirmation_url']) {
                           //  Log::info("confirmation_url -> ".$applicationCharge['confirmation_url']);
                            AppCharge::where('status', 'pending')->where('store_id', $shopifyStore->id)->limit(1)->update(array('status' => 'expired'));
 
                            $is_test = ($applicationCharge['test']) ? 1 : 0;
                            $app_charge_data = json_encode($applicationCharge);

                            $appChargeData = array("name" => $plan->name, "charge_id" => $applicationCharge['id'], "status" => $applicationCharge['status'], "is_test" => $is_test, "app_charge_data" => $app_charge_data, "plan_id" => $plan->id, "store_id" => $shopifyStore->id, "user_id" => $shopifyStore->user_id);

                            $shopifyAppCharge = new AppCharge;
                            $shopifyAppCharge->fill($appChargeData);
                            $shopifyAppCharge->save();

                            return response()->json(['status' => 'success', "msg" => "App Charge created successfully", "redirect_url" => $applicationCharge['confirmation_url']], 200);
                        } else {
                            return response()->json(['status' => 'error', 'msg' => "error creating recurring application charge"], 406);
                        }
                    }
                } catch (\Exception $e) {
                    report($e);
                    return response()->json(['status' => 'error', 'msg' => $e->getMessage()], 406);
                }
            }
        }
        return response()->json(['status' => 'error', 'msg' => $e->getMessage()], 403);
    }

    public function appCharge(Request $request)
    {
        //$shopifyStore = AppHelper::getShopifyStore($request);
        $shopify_url = $request->input("shopify_url");
        $shopifyStore = ShopifyStore::where('shopify_url', $shopify_url)->with('user')->first();
        if ($shopifyStore && $request->has('charge_id')) {
            $charge_id = $request->input('charge_id');
            $appCharge = AppCharge::where("charge_id", $charge_id)->where("store_id", $shopifyStore->id)->with('plan')->first();
            if ($appCharge && $appCharge->plan) {
                
                // PHPShopify\ShopifySDK::config(array('ShopUrl' => $shopifyStore->shopify_url, 'AccessToken' => $shopifyStore->access_token, 'ApiVersion' => config('shopify.api_version')));
                // $shopifyClient = new PHPShopify\ShopifySDK;

                $config = array('ShopUrl' => $shopifyStore->shopify_url, 'AccessToken' => $shopifyStore->access_token, 'ApiVersion' => config('shopify.api_version'));
                $shopifyClient = new PHPShopify\ShopifySDK($config);

                $frontend_url = config('config.frontend_url');
                try {
                    $applicationCharge = $shopifyClient->RecurringApplicationCharge($charge_id)->get();
                    sleep(1);
                    if ($applicationCharge["status"] == "accepted") {
                        $applicationCharge = $shopifyClient->RecurringApplicationCharge($charge_id)->activate();
                        if ($applicationCharge && $applicationCharge["status"] == "active") {
                            $shopifyStore->update(array("activated_at" => date("Y-m-d H:i:s"), "plan_id" => $appCharge->plan->id));
                            AppCharge::where('status', 'active')->where('store_id', $shopifyStore->id)->limit(1)->update(array('status' => 'cancelled'));
                        }
                    } else if ($applicationCharge["status"] == "active") {
                        $shopifyStore->update(array("activated_at" => date("Y-m-d H:i:s"), "plan_id" => $appCharge->plan->id));
                        AppCharge::where('status', 'active')->where('store_id', $shopifyStore->id)->limit(1)->update(array('status' => 'cancelled'));
                    } else if ($applicationCharge["status"] == "active") {
                        return redirect()->to($frontend_url . "?plan_activated=1");
                    }

                    $appCharge->update(array("status" => $applicationCharge["status"], "app_charge_data" => json_encode($applicationCharge)));

                    if ($applicationCharge["status"] == "active") {
                        return redirect()->to($frontend_url . "?plan_activated=1");
                    }

                    return redirect()->to($frontend_url . "?plan_not_activated=1");
                } catch (\Exception $e) {
                    report($e);
                    return redirect()->to($frontend_url . "?plan_not_activated=1");
                }
            }
        }
        return response()->json(['status' => 'error', 'msg' => 'invalid request'], 403);
    }

    public function decryptData(Request $request)
    {
        $data = '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:8bu176ZV2J7G5J0mDzkzOw==';
        $ddata = AppHelper::decryptData($data);
        echo $ddata;
        //echo "<hr>";
        $numberAsString = number_format("0.125", 2);
        //echo $numberAsString;
    }

    public function checkWebhooks(Request $request)
    {
        //    $id  = 1368500961557;
        //$shopifyStores = ShopifyStore::where('status',"active")->get();
        $shopifyStores = ShopifyStore::where('status', "active")->where('id', "842")->get();
        if ($shopifyStores->count() > 0) {
            foreach ($shopifyStores as $shopifyStore) {
                $shopify_store_id = $shopifyStore->id;

                $shopify_url = $shopifyStore->shopify_url;
                //    print_r($shopify_url);
                $accessToken = $shopifyStore->access_token;

                // if ($shopify_url == "vintage-grails-usa.myshopify.com" || $shopify_url =="wrongtowright.myshopify.com" || $shopify_url=="your-fashions-for-less.myshopify.com"
                // || $shopify_url=="testshoptoebay.myshopify.com"    || $shopify_url=="fulfilledvintage-grails-usa.myshopify.com" || $shopify_url=="baterbymarketing.myshopify.com"
                //   || $shopify_url=="triline-c41d.myshopify.com"  || $shopify_url=="super-max-1931.myshopify.com"   || $shopify_url=="happycollectibles.myshopify.com"
                //   || $shopify_url=="happycollectibles.myshopify.com"   || $shopify_url=="nature-scent-8981.myshopify.com"   || $shopify_url=="print-4-you-uk-ltd.myshopify.com"
                //       || $shopify_url=="james-bespoke-furniture-store.myshopify.com"   || $shopify_url=="tekleduk.myshopify.com"   || $shopify_url=="shoguns-gallery.myshopify.com"
                //         || $shopify_url=="testlabs7878.myshopify.com"  || $shopify_url=="seven7home-8812.myshopify.com" || $shopify_url=="madihas-8930.myshopify.com"
                //          || $shopify_url=="gearngoods-com.myshopify.com"  || $shopify_url=="inscribed-life-99cf.myshopify.com"){
                //     continue;
                // }
                try {
                    
                    // $shopifyClient = new PHPShopify\ShopifySDK(array('ShopUrl' => $shopify_url, 'AccessToken' => $accessToken, 'ApiVersion' => config('shopify.api_version')));

                    $config = array('ShopUrl' => $shopify_url, 'AccessToken' => $accessToken, 'ApiVersion' => config('shopify.api_version'));
                    $shopifyClient = new PHPShopify\ShopifySDK($config);

                    $webhooks = $shopifyClient->Webhook()->get();

                    print_r($webhooks);
                    die();
                    foreach ($webhooks as $webhook) {

                        if ($webhook['topic'] == 'app/uninstalled' && $webhook['address'] != "https://app1.ecomshore.com/service/uninstall") {

                            $products_array = array("webhook" => array("id" => $webhook['id'], "address" => "https://app1.ecomshore.com/service/uninstall"));
                            $token1 = $accessToken;
                            $request = "https://" . $shopify_url . "/admin/api/2023-10/webhooks/" . $webhook['id'] . ".json";
                            $curl = curl_init();
                            curl_setopt($curl, CURLOPT_URL, $request);
                            curl_setopt($curl, CURLOPT_HTTPHEADER, array('X-Shopify-Access-Token:' . $token1, 'Content-Type: application/json; charset=utf-8'));
                            curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
                            curl_setopt($curl, CURLOPT_VERBOSE, 0);
                            curl_setopt($curl, CURLOPT_HEADER, false);
                            curl_setopt($curl, CURLOPT_CUSTOMREQUEST, "PUT");
                            curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode($products_array));
                            curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
                            $response = curl_exec($curl);
                            $obj = json_decode($response, true);
                            print_r($response);
                        } else {
                            print_r("all webhooks are in the right format");
                        };

                    }
                } catch (\Exception $e) {
                    report($e);
                    $errors[] = $e->getMessage();
                }

                //$data = array("webhook"=>array("id"=>$id,"address"=>"https://app1.ecomshore.com/service/uninstall"));

            }
//         die();

        }

//     $apiEndpoint = "https://06c503-3.myshopify.com/admin/api/2023-10/webhooks.json";
        // print_r($apiEndpoint );
        // $ch = curl_init();
        // $data = array("webhook"=>array("id"=>1368500961557,"address"=>route('appUninstallWebhook')));
        // // Set cURL options
        // curl_setopt($ch, CURLOPT_URL, $apiEndpoint);
        // curl_setopt($ch, CURLOPT_HTTPHEADER, array(
        //     'Content-Type: application/json',
        //     'X-Shopify-Access-Token: ' . $accessToken,
        // ));
        // curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        // curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'PUT');
        // curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));

// $response = curl_exec($ch);

// $mesage ='';
        // // Check for cURL errors
        // if ($response === false) {
        //     $errorMessage = curl_error($ch);
        //     // Handle the error or log it
        //   $mesage  = "error";
        // }

// // Close the cURL session
        // curl_close($ch);
        // sleep(1);
        // // Continue processing the response if there is no error
        // if ($response !== false) {
        //     print_r("ww".$response);
        //     $mesage  = "sucess";
        //   //fwrite($logfile12, "fulfilment data after update ");
        // }
        //    die();
    }

    public function error(Request $request)
    {
        return view('error');
    }
    
    public function updateimage()
    {
        $imageUrl = 'https://cdn.shopify.com/s/files/1/0630/5133/3889/products/2700_Led_Zeppelin_Tie_Dye_Liquid_Blue_Tee_6cd3c60d-5e19-4cb2-a4c5-098a6e7b42fe.png?v=1670884397';

        $ch = curl_init($imageUrl);
        $dirname = public_path('test');
        mkdir($dirname);
        $filename = public_path('/test/image.jpg');

        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $imageData = curl_exec($ch);
        curl_close($ch);

        file_put_contents($filename, $imageData);
    }
    
    
   
}
