<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use App\User;
use App\ShopifyStore;
use App\Helpers\AppHelper;
use PHPShopify;
use Illuminate\Support\Facades\DB;

class ShopifyStoreAuth
{
	public function __construct(User $user){
		$apiKey = config('shopify.api_key');
		$sharedSecret = config('shopify.shared_secret');
		$shopUrl = (isset($_GET['shop']) && $_GET['shop']) ? trim($_GET['shop']) : "";
		PHPShopify\ShopifySDK::config(array('ShopUrl' => $shopUrl,'ApiKey' => $apiKey,'SharedSecret' => $sharedSecret,'ApiVersion' => config('shopify.api_version')));
	}

	public function setStore($shopifyStore,$updateShopData = false){
		if($shopifyStore){
			session(['user_'.$shopifyStore->user_id.'_shopify_url' => $shopifyStore->shopify_url]);

			PHPShopify\ShopifySDK::config(array('ShopUrl' => $shopifyStore->shopify_url,'AccessToken' => $shopifyStore->access_token,'ApiVersion' => config('shopify.api_version')));
			$shopifyClient = new PHPShopify\ShopifySDK;

			$shopData = array();
			if($updateShopData){
				try{
					$shopData = $shopifyClient->Shop()->get();
					if($shopData){
						$shopifyStore->shop_data = json_encode($shopData);
						$shopifyStore->save();
					}
				}
				catch(\Exception $e){
				}
			}
			else{
				$shopData = json_decode($shopifyStore->shop_data,true);
			}
			view()->share('shopData',$shopData);
			if($shopData){
				$timezone = $shopData["iana_timezone"];
				if($timezone) date_default_timezone_set($timezone);
			}

			$useLatin1 = false;
			AppHelper::setStoreConnection($shopifyStore,[],$useLatin1);
			
			$storeNotifications = array();
			//$storeNotifications = $shopifyStore->notifications()->whereIn('status',['new','seen'])->latest()->limit(10)->get();
			view()->share('storeNotifications',$storeNotifications);

			$planFeatures = json_decode($shopifyStore->plan->features);
			view()->share('planFeatures',$planFeatures);

			view()->share('shopifyStore',$shopifyStore);
		}
	}

	public function handle($request,Closure $next){
		$shopify_url = $request->input('shop');
		$routeName = Route::currentRouteName();

		if($request->input('hmac') && $request->input('shop') && PHPShopify\AuthHelper::verifyShopifyRequest()){
			$shopifyStore = ($shopify_url && (strpos($shopify_url,'.myshopify.com') !== false)) ? ShopifyStore::where('shopify_url',$shopify_url)->with('user')->with('plan')->first() : array();
			if($shopifyStore && $shopifyStore->status == "active"){
				if(Auth::check() && Auth::user() && Auth::user()->id == $shopifyStore->user->id){
				}
				else if(Auth::loginUsingId($shopifyStore->user->id)){
				}
				$this->setStore($shopifyStore,true);
			}
			else if($routeName != "shopifyInstall" && $routeName != "shopifyAuth"){
				return redirect()->route('shopifyInstall',$request->all());
			}
		}
		else if($request->input('shop') && $routeName == "shopifyInstall"){
			if(Auth::check()) Auth::logout();
		}
		else if(Auth::check() && Auth::user()){
			$user_shopify_url = session('user_'.Auth::user()->id.'_shopify_url');
			if(!$shopify_url) $shopify_url = $user_shopify_url;
			if($shopify_url != $user_shopify_url) $shopifyStore = ($shopify_url && (strpos($shopify_url,'.myshopify.com') !== false)) ? ShopifyStore::where('shopify_url',$shopify_url)->with('user')->with('plan')->first() : array();
			if($shopifyStore){
				$this->setStore($shopifyStore,false);
			}
			else if(Auth::check()) Auth::logout();
		}
		return $next($request);
	}
}
