<?php

namespace App\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use App\Helpers\AppHelper;

class ProcessDatabaseMigration implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;
    protected $shopify_url;
    protected $product_id;
   
    public function __construct($shopify_url){
        $this->shopify_url = $shopify_url;
    }
    
    public function handle(){
        try{
            AppHelper::processDatabaseMigration($this->shopify_url);
        }
        catch(\Exception $e){
            report($e);
        }
    }
}
