<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;


class WelcomeEmail extends Mailable
{
    use Queueable, SerializesModels;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($ownername)
    {
        //
         $this->ownername = $ownername;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        
         
        $subject = "Re: Shopify APP [eBay Professional Importer]";
        $body = '<p>Dear ' . $this->ownername . ',</p>
            <p>You have not connected your eBay seller account yet to start setting up your account.</p>
            <p><a href="https://infoshoreapps.freshdesk.com/support/solutions/articles/36000040775-epi-how-to-link-ebay-seller-account" target="_blank">Click here</a> to know the step by step instructions to connect your eBay seller account.</p>
            <p>If you have any doubt, reply to this email and I will be very happy to assist you with the process.</p>
            <p>Thanks for choosing our APP to import your eBay listings to Shopify store.</p>
            <p>Best Regards,<br />Rohit Khariwal<br />Manager - Shopify Applications </p>
            <p>InfoShore Software Private Limited<br />Skype: khariwalrohit<br />www.infoshore.biz</p>';

        return $this->from('shopifyapps@infoshore.biz')
            ->subject($subject)
            ->view('emails.shopify_app_email')
            ->with([
                'body' => $body,
            ]);
    
    }
}
