<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Notification extends Model{

	protected $table = 'notifications';
	protected $connection = 'tenants';

  public function store(){
		return $this->belongsTo('App\ShopifyStore','store_id','id');
  }
    
  public function user(){
		return $this->belongsTo('App\User','user_id','id');
	}

  protected $fillable = [
    'title','description','image_url','type','link','link_text','open_link_in_new_tab','status','notification_data','additional_data','store_id','user_id'
  ];
}
