<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Nicolaslopezj\Searchable\SearchableTrait;

class ShopifyStore extends Model
{
	protected $table = 'shopify_stores';
	protected $connection = 'mysql';

	public function __construct(){
		$this->connection = config('config.default_connection');
	}

  	public function user(){
		return $this->belongsTo('App\User','user_id','id');
	}

	public function plan(){
		return $this->hasOne('App\Plan','id','plan_id');
	}

	public function webhooks(){
		return $this->hasMany('App\StoreWebhook','store_id','id');
	}

	public function cronJobs(){
		return $this->hasMany('App\StoreCronJob','store_id','id');
	}

	public function imports(){
		return $this->hasMany('App\Import','store_id','id');
	}

	public function notifications(){
		return $this->hasMany('App\Notification','store_id','id');
	}

	public function logs(){
		return $this->hasMany('App\Log','store_id','id');
	}

	public function ebayAccounts(){
		return $this->hasMany('App\EbayAccount','store_id','id');
	}

	public function profiles(){
		return $this->hasMany('App\Profile','store_id','id');
	}

	public function templates(){
		return $this->hasMany('App\Template','store_id','id');
	}

	public function products(){
		return $this->hasMany('App\Product','store_id','id');
	}

	public function listings(){
		return $this->hasMany('App\Listing','store_id','id');
	}

	public function listingVariants(){
		return $this->hasMany('App\ListingVariant','store_id','id');
	}

	public function variants(){
		return $this->hasMany('App\ProductVariant','store_id','id');
	}

	public function orders(){
		return $this->hasMany('App\Order','store_id','id');
	}

	public function pendingInventoryUpdate(){
		return $this->hasMany('App\PendingInventoryUpdate','store_id','id');
	}

	public function pendingPriceUpdate(){
		return $this->hasMany('App\PendingPriceUpdate','store_id','id');
	}

	public function pendingProductPublish(){
		return $this->hasMany('App\PendingProductPublish','store_id','id');
	}

	public function appCharge(){
		return $this->hasOne('App\AppCharge','store_id','id');
	}

	protected $fillable = [
		'store_name','shopify_store_id','shopify_url','frontend_url','access_token','locations','plan_id','install_step','installed_at','activated_at','uninstalled_at','status','shop_data','user_id','source','import_products','has_listing_import_products_request','has_inventory_sync_request','has_price_sync_request','has_product_publish_request','has_product_delete_request','has_shipment_update_request','has_order_cancel_request','login_token','automatic_sku_creation','last_order_sync','fix_duplicate_sku'
  	];
}
