<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateNotificationsTable extends Migration
{
    public function up()
    {
        if(!Schema::connection('tenants')->hasTable('notifications')){
            Schema::connection('tenants')->create('notifications',function(Blueprint $table){
                $table->bigIncrements('id');
                $table->string('title');
                $table->text('description')->nullable()->default(NULL);
                $table->string('image_url',500)->nullable()->default(NULL);
                $table->enum('type',['alert','notice','important'])->default('alert');
                $table->string('link',500)->nullable()->default(NULL);
                $table->string('link_text')->nullable()->default(NULL);
                $table->tinyInteger('open_link_in_new_tab')->default(0);
                $table->enum('status',['new','seen','deleted'])->default('new');
                $table->text('notification_data')->nullable()->default(NULL);
                $table->text('additional_data')->nullable()->default(NULL);
                $table->unsignedBigInteger('store_id');
                $table->foreign('store_id')->references('id')->on(config('config.default_database').'.shopify_stores')->onDelete('cascade');
                $table->unsignedBigInteger('user_id');
                $table->foreign('user_id')->references('id')->on(config('config.default_database').'.users')->onDelete('cascade');
                $table->timestamps();
            });
        }
    }
    
    public function down()
    {
        Schema::connection('tenants')->dropIfExists('notifications');
    }
}
