<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateLogsTable extends Migration
{
    
    public function up()
    {
        if(!Schema::connection('tenants')->hasTable('logs')){
            Schema::connection('tenants')->create('logs',function(Blueprint $table){
                $table->bigIncrements('id');
                $table->string('log_type');
                $table->longText('input_data')->nullable()->default(NULL);
                $table->longText('output_data')->nullable()->default(NULL);
                $table->longText('shopify_data')->nullable()->default(NULL);
                $table->string('shopify_data_id')->nullable()->default(NULL);
                $table->longText('log_data')->nullable()->default(NULL);
                $table->string('log_data_id')->nullable()->default(NULL);
                $table->longText('additional_data')->nullable()->default(NULL);
                $table->longText('remarks')->nullable()->default(NULL);
                $table->string('status',100)->nullable()->default(NULL);
                $table->unsignedBigInteger('store_id');
                $table->foreign('store_id')->references('id')->on(config('config.default_database').'.shopify_stores')->onDelete('cascade');
                $table->unsignedBigInteger('user_id');
                $table->foreign('user_id')->references('id')->on(config('config.default_database').'.users')->onDelete('cascade');
                $table->timestamps();
            });
        }
    }
    
    public function down()
    {
        Schema::connection('tenants')->dropIfExists('logs');
    }
}
