<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Schema;

class CreateListingsTable extends Migration
{
    public function up(){
        if(!Schema::connection('tenants')->hasTable('listings')){
            Schema::connection('tenants')->create('listings',function(Blueprint $table){
                $table->bigIncrements('id');
                $table->string('title',500);
                $table->string('image',500)->nullable()->default(NULL);
                $table->string('status',100)->nullable()->default(NULL);
                $table->string('ebay_item_id');
                $table->string('sku')->nullable()->default(NULL);
                $table->string('listing_url',500)->nullable()->default(NULL);
                $table->longText('listing_data')->nullable()->default(NULL);
                $table->longText('additional_data')->nullable()->default(NULL);
                $table->timestamp('last_synced_at')->nullable()->default(NULL);
                $table->text('last_synced_response')->nullable()->default(NULL);
                $table->timestamp('last_inventory_synced_at')->nullable()->default(NULL);
                $table->timestamp('last_pricing_synced_at')->nullable()->default(NULL);
                $table->timestamp('last_order_at')->nullable()->default(NULL);
                $table->unsignedBigInteger('product_id')->nullable()->default(NULL);
                $table->unsignedInteger('account_id')->nullable()->default(NULL);
                $table->foreign('account_id')->references('id')->on(config('config.default_database').'.ebay_accounts')->onDelete('set null');
                $table->unsignedBigInteger('store_id');
                $table->foreign('store_id')->references('id')->on(config('config.default_database').'.shopify_stores')->onDelete('cascade');
                $table->unsignedBigInteger('user_id');
                $table->foreign('user_id')->references('id')->on(config('config.default_database').'.users')->onDelete('cascade');
                $table->timestamps();
            });
        }
    }
    
    public function down(){
        Schema::connection('tenants')->dropIfExists('listings');
    }
}
