<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateAppChargesTable extends Migration
{
    
    public function up()
    {
        Schema::create('app_charges',function(Blueprint $table){
            $table->increments('id');
            $table->string('name');
            $table->unsignedBigInteger('charge_id');
            $table->enum('status',['pending','accepted','active','declined','expired','frozen','cancelled'])->default('pending');
            $table->tinyInteger('is_test')->default(0);
            $table->text('app_charge_data');
            $table->unsignedInteger('plan_id')->nullable()->default(NULL);
            $table->foreign('plan_id')->references('id')->on('plans')->onDelete('set null');
            $table->unsignedBigInteger('store_id');
            $table->unsignedBigInteger('user_id');
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
            $table->timestamps();
        });
    }

    
    public function down()
    {
        Schema::dropIfExists('app_charges');
    }
}
