<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class EbayShippingService extends Model {
	
	protected $table = 'ebay_shipping_services';
	protected $connection = 'mysql';

	public function ServiceTypes(){
		return $this->belongsToMany('App\EbayShippingServiceType','ebay_shipping_service_type_mapping','service_id','service_type_id');
	}

	
	protected $fillable = [
        'description','international_service','shipping_service','shipping_service_id','shipping_time_max','shipping_time_min','valid_for_selling_flow','shipping_carrier','weight_required','shipping_category','ebay_site'
    ];
}
