<?php

namespace App\Helpers;

use Illuminate\Support\Facades\DB;
use App\Http\Requests;
use Illuminate\Support\Facades\Auth;
use PHPShopify;
use App\StoreCronJob;
use App\CronJob;
use App\StoreQueueJob;
use App\StoreLog;
use App\Logs;
use App\Plan;
use App\User;
use Illuminate\Support\Facades\Hash;
use Artisan;
use App\ShopifyStore;
use App\ShopifyAppCharge;
use Illuminate\Support\Facades\Config;
use ClouSale;
use Illuminate\Support\Facades\Log;

class AppHelper{

	public static $shopifyStore;

	public function __construct(){
  	}
	
	public function getDisplayDateTimeString($dateTime,$full = false){
		$now = new \DateTime;
		$ago = new \DateTime($dateTime);
		$diff = $now->diff($ago);

		$diff->w = floor($diff->d / 7);
		$diff->d -= $diff->w * 7;

		$string = array(
			'y' => 'year',
			'm' => 'month',
			'w' => 'week',
			'd' => 'day',
			'h' => 'hour',
			'i' => 'minute',
			's' => 'second',
		);
		foreach($string as $k => &$v){
			if($diff->$k){
				$v = $diff->$k.' '.$v.($diff->$k > 1 ? 's' : '');
			}
			else{
				unset($string[$k]);
			}
		}

		if(!$full) $string = array_slice($string,0,1);
		return $string ? implode(', ',$string).' ago' : 'just now';
	}

	public static function setShopifyConfig($config = array()){
		PHPShopify\ShopifySDK::config($config);
	}

	public static function checkAuth(){
		if(Auth::check() && Auth::user()) return true;
		return false;
	}

	
	public static function verifyHmac($request){
		$requestParams = $request->all();
		$params = array();
		foreach($requestParams as $param => $value){
			if($param != 'signature' && $param != 'hmac'){
				$params[$param] = "{$param}={$value}";
			}
		}
		asort($params);
		$params = implode('&',$params);
		$hmac = isset($_GET['hmac']) ? $_GET['hmac'] : "";
		$calculatedHmac = hash_hmac('sha256',$params,config('shopify.shared_secret'));
		return ($hmac == $calculatedHmac);
	}

	public static function getStoreIDFromDBName(){
		$database = config("database.connections.tenants.database");
		if(strpos($database,config('config.store_db_prefix')) !== false){
			return str_replace(config('config.store_db_prefix'),"",$database);
		}
		return null;
	}

	public static function getStoreCronJobFlag($cron_job_type){
		//$storeCronJob = StoreCronJob::where("type",$cron_job_type)->first();
		$storeCronJob = CronJob::where("type",$cron_job_type)->first();
		if($storeCronJob) return $storeCronJob->flag;
		return 1;
	}

	public static function updateStoreCronJobFlag($cron_job_type,$flag,$flagCheck = null){
		//$storeCronJob = StoreCronJob::where("type",$cron_job_type)->first();
		$storeCronJob = CronJob::where("type",$cron_job_type)->first();
		if($storeCronJob){
			if($flagCheck === null || $flagCheck === $storeCronJob->flag){
				if($flag == -1){
					$storeCronJob->update(["flag" => -1]);
				}
				else if($flag == 1){
					$storeCronJob->update(["flag" => 1,"started_at" => now()->toDateTimeString(),"ended_at" => NULL]);
				}
				else if($flag === 0){
					$storeCronJob->update(["flag" => 0,"ended_at" => now()->toDateTimeString()]);
				}
			}
		}
	}

	public static function getCronJob($type){
		return CronJob::where("type",$type)->first();
	}

	public static function updateCronJob($type,$flag){
		$cronJob = CronJob::where("type",$type)->first();
		if($cronJob){
			$dateTime = now()->toDateTimeString();
			if($flag === -1) $cronJob->update(["last_updated_at" => $dateTime]);
			else if($flag === 1) $cronJob->update(["flag" => 1,"started_at" => $dateTime,"last_updated_at" => $dateTime,"ended_at" => NULL]);
			else if($flag === 0) $cronJob->update(["flag" => 0,"ended_at" => $dateTime,"last_updated_at" => $dateTime]);
		}
	}

	public static function addStoreCronJob($cron_job_type,$flag = 0,$shopify_store_id){
		$storeCronJob = StoreCronJob::where("type",$cron_job_type)->first();
		if(!$storeCronJob){
			$cronJobData = array("type" => $cron_job_type,"flag" => $flag,"shopify_store_id" => $shopify_store_id);
			$storeCronJob = StoreCronJob::create($cronJobData);
			if($storeCronJob) return true;
		}
		return false;
	}

	public static function deleteStoreCronJob($cron_job_type,$shopify_store_id){
		$storeCronJob = StoreCronJob::where("type",$cron_job_type)->where("shopify_store_id",$shopify_store_id)->first();
		if($storeCronJob){
			$storeCronJob->delete();
			return true;
		}
		return false;
	}

	public static function deletePendingQueueJob($supplier,$shopifyStore){
		$queues = array("syncproducts","syncinventory");
		foreach($queues as $queue){
			$storeQueueJobs = $shopifyStore->queueJobs()->where('queue',$queue)->get();
			if($storeQueueJobs->count() > 0){
				foreach($storeQueueJobs as $queueJob){
					$payload = json_decode($queueJob->payload,true);
					$jobObj = unserialize($payload['data']['command']);
					if($queue == "syncproducts" && $payload['displayName'] == 'App\Jobs\SyncSupplierProducts'){
						$jobSupplier = $jobObj->getProperty('supplier');
						if($jobSupplier && $jobSupplier->id == $supplier->id){
							$queueJob->delete();
						}
					}
					else if($queue == "syncinventory" && $payload['displayName'] == 'App\Jobs\SyncSupplierInventory'){
						$jobSupplier = $jobObj->getProperty('supplier');
						if($jobSupplier && $jobSupplier->id == $supplier->id){
							$queueJob->delete();
						}
					}
				}
			}
		}
		return true;
	}

	public static function timeElapsed($datetime,$full = false){
		$now = new \DateTime;
		$ago = new \DateTime($datetime);
		$diff = $now->diff($ago);

		$diff->w = floor($diff->d / 7);
		$diff->d -= $diff->w * 7;

		$string = array(
			'y' => 'year',
			'm' => 'month',
			'w' => 'week',
			'd' => 'day',
			'h' => 'hour',
			'i' => 'minute',
			's' => 'second',
		);
		foreach ($string as $k => &$v) {
			if ($diff->$k) {
				$v = $diff->$k . ' ' . $v . ($diff->$k > 1 ? 's' : '');
			} else {
				unset($string[$k]);
			}
		}

		if (!$full) $string = array_slice($string, 0, 1);
		return $string ? implode(', ', $string) . ' ago' : 'just now';
	}

	public static function checkStoreDatabase($database = null,$shopifyStore = array()){
		$store_database_name = $database;
		//if(!$store_database_name && $shopifyStore) $store_database_name = 'ri_shopify_user_'.$shopifyStore->user_id.'_store_'.$shopifyStore->id;
		if(!$store_database_name && $shopifyStore) $store_database_name = config('config.store_db_prefix').$shopifyStore->id;
		if($store_database_name){
			$checkDBQuery = DB::select("SELECT SCHEMA_NAME FROM INFORMATION_SCHEMA.SCHEMATA WHERE SCHEMA_NAME = ?",[$store_database_name]);
			if(empty($checkDBQuery)){
				$shopifyStore->status = "uninstalled";
				$shopifyStore->install_step = NULL;
				$shopifyStore->save();
			}
			else{
				return true;
			}
		}
		return false;
	}

	public static function checkStoreDatabaseOnly($database = null,$shopifyStore = array()){
		$store_database_name = $database;
		if(!$store_database_name && $shopifyStore) $store_database_name = config('config.store_db_prefix').$shopifyStore->id;
		if($store_database_name){
			$checkDBQuery = DB::select("SELECT SCHEMA_NAME FROM INFORMATION_SCHEMA.SCHEMATA WHERE SCHEMA_NAME = ?",[$store_database_name]);
			if(empty($checkDBQuery)){
			}
			else{
				return true;
			}
		}
		return false;
	}

	public static function processDatabaseMigration($shopify_url = ""){
	    
		try{
			$store_database_name = "";
				Log::info("processDatabaseMigration");
			$shopifyStore = (strpos($shopify_url,'.myshopify.com') !== false) ? ShopifyStore::where('shopify_url',$shopify_url)->with('user')->first() : array();
			if($shopifyStore) $store_database_name = config('config.store_db_prefix').$shopifyStore->id;
			if($store_database_name){
				$checkDBQuery = DB::select("SELECT SCHEMA_NAME FROM INFORMATION_SCHEMA.SCHEMATA WHERE SCHEMA_NAME = ?",[$store_database_name]);
				Log::info("processDatabaseMigration checkDBQuery");
				if(empty($checkDBQuery)){
					DB::statement('CREATE DATABASE IF NOT EXISTS `'.$store_database_name.'` CHARACTER SET '.config('database.connections.'.config('database.default').'.charset').' COLLATE '.config('database.connections.'.config('database.default').'.collation'));
				}
				AppHelper::setConnection($store_database_name,$shopifyStore);

				$store_connection = config("config.store_connection");
				Artisan::call('migrate',array('--database' => $store_connection,'--path' => 'database/migrations/user_tables','--force' => true));
				Log::info("processDatabaseMigration  Artisan");
			}
		}
		catch(\Exception $e){
			report($e);
		}
	}

	
	public static function setStoreConnection($shopifyStore = null,$useLatin1 = false){
	    Log::info(" in setStoreConnection");
		$store_connection = config("config.store_connection");
		//$store_connection = "tenants";
		if($shopifyStore && $store_connection){
			$database = config('config.store_db_prefix').$shopifyStore->id;
            Log::info(" in setStoreConnection db $database ");
			DB::disconnect($store_connection);
			DB::purge($store_connection);

			$charset = config('database.connections.'.config('database.default').'.charset');
			$collation = config('database.connections.'.config('database.default').'.collation');
			if($useLatin1){
				$charset = "latin1";
				$collation = "latin1_swedish_ci";
			}
			Config::set('database.connections.'.$store_connection.'.database',$database);
			DB::reconnect($store_connection);
			Log::info(" in setStoreConnection db reconnect");
			DB::connection($store_connection)->reconnect();
			Log::info(" end setStoreConnection");
		}
	}

	public static function setConnection($database = null,$shopifyStore = null,$useLatin1 = false ){
	    Log::info("In setConnection");
		$store_connection = config("config.store_connection");
		$store_connection = "tenants";
		if($database && $store_connection){
			DB::disconnect($store_connection);
			DB::purge($store_connection);
            Log::info("In setConnection purge");
			$charset = config('database.connections.'.config('database.default').'.charset');
			$collation = config('database.connections.'.config('database.default').'.collation');
			if($useLatin1){
				$charset = "latin1";
				$collation = "latin1_swedish_ci";
			}
			Config::set('database.connections.'.$store_connection.'.database',$database);
			DB::reconnect($store_connection);
			DB::connection($store_connection)->reconnect();
                  Log::info("In setConnection purge connection");
			if($shopifyStore && $shopifyStore->user_id !='') Config::set('ebay.environment','');
			 Log::info("In setConnection purge connection   end");
		}
	}

	public static function addStoreLog($data = array(),$store_id){
		try{
			$log_type = (isset($data["log_type"])) ? $data["log_type"] : "unknown_log_type";
			$input_data = (isset($data["input_data"])) ? $data["input_data"] : "";
			$output_data = (isset($data["output_data"])) ? $data["output_data"] : "";
			$shopify_data = (isset($data["shopify_data"])) ? $data["shopify_data"] : "";
			$shopify_data_id = (isset($data["shopify_data_id"])) ? $data["shopify_data_id"] : "";
			$log_data = (isset($data["log_data"])) ? $data["log_data"] : "";
			$remarks = (isset($data["remarks"])) ? $data["remarks"] : "";

			$logData = array("log_type" => $log_type,"input_data" => $input_data,"output_data" => $output_data,"shopify_data" => $shopify_data,"shopify_data_id" => $shopify_data_id,"log_data" => $log_data,"remarks" => $remarks,"store_id" => $store_id);
			$storeLog = StoreLog::create($logData);
			if($storeLog) return true;
		}
		catch(\Exception $e){
			report($e);
		}
		return false;
	}

	public static function addLog($data = array()){
		try{
			$log_type = (isset($data["log_type"])) ? $data["log_type"] : "unknown_log_type";
			$input_data = (isset($data["input_data"])) ? $data["input_data"] : "";
			$output_data = (isset($data["output_data"])) ? $data["output_data"] : "";
			$log_data_type = (isset($data["log_data_type"])) ? $data["log_data_type"] : "";
			$log_data = (isset($data["log_data"])) ? $data["log_data"] : "";
			$remarks = (isset($data["remarks"])) ? $data["remarks"] : "";

			$logData = array("log_type" => $log_type,"input_data" => $input_data,"output_data" => $output_data,"log_data_type" => $log_data_type,"log_data" => $log_data,"remarks" => $remarks);
			$log = Logs::create($logData);
			if($log) return true;
		}
		catch(\Exception $e){
			report($e);
		}
		return false;
	}

	public static function saveMediaFile($remote_url,$local_file){
		sleep(1);
		$agent = 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:65.0) Gecko/20100101 Firefox/65.0';
		$fp = fopen($local_file,'w+');
		$ch = curl_init(str_replace(" ","%20",$remote_url));
		curl_setopt($ch,CURLOPT_TIMEOUT,50);
		curl_setopt($ch,CURLOPT_FILE,$fp);
		curl_setopt($ch,CURLOPT_FOLLOWLOCATION,true);
		curl_setopt($ch,CURLOPT_USERAGENT,$agent);
		curl_setopt($ch,CURLOPT_COOKIEFILE,'cookies.txt');
		curl_setopt($ch,CURLOPT_COOKIEJAR,'cookies.txt');
		//curl_setopt($ch,CURLOPT_RETURNTRANSFER,true);
		curl_setopt($ch,CURLOPT_REFERER,'https://www.google.com/');
		$response = curl_exec($ch);
		curl_close($ch);
		fclose($fp);
		return $response;
	}

	public static function getAmazonCountryFromMarketPlace($marketPlaceID){
		$amazonCountries = [['key'=>'ATVPDKIKX0DER', 'value'=>'US'],['key'=>'A2EUQ1WTGCTBG2', 'value'=>'CA'], ['key'=>'A1F83G8C2ARO7P', 'value'=>'UK'], ['key'=>'A21TJRUUN4KGV', 'value'=>'IN'], ['key'=>'A1AM78C64UM0Y8', 'value'=>'MX'], ['key'=>'A1PA6795UKMFR9', 'value'=>'DE'], ['key'=>'A1RKKUPIHCS9HS', 'value'=>'ES'], ['key'=>'A13V1IB3VIYZZH', 'value'=>'FR'], ['key'=>'APJ6JRA9NG5V4', 'value'=>'IT'], ['key'=>'A1VC38T7YXB528', 'value'=>'JP'], ['key'=>'AAHKV2X7AFYLW', 'value'=>'CN']];

		$amazonWebsite = 'US';
		foreach($amazonCountries as $amazonCountry){
			if($amazonCountry["key"] == $marketPlaceID){
				$amazonWebsite = $amazonCountry["value"];
				break;
			}
		}
		return $amazonWebsite;
	}

	public static function getAmazonSite($countryCode){
		$amazonCountry = array("US"=>"United States","CA"=>"Canada","FR"=>"France","DE"=>"Germany","IN"=>"India","IT"=>"Italy","CN"=>"China","JP"=>"Japan","UK"=>"United Kingdom","MX"=>"Mexico","ES"=>"Spain","AU"=>"Australia","BR"=>"Brazil","SG"=>"Singapore","NL"=>"Netherlands");
		return $amazonCountry[$countryCode];
	}

	public static function getAmazonCountry($countryCode){
		$amazonDomain = array("US"=>"com","CA"=>"ca","FR"=>"fr","DE"=>"de","IN"=>"in","IT"=>"it","CN"=>"cn","JP"=>"co.jp","UK"=>"co.uk","MX"=>"com.mx","ES"=>"es","AU"=>"com.au","BR"=>"com.br","SG"=>"com.sg","NL"=>"nl");
		return "https://www.amazon.".$amazonDomain[$countryCode]."/";
	}

	public static function getAmazonDomain($countryCode){
		$amazonDomain = array("US"=>"com","CA"=>"ca","FR"=>"fr","DE"=>"de","IN"=>"in","IT"=>"it","CN"=>"cn","JP"=>"co.jp","UK"=>"co.uk","MX"=>"com.mx","ES"=>"es","AU"=>"com.au","BR"=>"com.br","SG"=>"com.sg","NL"=>"nl");
		return "https://www.amazon.".$amazonDomain[$countryCode]."/";
	}

	public static function getEbayCountry($countryCode){
		$ebayDomain = array("AU"=>"Australia","AT"=>"Austria","BE"=>"Belgium","CA"=>"Canada","CN"=>"China","FR"=>"France","DE"=>"Germany","IE"=>"Ireland","IT"=>"Italy","HK"=>"Hong Kong","MY"=>"Malaysia","NL"=>"Netherlands","PH"=>"Philippines","PL" =>"Poland","SG"=>"Singapore","ES"=>"Spain","CH"=>"Switzerland","TW"=>"Taiwan","TH"=>"Thailand","UK"=>"United Kingdom","US"=>"United States","VN"=>"Vietnam");
		return $ebayDomain[$countryCode];
	}

	public static function getEbayDomain($countryCode){
		$ebayDomain = array("AU"=>"com.au","AT"=>"at","BE"=>"be","CA"=>"ca","CN"=>"cn","FR"=>"fr","DE"=>"de","IE"=>"ie","IT"=>"it","HK"=>"com.hk","MY"=>"com.my","NL"=>"nl","PH"=>"ph","PL" =>"pl","SG"=>"com.sg","ES"=>"es","CH"=>"ch","TW"=>"com.tw","TH"=>"co.th","UK"=>"co.uk","US"=>"com","VN"=>"vn");
		return "https://www.ebay.".$ebayDomain[$countryCode]."/";
	}

	public static function downloadFile($remote_url,$local_file){
		sleep(1);
		$agent = 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:65.0) Gecko/20100101 Firefox/65.0';
		$fp = fopen($local_file,'w+');
		$ch = curl_init(str_replace(" ","%20",$remote_url));
		curl_setopt($ch,CURLOPT_TIMEOUT,50);
		curl_setopt($ch,CURLOPT_FILE,$fp);
		curl_setopt($ch,CURLOPT_FOLLOWLOCATION,true);
		curl_setopt($ch,CURLOPT_USERAGENT,$agent);
		curl_setopt($ch,CURLOPT_COOKIEFILE,'cookies.txt');
		curl_setopt($ch,CURLOPT_COOKIEJAR,'cookies.txt');
		//curl_setopt($ch,CURLOPT_RETURNTRANSFER,true);
		curl_setopt($ch,CURLOPT_REFERER,'https://www.google.com/');
		$response = curl_exec($ch);
		curl_close($ch);
		fclose($fp);
		return $response;
	}

	public static function getShopifyStore($request){
		if(Auth::check() && Auth::user() && $request->has("shopify_url")){
			$shopify_url = $request->input("shopify_url");
			$shopifyStore = ShopifyStore::where('shopify_url',$shopify_url)->with('plan')->with('user')->first();
			if($shopifyStore && $shopifyStore->status == "active" && $shopifyStore->user->id == Auth::user()->id){				
				$shopify_store_id = $shopifyStore->id;
				$store_database_name = config('config.store_db_prefix').$shopify_store_id;
				AppHelper::setConnection($store_database_name,$shopifyStore);
				return $shopifyStore;
			}
		}
		else if ($request =='vintage-grails-usa.myshopify.com'){
		$shopify_url = $request;
			$shopifyStore = ShopifyStore::where('shopify_url',$shopify_url)->with('plan')->with('user')->first();
			if($shopifyStore && $shopifyStore->status == "active" && $shopifyStore->user->id == Auth::user()->id){				
				$shopify_store_id = $shopifyStore->id;
				$store_database_name = config('config.store_db_prefix').$shopify_store_id;
				AppHelper::setConnection($store_database_name,$shopifyStore);
				return $shopifyStore;
			}
		}else if($request =='rapid-nutrition-au.myshopify.com'){
		    	$shopify_url = $request;
			$shopifyStore = ShopifyStore::where('shopify_url',$shopify_url)->with('plan')->with('user')->first();
			if($shopifyStore && $shopifyStore->status == "active" ){				
				$shopify_store_id = $shopifyStore->id;
				$store_database_name = config('config.store_db_prefix').$shopify_store_id;
				AppHelper::setConnection($store_database_name,$shopifyStore);
				return $shopifyStore;
			}
		}
		return null;
	}
	
		public static function getShopifyStore2($request){
		if($request){
			$shopify_url = $request;
			$shopifyStore = ShopifyStore::where('shopify_url',$shopify_url)->with('plan')->with('user')->first();
			if($shopifyStore && $shopifyStore->status == "active"){				
				$shopify_store_id = $shopifyStore->id;
				$store_database_name = config('config.store_db_prefix').$shopify_store_id;
				AppHelper::setConnection($store_database_name,$shopifyStore);
				return $shopifyStore;
			}
		}
	
		return null;
	}

	public static function getPageHTMLFromUrl($page_url){
		if(!$page_url) return null;
		$apikey = "e6585b7c2f1d8cc1842f3a77b4187ad0";
		$url = "http://api.scraperapi.com?api_key=".$apikey."&render=true&url=".$page_url;
		$ch = curl_init($url);
		curl_setopt($ch,CURLOPT_RETURNTRANSFER,true);
		curl_setopt($ch,CURLOPT_SSL_VERIFYPEER,false);
		curl_setopt($ch,CURLOPT_VERBOSE,true);
		curl_setopt($ch,CURLOPT_CUSTOMREQUEST,"GET");
		$html = curl_exec($ch);
		curl_close($ch);
		return $html;
	}

	public static function encryptData($data){
	
		return $data;
	}
	
	public static function decryptData($encrypted){
	
		return $encrypted;
	}

}