<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Import extends Model{

	protected $table = 'imports';
	protected $connection= 'tenants';

    public function store(){
		return $this->belongsTo('App\ShopifyStore','store_id','id');
	}

	public function user(){
		return $this->belongsTo('App\User','user_id','id');
	}

    protected $fillable = [
        'type','input_file','output_file','status','started_at','ended_at','cancelled_at','remarks','store_id','user_id'
    ];
}
