<?php

namespace App\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use App\Helpers\AppHelper;
use App\ShopifyStore;
use App\Http\Controllers\ListingController;
use PHPShopify;
use Illuminate\Support\Facades\Log;

class CreateProductsFromListings implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;
    public $store_id,$user_id,$conditions,$vconditions;

    public $timeout = 0;
    public $tries = 100;
   
    public function __construct($data){
        $this->store_id = $data["store_id"];
        $this->user_id = $data["user_id"];
        $this->conditions = $data["conditions"];
        $this->vconditions = $data["vconditions"];
    }
    
    public function handle(){
        $cronJob = AppHelper::getCronJob("create_products");
        if(!$cronJob || $cronJob->flag == 1 || $cronJob->do_stop == 1) die();
        AppHelper::updateCronJob($cronJob->type,1);

        $errors = array();
        try{
            $shopifyStore = ShopifyStore::where('status',"active")->find($this->store_id);
            if($shopifyStore){
                	Log::info(" bulk create product job");
				$shopify_store_id = $shopifyStore->id;
				$store_database_name = config('config.store_db_prefix').$shopify_store_id;
                AppHelper::setConnection($store_database_name,$shopifyStore);

                $ebayAccount = $shopifyStore->ebayAccounts()->where('is_valid',1)->first();
                if($ebayAccount){
                    $listingController = new ListingController();
                    $listings = [];

                    if($this->vconditions){
                        $vconditions = $this->vconditions;
	Log::info("111111111");
                        if($this->conditions){
                            $listings = $shopifyStore->listings()->with('variants')->whereHas('variants',function($query) use($vconditions){
                                $query->where($vconditions);
                            })->where(function($query){
                                $query->where("product_id",0)->orWhereNull("product_id");
                            })->where($this->conditions)->get();
                        }
                        else{
                            $listings = $shopifyStore->listings()->with('variants')->whereHas('variants',function($query) use($vconditions){
                                $query->where($vconditions);
                            })->where(function($query){
                                $query->where("product_id",0)->orWhereNull("product_id");
                            })->get();
                        }
                    }
                    else if($this->conditions){
                        $listings = $shopifyStore->listings()->with('variants')->where(function($query){
							$query->where("product_id",0)->orWhereNull("product_id");
						})->where($this->conditions)->get();
                    }
                    else{
                        $listings = $shopifyStore->listings()->with('variants')->where(function($query){
							$query->where("product_id",0)->orWhereNull("product_id");
						})->get();
                    }
	Log::info(" 2222222");
                    if($listings->count() > 0){

                        PHPShopify\ShopifySDK::config([
                            'ShopUrl' => $shopifyStore->shopify_url,
                            'AccessToken' => $shopifyStore->access_token,
                            'ApiVersion' => config('shopify.api_version')
                        ]);
			            $shopifyClient = new PHPShopify\ShopifySDK;

                        $alerrors = array();
                        $succ_count = 0;
                        $err_count = 0;
	Log::info(" 333333");
                        foreach($listings as $lkey => $listing){
                            $lerrors = array();
                            $success = false;
                            $lresponse = $listingController->createProduct($listing,$shopifyStore,$shopifyClient);
                            if($lresponse && isset($lresponse["status"])){
                                if($lresponse["status"] == "success"){
                                    $succ_count++;
                                    $success = true;
                                }
                                else{
                                    $err_count++;
                                    $lerrors = $lresponse["errors"];
                                }
                            }
                            else{
                                $err_count++;
                                $lresponse_st = (is_array($lresponse)) ? json_encode($lresponse) : $lresponse;
                                $lerrors[] = "failed to create product ".$lresponse_st;
                            }
	Log::info(" 4444444");
                            if(!$success){
                                $alerrors = array_merge($alerrors,$lerrors);

                                $output_data = array();
                                $output_data["errors"] = $alerrors;
                                if($this->conditions) $output_data["conditions"] = $this->conditions;
                                if($this->vconditions) $output_data["vconditions"] = $this->vconditions;

                                $logData = array();
                                $logData["log_type"] = "create_product";
                                $logData["input_data"] = $listing->title;
                                $logData["status"] = "error";
                                $logData["output_data"] = json_encode($output_data,JSON_INVALID_UTF8_IGNORE);
                                $logData["remarks"] = "failed to create product from listing : ".$listing->title;
                                $logData["store_id"] = $shopifyStore->id;
                                $logData["user_id"] = $shopifyStore->user_id;
                                $shopifyStore->logs()->create($logData);
                            }
                        }

                        if($alerrors) file_put_contents("createProductsErrorShopify_".$shopifyStore->id.".json",json_encode($alerrors));
			
                        if($succ_count > 0){
                            $logData = array();
                            $logData["log_type"] = "create_product";
                            $logData["input_data"] = "";
                            $logData["status"] = "success";
                            $logData["output_data"] = "";
                            $logData["remarks"] = $succ_count." products successfully created from listing";
                            $logData["store_id"] = $shopifyStore->id;
                            $logData["user_id"] = $shopifyStore->user_id;
                            $shopifyStore->logs()->create($logData);
                        }
                        
                    }
                }
                else{
                    $output_data = array();
                    $output_data["errors"] = array("invalid ebay account");
                    if($this->conditions) $output_data["conditions"] = $this->conditions;
                    if($this->vconditions) $output_data["vconditions"] = $this->vconditions;
					$logData = array();
					$logData["log_type"] = "create_product";
					$logData["input_data"] = $this->type;
					//$logData["log_data_id"] = $this->account_id;
					$logData["status"] = "error";
					$logData["output_data"] = json_encode($output_data,JSON_INVALID_UTF8_IGNORE);
					$logData["remarks"] = "failed to create product, ".$output_data["errors"][0];
					$logData["store_id"] = $shopifyStore->id;
					$logData["user_id"] = $shopifyStore->user_id;
					$shopifyStore->logs()->create($logData);
                }
            }
        }
        catch(\Exception $e){
            report($e);
            $errors[] = $e->getMessage();
        }

        if($errors) file_put_contents("createProducts_".$this->store_id."_".$this->type.".json",json_encode($errors));

        AppHelper::updateCronJob($cronJob->type,0);
    }
}
