<?php
namespace App\Libraries;

class Ebay
{
	private $requestToken;
	private $devID;
	private $appID;
	private $certID;
	private $serverUrl;
	private $compatLevel;
	private $siteID;
	private $verb;
	public function __construct($userRequestToken,$developerID,$applicationID,$certificateID,$serverUrl,$compatabilityLevel,$siteToUseID,$callName)
	{
		$this->requestToken = $userRequestToken;
		$this->devID = $developerID;
		$this->appID = $applicationID;
		$this->certID = $certificateID;
		$this->compatLevel = $compatabilityLevel;
		$this->siteID = $siteToUseID;
		$this->verb = $callName;
        $this->serverUrl = $serverUrl;	
	}
	
	public function sendHttpRequest($requestBody)
	{   
	    // return $this->serverUrl;
		
		$headers = $this->buildEbayHeaders();
		$curl = curl_init();
		curl_setopt($curl, CURLOPT_URL, $this->serverUrl);
		curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, 0);
		curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, 0);
		curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
		curl_setopt($curl, CURLOPT_POST, 1);
		curl_setopt($curl, CURLOPT_POSTFIELDS, $requestBody);
		curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
		
		$response = curl_exec($curl);
		curl_close($curl);
		return $response;
	}

	private function buildEbayHeaders()
	{
		$headers = array (
			'X-EBAY-API-COMPATIBILITY-LEVEL: ' . $this->compatLevel,
			'X-EBAY-API-DEV-NAME: ' . $this->devID,
			'X-EBAY-API-APP-NAME: ' . $this->appID,
			'X-EBAY-API-CERT-NAME: ' . $this->certID,
			'X-EBAY-API-CALL-NAME: ' . $this->verb,
			//SiteID = 0  (US) - UK = 3, Canada = 2, Australia = 15, ....
			'X-EBAY-API-SITEID: ' . $this->siteID,
		);
		return $headers;
	}
	function TradeAPI($call,$body,$field){
		$requestBody ="<?xml version='1.0' encoding='utf-8'?>"."<{$call} xmlns='urn:ebay:apis:eBLBaseComponents'>{$body}</{$call}>";
		$response = $this->sendHttpRequest($requestBody);
		if($response){
			// found open tag?
			if(($begin = strpos($response,"<{$field}>")) !== FALSE){
				// skip open tag
				$begin += strlen($field) + 2;
				// found close tag?
				if(($end = strpos($response, "</{$field}>", $begin)) !== FALSE){
					return substr($response, $begin, $end - $begin);
				}
			}
		}
		else{
			return 'No response from eBay server!';
		}
		return "Field <b>{$field}</b> not found in eBay response!<p/><br />{$response}";
		/*
		if (($response = @file_get_contents($EBAY['trade'], 'r', stream_context_create(array('http' => array(
			'method' => 'POST',
			'header' =>
				"Content-Type: text/xml; charset=utf-8\r\n".
				"X-EBAY-API-SITEID: 0\r\n".
				"X-EBAY-API-COMPATIBILITY-LEVEL: 689\r\n".
				"X-EBAY-API-CALL-NAME: {$call}\r\n".
				"X-EBAY-API-DEV-NAME: {$EBAY['devid']}\r\n".
				"X-EBAY-API-APP-NAME: {$EBAY['appid']}\r\n".
				"X-EBAY-API-CERT-NAME: {$EBAY['certid']}\r\n",
			'content' => $request ="<?xml version='1.0' encoding='utf-8'?>\n". "<{$call} xmlns='urn:ebay:apis:eBLBaseComponents'>{$body}</{$call}>"
		))))) === FALSE){
			exit('No response from eBay server!');
		}
		$ebresponse=$response;
		
		// found open tag?
		if (($begin = strpos($response, "<{$field}>")) !== FALSE){
			// skip open tag
			$begin += strlen($field) + 2;
			// found close tag?
			if (($end = strpos($response, "</{$field}>", $begin)) !== FALSE){
				return substr($response, $begin, $end - $begin);
			}
		}
		exit("Field <b>{$field}</b> not found in eBay response!<p/>\n\n{$response}");
		*/
	}


}
?>