<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Nicolaslopezj\Searchable\SearchableTrait;

class PendingProductPublish extends Model
{
	protected $table = 'pending_product_publish';
	protected $connection = 'mysql';

	/*
	public function __construct(){
		$this->connection = config('config.default_connection');
	}
	*/

	public function product(){
		return $this->hasOne('App\Product','id','product_id');
	}

	public function profile(){
		return $this->hasOne('App\Profile','id','profile_id');
	}

	public function account(){
		return $this->belongsTo('App\AmazonAccount','account_id','id');
	}

	public function store(){
		return $this->belongsTo('App\ShopifyStore','store_id','id');
	}
    
  	public function user(){
		return $this->belongsTo('App\User','user_id','id');
	}

	protected $fillable = [
		'product_id','profile_id','processing','account_id','store_id','user_id'
  	];
}
