<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Nicolaslopezj\Searchable\SearchableTrait;

class ProductVariant extends Model
{
	protected $table = 'product_variants';
	protected $connection = 'tenants';


	public function product(){
		return $this->belongsTo('App\Product','product_id','id');
	}

	public function listingVariant(){
		return $this->belongsTo('App\ListingVariant','listing_variant_id','id');
	}

	public function store(){
		return $this->belongsTo('App\ShopifyStore','store_id','id');
	}
    
  	public function user(){
		return $this->belongsTo('App\User','user_id','id');
	}

	protected $fillable = [
		'title','sku','image','product_id_val','asin','quantity','price','compare_at_price','shopify_variant_id','shopify_inventory_item_id','shopify_product_id','shopify_product_handle','shopify_variant_data','last_inventory_synced_at','last_inventory_synced','last_pricing_synced_at','last_price_synced','last_order_at','last_order_id','listing_variant_id','inventory_sync','price_sync','product_id','store_id','user_id'
  	];
}
