<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Nicolaslopezj\Searchable\SearchableTrait;

class Profile extends Model
{
	protected $table = 'profiles';
	protected $connection = 'tenants';

	public function category1(){
		return $this->hasOne('App\EbayCategory','id','ebay_category_1');
	}

	public function category2(){
		return $this->hasOne('App\EbayCategory','id','ebay_category_2');
	}

	public function storeCategory(){
		return $this->hasOne('App\EbayStoreCategory','id','store_category');
	}

	public function paymentProfile(){
		return $this->hasOne('App\EbaySellerProfile','id','payment_profile');
	}

	public function shippingProfile(){
		return $this->hasOne('App\EbaySellerProfile','id','shipping_profile');
	}

	public function returnProfile(){
		return $this->hasOne('App\EbaySellerProfile','id','return_profile');
	}

	public function template(){
		return $this->hasOne('App\Template','id','template_id');
	}

	public function store(){
		return $this->belongsTo('App\ShopifyStore','store_id','id');
	}
    
  	public function user(){
		return $this->belongsTo('App\User','user_id','id');
	}

	protected $fillable = [
		'trim_title',
		'name',
		'is_default_profile',
		'listing_title',
		'product_id_type',
		'item_condition',
		'child_item_condition',
		'ebay_category_1',
		'ebay_category_2',
		'store_category',
		'listing_format',
		'listing_duration',
		'item_location',
		'paypal_email',
		'immediate_payment',
		'payment_methods',
		'payment_instructions',
		'sales_tax_region',
		'sales_tax_rate',
		'apply_tax_to_shipping',
		'domestic_returns_accepted',
		'domestic_returned_within',
		'domestic_returns_paid_by',
		'domestic_refund_given_as',
		'international_returns_accepted',
		'international_returned_within',
		'international_returns_paid_by',
		'international_refund_given_as',
		'return_policy_details',
		'item_specifics',
		'item_specifics2',

		'domestic_shipping',
		'domestic_ship_service1',
		'ship_fee1',
		'x_ship_fee1',
		'domestic_free_shipping',
		'domestic_local_pickup',
		'domestic_ships_within_handling_days',
		'domestic_pkg_handling_fee',
		'domestic_ship_additional_services',

		'intl_shipping',
		'intl_ship_options1',
		'intl_locations1',
		'intl_ship_service1',
		'intl_ship_fee1',
		'intl_x_ship_fee1',
		'intl_pkg_handling_fee',
		'ship_options',
		'ship_global_locations',
		'postal_code',
		'intl_ship_additional_services',

		'shipping_profile',
		'payment_profile',
		'return_profile',

		'template_id',

		'store_id',
		'user_id'
  	];
}
