<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateShopifyStoresTable extends Migration
{
	public function up(){
		Schema::create('shopify_stores',function(Blueprint $table){
			$table->bigIncrements('id');
			$table->string('store_name');
			$table->string('shopify_store_id',191)->unique();
			$table->string('shopify_url',191)->unique();
			$table->string('frontend_url')->nullable()->default(NULL);
			$table->string('access_token');
			$table->string('locations',100)->nullable()->default(NULL);
			$table->string('install_step',5)->nullable()->default(NULL);
			$table->timestamp('installed_at');
			$table->timestamp('activated_at')->nullable()->default(NULL);
			$table->timestamp('uninstalled_at')->nullable()->default(NULL);
			$table->enum('status',['installed','active','uninstalled','suspended'])->nullable()->default(NULL);
			$table->text('shop_data')->nullable()->default(NULL);
			$table->tinyInteger('import_products')->nullable()->default(1);
			$table->tinyInteger('fix_duplicate_sku')->nullable()->default(NULL);
			$table->tinyInteger('automatic_sku_creation')->nullable()->default(1);
			$table->timestamp('last_order_sync')->nullable()->default(NULL);
			$table->tinyInteger('has_listing_import_products_request')->nullable()->default(NULL);
			$table->tinyInteger('has_inventory_sync_request')->nullable()->default(NULL);
			$table->tinyInteger('has_price_sync_request')->nullable()->default(NULL);
			$table->tinyInteger('has_product_publish_request')->nullable()->default(NULL);
			$table->tinyInteger('has_product_delete_request')->nullable()->default(NULL);
			$table->tinyInteger('has_shipment_update_request')->nullable()->default(NULL);
			$table->tinyInteger('has_order_cancel_request')->nullable()->default(NULL);
			$table->string('source',100)->nullable()->default('app_store');
			$table->string('login_token',100)->nullable()->default(NULL);
			$table->unsignedInteger('plan_id')->nullable()->default(1);
			$table->foreign('plan_id')->references('id')->on('plans')->onDelete('set null');
			$table->unsignedBigInteger('user_id');
			$table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
			$table->timestamps();
		});
	}
	public function down(){
		Schema::dropIfExists('shopify_stores');
	}
}
