<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Schema;

class CreateEbayShippingServicesTable extends Migration
{
    
    public function up()
    {
        Schema::create('ebay_shipping_services', function (Blueprint $table) {
            $table->increments('id');
            $table->string('description')->nullable()->default(NULL);
			$table->boolean('international_service')->default(false);
			$table->string('shipping_service');
			$table->integer('shipping_service_id');
			$table->integer('shipping_time_max');
			$table->integer('shipping_time_min');
			$table->boolean('valid_for_selling_flow')->default(true);
			$table->string('shipping_carrier');
			$table->boolean('weight_required')->default(true);
			$table->string('shipping_category');
			$table->integer('ebay_site');
            $table->timestamps();
        });
    }

    
    public function down()
    {
        Schema::drop('ebay_shipping_services');
    }
}
