<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Schema;

class CreateEbaySellerProfilesTable extends Migration
{
    
    public function up()
    {
        if(!Schema::connection('tenants')->hasTable('ebay_seller_profiles')){
            Schema::connection('tenants')->create('ebay_seller_profiles',function(Blueprint $table){
                $table->increments('id');
                $table->string('seller_profile_id');
                $table->string('name');
                $table->string('type');
                $table->unsignedInteger('account_id')->nullable()->default(NULL);
                $table->foreign('account_id')->references('id')->on(config('config.default_database').'.ebay_accounts')->onDelete('set null');
                $table->unsignedBigInteger('store_id');
                $table->foreign('store_id')->references('id')->on(config('config.default_database').'.shopify_stores')->onDelete('cascade');
                $table->unsignedBigInteger('user_id');
                $table->foreign('user_id')->references('id')->on(config('config.default_database').'.users')->onDelete('cascade');
                $table->timestamps();
            });
        }
    }

    
    public function down()
    {
        Schema::connection('tenants')->dropIfExists('ebay_seller_profiles');
    }
}
