<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateProductsTable extends Migration
{
    public function up(){
        if(!Schema::connection('tenants')->hasTable('products')){
            Schema::connection('tenants')->create('products',function(Blueprint $table){
                $table->bigIncrements('id');
                $table->string('title',500);
                $table->string('image',500)->nullable()->default(NULL);
                $table->string('status',100)->nullable()->default("unpublished");
                $table->unsignedBigInteger('shopify_product_id');
                $table->string('shopify_product_handle',500);
                $table->string('shopify_product_type')->nullable()->default(NULL);
                $table->longText('shopify_product_data')->nullable()->default(NULL);
                $table->tinyInteger('offer_only')->nullable()->default(NULL);
                $table->unsignedBigInteger('error_no')->nullable()->default(NULL);
                $table->tinyInteger('submit')->nullable()->default(NULL);
                $table->unsignedBigInteger('listing_id')->nullable()->default(NULL);
                $table->foreign('listing_id')->references('id')->on('listings')->onDelete('set null');
                $table->unsignedInteger('profile_id')->nullable()->default(NULL);
                $table->foreign('profile_id')->references('id')->on('profiles')->onDelete('set null');
                $table->unsignedBigInteger('store_id');
                $table->foreign('store_id')->references('id')->on(config('config.default_database').'.shopify_stores')->onDelete('cascade');
                $table->unsignedBigInteger('user_id');
                $table->foreign('user_id')->references('id')->on(config('config.default_database').'.users')->onDelete('cascade');
                $table->timestamps();
            });
        }
    }
    
    public function down(){
        Schema::connection('tenants')->dropIfExists('products');
    }
}
