<?php

use \DTS\eBaySDK\Constants;
use \DTS\eBaySDK\Trading\Services;
use \DTS\eBaySDK\Trading\Types;
use \DTS\eBaySDK\Trading\Enums;
use \DTS\eBaySDK\Parser;

require_once("includes/sendgrid/sendgridphp.php");

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $key = $_POST['key'] ?? '';
    $operation = $_POST['op'] ?? '';

    $user_id = $key;
    $op = $operation;

    $host = "localhost";
    $username = "app4_ebay";
    $password = "38d(g5G+Y+][";
    $dbname = "app4_ebay_shopify";

    // Establish connection to main database
    $conn = new mysqli($host, $username, $password, $dbname);

    if ($conn->connect_error) {
        echo json_encode(array("status" => "error", "msg" => "Internal server error: " . $conn->connect_error));
        exit;
    }

    // Query main database for user_id
    $keyValue = $conn->real_escape_string($user_id);
    $userQuery = "SELECT * FROM shopify_stores WHERE user_id = ?";
    $stmt = $conn->prepare($userQuery);
    $stmt->bind_param("s", $keyValue);
    $stmt->execute();
    $userResult = $stmt->get_result();

    // Check if user_id exists in main database
    if ($userResult->num_rows <= 0) {
        echo json_encode(array("status" => "error", "msg" => "No matching records found in 'shopify_stores' table."));
        exit;
    }

    $userRow = $userResult->fetch_assoc();
    $id = $userRow['id'];

    mysqli_set_charset($conn, "utf8");

    $host2 = "localhost";
    $username2 = "app4_ebay";
    $password2 = "38d(g5G+Y+][";
    $dbname2 = "app4_es-sh-store_$id";

    $conn2 = new mysqli($host2, $username2, $password2, $dbname2);

    if ($conn2->connect_error) {
        echo json_encode(array("status" => "error", "msg" => "Sub database connection failed: " . $conn2->connect_error));
        exit;
    }

    if ($op == 'gettotalitems') {
        $result = $conn2->query("SELECT COUNT(*) AS count FROM products");

        if ($result->num_rows > 0) {
            $row = $result->fetch_assoc();
            $count = $row['count'];
            echo json_encode(array("status" => "success", "msg" => "Total items fetched successfully.", "count" => $count));
        } else {
            echo json_encode(array("status" => "error", "msg" => "Failed to fetch total items."));
        }
        exit;
    } elseif ($op == 'gettotalitems123') {
        $result = $conn2->query("SELECT COUNT(*) AS count FROM listings WHERE product_id IS NULL");

        if ($result->num_rows > 0) {
            $row = $result->fetch_assoc();
            $count = $row['count'];
            echo json_encode(array("status" => "success", "msg" => "Total items fetched successfully.", "count" => $count));
        } else {
            echo json_encode(array("status" => "error", "msg" => "Failed to fetch total items."));
        }
        exit;
    } elseif ($op == 'initiateshopifyfetch') {
    // Select store_id from shopify_stores
    $selectQuery = "SELECT * FROM shopify_stores WHERE user_id = ?";
    $stmt = $conn->prepare($selectQuery);
    $stmt->bind_param("s", $user_id);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        $row = $result->fetch_assoc();
        $store_id = $row['id'];

        if ($store_id !== null) {
            // Check if the user_id already exists in sh_request
            $checkQuery = "SELECT * FROM sh_request WHERE user_id = ? AND status = 'pending'";
            $checkStmt = $conn->prepare($checkQuery);
            $checkStmt->bind_param("s", $user_id);
            $checkStmt->execute();
            $checkResult = $checkStmt->get_result();
            $checkStmt->close();

            if ($checkResult->num_rows > 0) {
                echo json_encode(array("status" => "error", "msg" => "Request already in progress."));
                exit;
            }

            // Start transaction
            $conn->begin_transaction();

            // Update import_products in shopify_stores
            $updateQuery = "UPDATE shopify_stores SET import_products = 1 WHERE user_id = ?";
            $updateStmt = $conn->prepare($updateQuery);
            $updateStmt->bind_param("s", $user_id);
            $updateResult = $updateStmt->execute();
            $updateStmt->close();

            if ($updateResult) {
                // Insert into sh_request
                $insertQuery = "INSERT INTO sh_request (user_id, status, store_id, inprocess, created_at, updated_at) VALUES (?, 'pending', ?, 0, NOW(), NOW())";
                $insertStmt = $conn->prepare($insertQuery);
                $insertStmt->bind_param("ss", $user_id, $store_id);
                $insertResult = $insertStmt->execute();
                $insertStmt->close();

                if ($insertResult) {
                    // Commit transaction
                    $conn->commit();
                    echo json_encode(array("status" => "success", "msg" => "Request has been submitted successfully."));
                } else {
                    // Rollback transaction
                    $conn->rollback();
                    $error = $conn->error;
                    echo json_encode(array("status" => "error", "msg" => "Failed to insert request. Error: $error"));
                }
            } else {
                // Rollback transaction
                $conn->rollback();
                $error = $conn->error;
                echo json_encode(array("status" => "error", "msg" => "Failed to update import_products. Error: $error"));
            }
        } else {
            echo json_encode(array("status" => "error", "msg" => "Store ID is null for this user."));
        }
    } else {
        echo json_encode(array("status" => "error", "msg" => "No shopify store found for this user."));
    }

    exit;
}


 elseif ($op == 'initiateebayfetch') {
    // Select store_id from shopify_stores
    $selectQuery = "SELECT * FROM shopify_stores WHERE user_id = ?";
    $stmt = $conn->prepare($selectQuery);
    $stmt->bind_param("s", $user_id);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        $row = $result->fetch_assoc();
        $store_id = $row['id']; 

        if ($store_id !== null) { // Check if store_id is not null
            // Check if the user_id already exists in eb_request
            $checkQuery = "SELECT * FROM eb_request WHERE user_id = ? AND status = 'pending'";
            $checkStmt = $conn->prepare($checkQuery);
            $checkStmt->bind_param("s", $user_id);
            $checkStmt->execute();
            $checkResult = $checkStmt->get_result();
            $checkStmt->close();

            if ($checkResult->num_rows > 0) {
                echo json_encode(array("status" => "error", "msg" => "Request already in progress."));
                exit;
            }

            // Update import_products to 0 in ebay_accounts
            $updateQuery = "UPDATE ebay_accounts SET import_products = 1 WHERE user_id = ?";
            $stmt = $conn->prepare($updateQuery);
            $stmt->bind_param("s", $user_id);
            $updateResult = $stmt->execute();
            $stmt->close();

            // Insert into eb_request
            $insertQuery = "INSERT INTO eb_request (user_id, status, store_id, inprocess, created_at, updated_at) VALUES (?, 'pending', ?, 0, NOW(), NOW())";
            $stmt = $conn->prepare($insertQuery);
            $stmt->bind_param("ss", $user_id, $store_id);
            $insertResult = $stmt->execute();
            $stmt->close();

            if ($updateResult && $insertResult) {
                echo json_encode(array("status" => "success", "msg" => "Request has been submitted successfully."));
            } else {
                $error = $conn->error;
                echo json_encode(array("status" => "error", "msg" => "Failed to submit request. Error: $error"));
            }
        } else {
            echo json_encode(array("status" => "error", "msg" => "Store ID is null for this user."));
        }
    } else {
        echo json_encode(array("status" => "error", "msg" => "No shopify store found for this user."));
    }

    exit;
}
 elseif ($op == 'sendemail') {
        $result = $conn->query("SELECT * FROM users WHERE id = " . $conn->real_escape_string($user_id));
        if ($result->num_rows < 1) {
            $result = array("status" => "error", "msg" => "Invalid request.");
            echo json_encode($result);
            exit;
        }
        if (!isset($_POST['emailtype'])) {
            $result = array("status" => "error", "msg" => "Invalid email type.");
            echo json_encode($result);
            exit;
        }
        $emailtype = trim($_POST['emailtype']);
        $row = $result->fetch_assoc();
        $name = $row['ownername'];
        $email = $row['email'];
        
        
        $subject = "";
        $body = "";
        
          if ($emailtype == "setup") {
           	$subject = "Re: Welcome to Shopify to eBay Importer";
		    $body =  '<p>Dear '.$name.'</p>
		        <p>Thank you for installing our app. Here are the instructions to install the Shopify to eBay app.</p>
                <p> Registration (Step-1): Start the registration process by accepting our terms and creating a basic eBay profile. Here is the video: <a href="https://app4.ecomshore.com/service/public/step-1-gif.gif" target="_blank">Click here</a></p>
                <p>Connect Your eBay Account (Step-2): Connect your eBay account and add the basic information needed to list your items. Watch this step 2 video :<a href="https://app4.ecomshore.com/service/public/step-2-gif.gif" target="_blank">Click here</a></p>
                <p>Add eBay Business Policies (Step-3): In the final step, add your eBay business policies, select the eBay category, and item specifics. Here is the video for this step :<a href="https://app4.ecomshore.com/service/public/step-3-gif.gif" target="_blank">Click here</a></p>
                <p>Important Note: Business policies are crucial for publishing products on eBay. If you already have business policies, select them from the dropdown menus labeled "Return," "Payment," and "Shipping Policy." If you do not have existing business policies, you can create shipping and return policies directly from the profile page.</p>
                <p>When creating your profile, please ensure accurate information regarding the eBay category, postal code, and location. Incorrect eBay category selection can lead to a ban on your eBay account.</p>
                <p>We have provided 10 free listings for you. If you want to publish more products and explore more features, please purchase a subscription.</p>
                <p>Please respond to this email if you face any issues while completing these steps.</p>
                <p>Additionally, you can book a FREE setup call using this link.</p>
                
                <p>Best Regards,<br />Rohit Khariwal<br />Manager - Shopify Applications </p>';
				
            $emailObj = new \SendGrid\Mail\Mail(); 
            $emailObj->setFrom("shopifyapps@infoshore.biz", "Rohit from InfoshoreApps");
            $emailObj->setSubject($subject);
            $emailObj->addTo($email);
            $emailObj->addBcc("pankajnarang81@gmail.com");
            $emailObj->addContent("text/html", $body);
            $sendgrid = new \SendGrid('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');
            try {
                $response = $sendgrid->send($emailObj);
                echo json_encode(array("status" => "success", "msg" => "Email sent successfully."));
            } catch (Exception $e) {
                echo json_encode(array("status" => "error", "msg" => "Failed to send email. Error: " . $e->getMessage()));
            }
        }
        elseif ($emailtype == "welcome") {
            $subject = "Re: Welcome to Shopify to eBay Importer";
            $body = '<p>Dear ' . $name . '</p>
                <p>Thank you for installing our app, You have successfully installed our Shopify to eBay app.</p>
                <p>We can see that you have created business policies on your eBay account. Business policies are mandatory for publishing products on eBay.</p>
                <p>It is time to import your first product. Here is a helpful video guide on how to publish your first product on eBay: <a href="https://player.vimeo.com/video/942204338?badge=0&amp;autopause=0&amp;player_id=0&amp;app_id=58479" target="_blank">Click here</a></p>
                <p>We provide 10 free listings for you. If you want to publish more products and explore more features, please purchase a subscription.</p>
                <p>Please respond to this email if you face any issues while publishing this first step.</p>
                <p>Additionally, you can book a FREE setup call using the <a href="https://calendly.com/pankajnarang81/shopify-to-ebay-integration-session">link</a>.</p>
                <p>Best Regards,<br />Rohit Khariwal<br />Manager - Shopify Applications</p>';

            $emailObj = new \SendGrid\Mail\Mail(); 
            $emailObj->setFrom("shopifyapps@infoshore.biz", "Rohit from InfoshoreApps");
            $emailObj->setSubject($subject);
            $emailObj->addTo($email);
            $emailObj->addBcc("pankajnarang81@gmail.com");
            $emailObj->addContent("text/html", $body);
            $sendgrid = new \SendGrid('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');
            try {
                $response = $sendgrid->send($emailObj);
                echo json_encode(array("status" => "success", "msg" => "Email sent successfully."));
            } catch (Exception $e) {
                echo json_encode(array("status" => "error", "msg" => "Failed to send email. Error: " . $e->getMessage()));
            }
        }  elseif ($emailtype == "setupincomplete") {
           $subject = "Re: Welcome to Shopify to eBay Importer";
           $body = '<p>Dear ' . $name . ',</p>
           <p>Thank you for installing our app. You have successfully installed our Shopify to eBay app.</p>
           <p>We noticed that you have not completed all the steps to set up the app.</p>
           <p>Please properly set up the app so you can use it without any issues. Follow the link below to set up your account:</p>
           <p>Here are the step-by-step setup instructions:</p>
           <p>Step 1: <a href="https://app4.ecomshore.com/service/public/step-1-gif.gif" target="_blank">Click here</a> to watch the video.</p>
           <p>Step 2: Connect your eBay account and add the basic information needed to list your items. Watch this video: <a href="https://app4.ecomshore.com/service/public/step-2-gif.gif" target="_blank">Click here</a></p>
           <p>Step 3: Add your eBay business policies, select the eBay category, and item specifics. Watch this video: <a href="https://app4.ecomshore.com/service/public/step-3-gif.gif" target="_blank">Click here</a></p>
           <p>Additionally, you can book a FREE setup call using this <a href="https://calendly.com/pankajnarang81/shopify-to-ebay-integration-session">link</a>.</p>
           <p>Best Regards,<br />Rohit Khariwal<br />Manager - Shopify Applications</p>';


            $emailObj = new \SendGrid\Mail\Mail(); 
            $emailObj->setFrom("shopifyapps@infoshore.biz", "Rohit from InfoshoreApps");
            $emailObj->setSubject($subject);
            $emailObj->addTo($email);
            $emailObj->addBcc("pankajnarang81@gmail.com");
            $emailObj->addContent("text/html", $body);
            $sendgrid = new \SendGrid('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');
            try {
                $response = $sendgrid->send($emailObj);
                echo json_encode(array("status" => "success", "msg" => "Email sent successfully."));
            } catch (Exception $e) {
                echo json_encode(array("status" => "error", "msg" => "Failed to send email. Error: " . $e->getMessage()));
            }
        }
        
          elseif ($emailtype == "firstpublished") {
           	$subject = "Congratulation on First Successful Import";
		$body =  '<p>Dear '.$ownername.'</p>
		
                <p>We can see that You have just published a product on eBay. Here is the link of your published product :<a href='.$listing_url_mail.' target="_blank">Click here</a></p>
                
                <p>Since you have published first product you can check our plans and pricing from plan & pricings page on our app.</a></p>
               
                <p>Additionally, you can reply to this email in case of any query.</a></p>
                
                <p>Best Regards,<br />Rohit Khariwal<br />Manager - Shopify Applications </p>';
                
				
		$email = new \SendGrid\Mail\Mail(); 
        $email->setFrom("shopifyapps@infoshore.biz", "Rohit from InfoshoreApps");
        $email->setSubject($subject);
        $email->addTo($to);
        $email->addBcc("pankajnarang81@gmail.com");
        $email->addContent(
			 "text/html", $body
               );
		$sendgrid = new \SendGrid('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');
        try {
			$response = $sendgrid->send($email);
			echo "email sent";
            return true;
		} catch (Exception $e) {
            return false;
        }		
	}
        
        else if($emailtype == "policy"){
		  $subject = "Congratulation on First Successful Import";
		$body =  '<p>Dear '.$ownername.'</p>
		
                <p>We can see that You have just published a product on eBay and you have not created business policies on your ebay account. Here is the link of your published product :<a href='.$listing_url_mail.' target="_blank">Click here</a></p>
                
                <p>However, we highly recommend creating your own business policies on eBay. You can find guidance on how to create business policies on eBay by following this link :<a href="https://app4.ecomshore.com/service/public/Create_policy.gif" target="_blank">Click here</a></p>
                
                <p>Since you have published first product you can check our plans and pricing from plan & pricings page on our app.</a></p>
               
                <p>Additionally, you can reply to this email in case of any query.</a></p>
                
                <p>Best Regards,<br />Rohit Khariwal<br />Manager - Shopify Applications </p>';
                
				
		$email = new \SendGrid\Mail\Mail(); 
        $email->setFrom("shopifyapps@infoshore.biz", "Rohit from InfoshoreApps");
        $email->setSubject($subject);
        $email->addTo($to);
        $email->addBcc("pankajnarang81@gmail.com");
        $email->addContent(
			 "text/html", $body
               );
		$sendgrid = new \SendGrid('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');
        try {
			$response = $sendgrid->send($email);
			echo "email sent";
            return true;
		} catch (Exception $e) {
            return false;
        }		
	}else if($emailtype == "pricelimit"){ //productlimit
		  	$subject = "Re: Welcome to Shopify to eBay Importer";
		$body =  '<p>Dear '.$name.'</p>
		
		        
               <p>We noticed that you have reached your listing limit for the current month.Please consider reducing the starting price of your listings or request to increase your listing limit.</p>
               
               <p>To continue publishing your products without any issues please increase your price limit</p>
               
               <p>Additionally, you can book a FREE setup call using this link: <a href="https://calendly.com/pankajnarang81/shopify-to-ebay-integration-session">Book Setup Call</a></p>
               
               <p>Best Regards,<br />Rohit Khariwal<br />Manager - Shopify Applications</p>';


            $emailObj = new \SendGrid\Mail\Mail(); 
            $emailObj->setFrom("shopifyapps@infoshore.biz", "Rohit from InfoshoreApps");
            $emailObj->setSubject($subject);
            $emailObj->addTo($email);
            $emailObj->addBcc("pankajnarang81@gmail.com");
            $emailObj->addContent("text/html", $body);
            $sendgrid = new \SendGrid('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');
            try {
                $response = $sendgrid->send($emailObj);
                echo json_encode(array("status" => "success", "msg" => "Email sent successfully."));
            } catch (Exception $e) {
                echo json_encode(array("status" => "error", "msg" => "Failed to send email. Error: " . $e->getMessage()));
            }
		}else if($emailtype == "productlimit"){ 
		  	$subject = "Re: Welcome to Shopify to eBay Importer";
		$body =  '<p>Dear '.$name.'</p>
		
		        <p>We noticed that you have reached your listing limit for the current month.Please consider reducing the limit of your listings or request to increase your listing limit.</p>
               
               <p>To continue publishing your products without any issues please increase your limit </p>
               
               <p>Additionally, you can book a FREE setup call using this link: <a href="https://calendly.com/pankajnarang81/shopify-to-ebay-integration-session">Book Setup Call</a></p>
               
               <p>Best Regards,<br />Rohit Khariwal<br />Manager - Shopify Applications</p>';


            $emailObj = new \SendGrid\Mail\Mail(); 
            $emailObj->setFrom("shopifyapps@infoshore.biz", "Rohit from InfoshoreApps");
            $emailObj->setSubject($subject);
            $emailObj->addTo($email);
            $emailObj->addBcc("pankajnarang81@gmail.com");
            $emailObj->addContent("text/html", $body);
            $sendgrid = new \SendGrid('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');
            try {
                $response = $sendgrid->send($emailObj);
                echo json_encode(array("status" => "success", "msg" => "Email sent successfully."));
            } catch (Exception $e) {
                echo json_encode(array("status" => "error", "msg" => "Failed to send email. Error: " . $e->getMessage()));
            }
		}else if($emailtype == "invalid"){ 
		  	$subject = "Re: Welcome to Shopify to eBay Importer";
		$body =  '<p>Dear '.$name.'</p>
		
		      <p>It is required to re-authorize connected eBay account with <strong>eBay Professional Importer</strong> Shopify app.</p>	
		    
			<p>Login to the app from Shopify store admin and complete the authorization.</p>
			
			<p>Get back to us in case of any issue.</p>
			
			<p>Best Regards,<br />InfoShore Apps</p>';


            $emailObj = new \SendGrid\Mail\Mail(); 
            $emailObj->setFrom("shopifyapps@infoshore.biz", "Rohit from InfoshoreApps");
            $emailObj->setSubject($subject);
            $emailObj->addTo($email);
            $emailObj->addBcc("pankajnarang81@gmail.com");
            $emailObj->addContent("text/html", $body);
            $sendgrid = new \SendGrid('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');
            try {
                $response = $sendgrid->send($emailObj);
                echo json_encode(array("status" => "success", "msg" => "Email sent successfully."));
            } catch (Exception $e) {
                echo json_encode(array("status" => "error", "msg" => "Failed to send email. Error: " . $e->getMessage()));
            }
		}else if($emailtype == "create"){ 
		  	$subject = "Re: Welcome to Shopify to eBay Importer";
		$body =  '<p>Dear '.$name.'</p>
		
		     <p>Before you can list this item, you need to create a seller account on eBay.</p>	
		    
		     <p>If you encounter any issues, please get back to us.</p>
		     
             <p>Best Regards,<br />InfoShore Apps</p>';


            $emailObj = new \SendGrid\Mail\Mail(); 
            $emailObj->setFrom("shopifyapps@infoshore.biz", "Rohit from InfoshoreApps");
            $emailObj->setSubject($subject);
            $emailObj->addTo($email);
            $emailObj->addBcc("pankajnarang81@gmail.com");
            $emailObj->addContent("text/html", $body);
            $sendgrid = new \SendGrid('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');
            try {
                $response = $sendgrid->send($emailObj);
                echo json_encode(array("status" => "success", "msg" => "Email sent successfully."));
            } catch (Exception $e) {
                echo json_encode(array("status" => "error", "msg" => "Failed to send email. Error: " . $e->getMessage()));
            }
		}else if($emailtype == "technical"){ 
		    
            $subject = "Re: Welcome to Shopify to eBay Importer";
      $body =  '<p>Dear '.$name.'</p>
      
          <p>Due to some technical issues, the app server was down but it is now fixed. Please check it again.</p>

          <p>If you encounter any issues, please let us know.</p>

          <p>Best Regards,<br />InfoShore Apps</p>';


          $emailObj = new \SendGrid\Mail\Mail(); 
          $emailObj->setFrom("shopifyapps@infoshore.biz", "Rohit from InfoshoreApps");
          $emailObj->setSubject($subject);
          $emailObj->addTo($email);
          $emailObj->addBcc("pankajnarang81@gmail.com");
          $emailObj->addContent("text/html", $body);
          $sendgrid = new \SendGrid('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');
          try {
              $response = $sendgrid->send($emailObj);
              echo json_encode(array("status" => "success", "msg" => "Email sent successfully."));
          } catch (Exception $e) {
              echo json_encode(array("status" => "error", "msg" => "Failed to send email. Error: " . $e->getMessage()));
          }
      }
	
	
	
        
        else {
            echo json_encode(array("status" => "error", "msg" => "Invalid email type."));
        }
        exit;
    } if ($_POST['test'] == 'sendemailcustom') {
        $user_id = $_POST['key'];
        $result = $conn->query("SELECT * FROM users WHERE id = " . $conn->real_escape_string($user_id));
        if ($result->num_rows < 1) {
            $result = array("status" => "error", "msg" => "Invalid request.");
            echo json_encode($result);
            exit;
        }
        
        $row = $result->fetch_assoc();
        $name = $row['ownername'];
        $email = $row['email'];
    
        $subject = $_POST['subject']; // Get the subject from the POST data
        $body = $_POST['customemailmessage'];
    
        // Example SendGrid usage
        $emailObj = new \SendGrid\Mail\Mail(); 
        $emailObj->setFrom("shopifyapps@infoshore.biz", "Rohit from InfoshoreApps");
        $emailObj->setSubject($subject); // Use the retrieved subject
        $emailObj->addTo($email);
        $emailObj->addBcc("pankajnarang81@gmail.com");
        $emailObj->addContent("text/html", $body);
        $sendgrid = new \SendGrid('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');
    
        try {
            $response = $sendgrid->send($emailObj);
            echo json_encode(array("status" => "success", "msg" => "Email sent successfully."));
        } catch (Exception $e) {
            echo json_encode(array("status" => "error", "msg" => "Failed to send email. Error: " . $e->getMessage()));
        }
    }
     else {
        echo json_encode(array("status" => "error", "msg" => "Invalid operation specified."));
    }
} else {
    echo json_encode(array("status" => "error", "msg" => "Invalid request method."));
}

?>
