<?php

$host12 = "69.64.64.108";
$username12 = "app1_ebay";
$password12 = "38d(g5G+Y+][";
$dbname12 = "app1_ebay_shopify";
$conn12 = new mysqli($host12, $username12, $password12, $dbname12);




if ($conn12->connect_error) {
    // TODO: Add some logging and email notification here
    die("Connection failed: " . $conn12->connect_error);
}

// CSV file for errors in Shopify data retrieval
$error_csv_file = fopen('store_not_available.csv', 'w');
fputcsv($error_csv_file, array('User ID', 'Store Name', 'Shopify URL', 'Token', 'Error'));

// CSV file for errors in recurring payment data
$recurring_csv_file = fopen('recurring_payment_fail.csv', 'w');
fputcsv($recurring_csv_file, array('User ID', 'Store Name', 'Shopify URL', 'Token'));

$success_csv_file = fopen('user_is_valid.csv', 'w');
fputcsv($success_csv_file, array('User ID', 'Store Name', 'Shopify URL', 'Token'));

$result = $conn12->query("SELECT * FROM users WHERE created_at <= DATE_SUB(CURDATE(), INTERVAL 3 MONTH)");


if ($result && $result->num_rows > 0) {
  

    while ($row = $result->fetch_assoc()) {
        $user_id = $row['id'];
      

        $shop_query = "SELECT * FROM shopify_stores WHERE user_id = $user_id AND plan_id = 1";
        $shop_result = $conn12->query($shop_query);

        if ($shop_result && $shop_result->num_rows > 0) {
            while ($shop_row = $shop_result->fetch_assoc()) {
            
                $store_name = $shop_row['store_name'];
                $id = $shop_row['id'];
                $shopify_url = $shop_row['shopify_url'];
                $token = $shop_row['access_token'];
                $userid = $shop_row['user_id'];
               // print_r("   ".$user_id." => ".$shopify_url);
               
                
                $shopData = getShopifyData123($userid, $token, $shopify_url);
                
              // print_r("  These shops does not existssssssssssss ".json_encode($shopData,true));
                if (isset($shopData['error'])) {
                    // These shops does not exists or login token of these shops is expired
                    
                    $errorMessage = $shopData['error'];
                    //  print_r("  These shops does not exists ".$userid." => ".$shopify_url);
                   
                   //putting them in csv file
                    fputcsv($error_csv_file, array(
                        $userid,
                        $store_name,
                        $shopify_url,
                        $token,
                        $errorMessage
                    ));
                    
                     //delete the entire db for this user_id
                     
                   
                }else {
                   //  print_r("  These shops doesssssssssss  ".json_encode($shopData,true));
                     // These shops exist or login token of these shops is not expired
                    
                    $recurringCharges = GetRecurringPayment($userid, $token, $shopify_url);
                   //  print_r("  recurring Charges for => ".$userid." ,  data =>".json_encode($recurringCharges,true)."   ");
                    if ($recurringCharges === null || empty($recurringCharges)) {
                         
                           // These shops does not have valid plan of our app
                         
                       //  print_r("  These shops does not have valid plan => ".$userid."   ");
                         
                         //putting them in csv file
                    fputcsv($recurring_csv_file, array(
                        $userid,
                        $store_name,
                        $shopify_url,
                        $token
                    ));
                    
                     //delete the entire db for this user_id
                     
                  
                    
                }
                    else{
                       // These shops exist ,login token of these shops is not expired and they have a valid plan
                       
                       print_r("  These shops are correct for user id=> ".$userid." and ".$shopify_url);
                        fputcsv($success_csv_file, array(
                        $user_id,
                        $store_name,
                        $shopify_url,
                        $token,
                        ""
                    )); 
                    }
                   
                }

           
                
               
            }
        }
    }

    // Close CSV files
    fclose($success_csv_file);
    fclose($error_csv_file);
    fclose($recurring_csv_file);

    echo "CSV files created.";
} else {
    echo "No users found.";
}

$conn12->close();

function getShopifyData123($userid, $token, $shopify_url) {
    global $conn12; // Changed $conn to $conn12
    $url = "https://" . $shopify_url . "/admin/api/2023-10/shop.json";
    $curl = curl_init();
    curl_setopt($curl, CURLOPT_URL, $url);
    curl_setopt($curl, CURLOPT_HTTPGET, 1);
    curl_setopt($curl, CURLOPT_HEADER, false);
    curl_setopt($curl, CURLOPT_HTTPHEADER, array('X-Shopify-Access-Token:' . $token));
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);

    $response = curl_exec($curl);
    $shopdata = json_decode($response, true);
    curl_close($curl);

    if ($response) {
        if (isset($shopdata['shop'])) {
            $shop_owner = $shopdata['shop']['shop_owner'];
            $email = $shopdata['shop']['email'];
            $created_at = $shopdata['shop']['created_at'];
            $updated_at = $shopdata['shop']['updated_at'];
            $plan_name = $shopdata['shop']['plan_name'];
            $multi_location_enabled = 0;
           
            return array("name" => $shop_owner, "email" => $email, "plan_name" => $plan_name);
        }
    }
    return array("error" => "Error occurred during API call");
}

function GetRecurringPayment($userid, $token, $shopify_url) {
    $url = "https://".$shopify_url."/admin/api/2023-10/recurring_application_charges.json";

    $curl = curl_init();

    curl_setopt($curl, CURLOPT_URL, $url);
    curl_setopt($curl, CURLOPT_HTTPHEADER, array('X-Shopify-Access-Token:'.$token, 'Content-Type: application/json; charset=utf-8'));
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);

    $response = curl_exec($curl);

    curl_close($curl);    

    if ($response === false) {
        return null; 
    }

    $recurringCharges = json_decode($response, true);
    return $recurringCharges['recurring_application_charges'];
}

?>
