@extends('layouts.shopify')

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header">{{ __('Install App') }}</div>

                <div class="card-body">
                    <form method="GET" action="{{ route('shopifyInstall') }}">
                        <div class="form-group row">
                            <label for="shop" class="col-md-4 col-form-label text-md-right">{{ __('Shopify Store URL') }}</label>

                            <div class="col-md-6">
                                <input id="shop" type="text" class="form-control @error('shop') is-invalid @enderror" name="shop" value="{{ old('shop') }}" required autofocus>
                                <input type="hidden" name="test_install" value="1" />
                                <span class="feedback">Eg : mystore.myshopify.com</span>
                                @error('shop')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                        </div>
                        <div class="form-group row mb-0">
                            <div class="col-md-8 offset-md-4">
                                <button type="submit" class="btn btn-primary">
                                    {{ __('Install') }}
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
