<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Nicolaslopezj\Searchable\SearchableTrait;

class AttributeMapping extends Model {

    protected $table = 'attribute_mapping';
    protected $connection = 'tenants';

	public function store(){
		return $this->belongsTo('App\ShopifyStore','store_id','id');
	}

	public function profile(){
		return $this->belongsTo('App\Profile','profile_id','id');
	}

  	public function user(){
		return $this->belongsTo('App\User','user_id','id');
    }
	
    protected $fillable = [
        'attribute_name','option_name','profile_id','store_id','user_id'
    ];
}
