<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class EbayStoreCategory extends Model {
	
	protected $table = 'ebay_store_categories';
	protected $connection = 'tenants';
	
	public function childs(){
		return $this->hasMany('App\EbayStoreCategory','parent_category_id','id');
	}

	public function store(){
		return $this->belongsTo('App\ShopifyStore','store_id','id');
	}

	public function account(){
		return $this->belongsTo('App\AmazonAccount','account_id','id');
	}

  	public function user(){
		return $this->belongsTo('App\User','user_id','id');
	}

	
	protected $fillable = [
        'category_name',
		'category_tree_name',
		'is_last_level',
		'ebay_category_id',
		'category_level',
		'parent_category_id',
		'parent_category_name',
		'ebay_parent_category_id',
		'account_id',
		'store_id',
		'user_id'
    ];
}
