<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Nicolaslopezj\Searchable\SearchableTrait;

class ListingVariant extends Model
{
	protected $table = 'listing_variants';
	protected $connection = 'tenants';


	public function listing(){
		return $this->belongsTo('App\Listing','listing_id','id');
	}

	public function account(){
		return $this->belongsTo('App\EbayAccount','account_id','id');
	}

	public function variant(){
		return $this->belongsTo('App\ProductVariant','variant_id','id');
	}

	public function store(){
		return $this->belongsTo('App\ShopifyStore','store_id','id');
	}
    
  	public function user(){
		return $this->belongsTo('App\User','user_id','id');
	}

	protected $fillable = [
		'title','ebay_item_id','sku','custom_sku','image','variant_id','listing_variant_data','ebay_item_data','additional_data','last_inventory_synced_at','last_inventory_synced','last_pricing_synced_at','last_price_synced','last_order_at','last_order_id','listing_id','account_id','store_id','user_id'
  	];
}
