<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Nicolaslopezj\Searchable\SearchableTrait;

class Log extends Model
{
	protected $table = 'logs';
	protected $connection= 'tenants';

	public function store(){
		return $this->belongsTo('App\ShopifyStore','store_id','id');
	}

	public function user(){
		return $this->belongsTo('App\User','user_id','id');
	}

  	protected $fillable = [
		'log_type','input_data','output_data','shopify_data','shopify_data_id','log_data','log_data_id','additional_data','remarks','status','store_id','user_id'
  	];
}
