<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Schema;

class CreateEbayAccountsTable extends Migration
{
    public function up()
    {
        Schema::create('ebay_accounts',function(Blueprint $table){
            $table->increments('id');
            $table->string('name');
            $table->enum('siteid',array('0','2','3','15','16','23','71','77','100','101','123','146','186','193','201','203','205','207','210','211','212','216'))->default('0');
			$table->string('sellerid',100)->nullable()->default(NULL);
			$table->text('access_token')->nullable()->default(NULL);
            $table->text('refresh_token')->nullable()->default(NULL);
            $table->string('token_type')->nullable()->default(NULL);
			$table->string('expires_in',100)->nullable()->default(NULL);
            $table->tinyInteger('is_valid')->nullable()->default(NULL);
            $table->tinyInteger('automatic_sku_creation')->nullable()->default(NULL);
            $table->tinyInteger('inventory_sync')->nullable()->default(1);
            $table->tinyInteger('price_sync')->nullable()->default(1);
            $table->tinyInteger('order_sync')->nullable()->default(1);
            $table->tinyInteger('pricing_mark_up')->nullable()->default(NULL);
            $table->string('pricing_mark_up_type',100)->nullable()->default(NULL);
            $table->double('pricing_mark_up_value')->nullable()->default(NULL);
            $table->tinyInteger('listing_quantity')->nullable()->default(NULL);
            $table->integer('listing_quantity_value')->nullable()->default(NULL);
            $table->tinyInteger('threshold_quantity')->nullable()->default(NULL);
            $table->integer('threshold_quantity_value')->nullable()->default(NULL);
            $table->enum('status',['active','inactive'])->default('active');
            $table->timestamp('last_order_sync')->nullable()->default(NULL);
            $table->tinyInteger('do_inventory_sync')->nullable()->default(NULL);
            $table->tinyInteger('do_price_sync')->nullable()->default(NULL);
            $table->unsignedInteger('profile_id')->nullable()->default(NULL);
            $table->unsignedBigInteger('store_id');
            $table->foreign('store_id')->references('id')->on('shopify_stores')->onDelete('cascade');
            $table->unsignedBigInteger('user_id');
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
            $table->tinyInteger('import_products')->nullable()->default(NULL);
            $table->timestamps();
        });
    }
    
    public function down(){
        Schema::dropIfExists('ebay_accounts');
    }
}
