<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Schema;

class CreateEbayCategoriesTable extends Migration
{
    
    public function up()
    {
        Schema::create('ebay_categories',function(Blueprint $table){
            $table->increments('id');
            $table->string('category_name');
			$table->text('category_tree_name');
			$table->boolean('is_last_level')->default(0);
			$table->string('ebay_category_id');
			$table->string('category_level');
			$table->boolean('auto_pay_enabled')->default(0);
			$table->integer('parent_category_id')->nullable()->default(NULL);
            $table->string('parent_category_name')->nullable()->default(NULL);
			$table->string('ebay_parent_category_id')->nullable()->default(NULL);
			$table->integer('ebay_site');
			$table->text('category_attributes')->nullable()->default(NULL);
            $table->timestamps();
        });
    }
    
    public function down()
    {
        Schema::drop('ebay_categories');
    }
}