<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateImportsTable extends Migration
{
    public function up()
    {
        if(!Schema::connection('tenants')->hasTable('imports')){
            Schema::connection('tenants')->create('imports',function(Blueprint $table){
                $table->increments('id');
                $table->string('type');
                $table->string('input_file');
                $table->string('output_file')->nullable()->default(NULL);
                $table->enum('status',['pending','running','done','error','cancelled'])->default('pending');
                $table->timestamp('started_at')->nullable()->default(NULL);
                $table->timestamp('ended_at')->nullable()->default(NULL);
                $table->timestamp('cancelled_at')->nullable()->default(NULL);
                $table->text('remarks')->nullable()->default(NULL);
                $table->unsignedBigInteger('store_id');
                $table->foreign('store_id')->references('id')->on(config('config.default_database').'.shopify_stores')->onDelete('cascade');
                $table->unsignedBigInteger('user_id');
                $table->foreign('user_id')->references('id')->on(config('config.default_database').'.users')->onDelete('cascade');
                $table->timestamps();
            });
        }
    }
    
    public function down()
    {
        Schema::connection('tenants')->dropIfExists('imports');
    }
}
