<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateProductDataTable extends Migration
{
    public function up(){
        if(!Schema::connection('tenants')->hasTable('product_data')){
            Schema::connection('tenants')->create('product_data',function(Blueprint $table){
                $table->bigIncrements('id');
                $table->string('title',500)->nullable()->default(NULL);
                $table->string('sub_title',500)->nullable()->default(NULL);
                $table->string('condition',100)->nullable()->default(NULL);
                $table->longText('condition_note')->nullable()->default(NULL);
                $table->longText('item_specific_values')->nullable()->default(NULL);
                $table->unsignedBigInteger('shopify_product_id');
                $table->string('shopify_product_handle',500);
                $table->unsignedInteger('profile_id')->nullable()->default(NULL);
                $table->foreign('profile_id')->references('id')->on('profiles')->onDelete('set null');
                $table->unsignedBigInteger('product_id');
                $table->foreign('product_id')->references('id')->on('products')->onDelete('cascade');
                $table->unsignedBigInteger('store_id');
                $table->foreign('store_id')->references('id')->on(config('config.default_database').'.shopify_stores')->onDelete('cascade');
                $table->unsignedBigInteger('user_id');
                $table->foreign('user_id')->references('id')->on(config('config.default_database').'.users')->onDelete('cascade');
                $table->timestamps();
            });
        }
    }
    
    public function down(){
        Schema::connection('tenants')->dropIfExists('product_data');
    }
}
