<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Nicolaslopezj\Searchable\SearchableTrait;

class EbayAccount extends Model
{
	protected $table = 'ebay_accounts';
	protected $connection = 'mysql';

	public function store(){
		return $this->belongsTo('App\ShopifyStore','store_id','id');
	}

	public function reports(){
		return $this->hasMany('App\AmazonReport','account_id','id');
	}

	public function feeds(){
		return $this->hasMany('App\AmazonFeed','account_id','id');
	}

	public function listings(){
		return $this->hasMany('App\Listing','account_id','id');
	}
	
	public function listingVariants(){
		return $this->hasMany('App\ListingVariant','account_id','id');
	}
	
	public function profile(){
		return $this->hasOne('App\Profile','profile_id','id');
  	}

	public function ebaySellerProfiles(){
		return $this->hasMany('App\EbaySellerProfile','account_id','id');
  	}

	public function ebayStoreCategories(){
		return $this->hasMany('App\EbayStoreCategory','account_id','id');
  	}
    
  	public function user(){
		return $this->belongsTo('App\User','user_id','id');
	}

	public function orders(){
		return $this->hasMany('App\Order','account_id','id');
	}

	public function pendingProductPublish(){
		return $this->hasMany('App\PendingProductPublish','account_id','id');
	}

	protected $fillable = [
		'name',
		'siteid',
		'sellerid',
		'access_token',
		'refresh_token',
		'token_type',
		'expires_in',
		'is_valid',
		'automatic_sku_creation',
		'inventory_sync',
		'price_sync',
		'order_sync',
		'pricing_mark_up',
		'pricing_mark_up_type',
		'pricing_mark_up_value',
		'listing_quantity',
		'listing_quantity_value',
		'threshold_quantity',
		'threshold_quantity_value',
		'last_order_sync',
		'do_inventory_sync',
		'do_price_sync',
		'status',
		'profile_id',
		'store_id',
		'user_id',
		'import_products'
  	];
}
