<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;

class Notification extends Mailable
{
  use Queueable,SerializesModels;
  public $mailData;
  
  public function __construct($mailData){
		$this->mailData = $mailData;
  }

  public function build(){
    $subject = "Notification - Amazon Shopify App";
    $fromemail = "";
    if($this->mailData){
      if(isset($this->mailData["mail_subject"]) && $this->mailData["mail_subject"]) $subject = $this->mailData["mail_subject"];
      if(isset($this->mailData["fromemail"]) && $this->mailData["fromemail"]) $fromemail = $this->mailData["fromemail"];
    }
    
    if($fromemail){
      return $this->subject($subject)->from($fromemail)->markdown('emails.notification');
    }
    else{
      return $this->subject($subject)->markdown('emails.notification');
    }
  }
}
