<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Nicolaslopezj\Searchable\SearchableTrait;

class ShopifyOrder extends Model
{
	protected $table = 'shopify_orders';
	protected $connection = 'tenants';

	public function store(){
		return $this->belongsTo('App\ShopifyStore','store_id','id');
	}

  	public function user(){
		return $this->belongsTo('App\User','user_id','id');
	}

	protected $fillable = [
		'order_id','order_number','order_date_str','order_date','status','order_data','source','source_id','inventory_sync','store_id','user_id'
  	];
}
