<?php

namespace App;

use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;

class User extends Authenticatable
{
  use Notifiable;

  protected $connection = 'mysql';

  public function __construct(){
		$this->connection = config('config.default_connection');
	}

  public function stores(){
		return $this->hasMany('App\ShopifyStore','user_id','id');
  }
    
  public function shopifyStores(){
		return $this->hasMany('App\ShopifyStore','user_id','id');
  }

  public function notifications(){
		return $this->hasMany('App\Notification','user_id','id');
  }
    
  protected $fillable = [
    'name','email','password','status','type','api_token'
  ];

  protected $hidden = [
    'password','remember_token',
  ];

  protected $casts = [
    'email_verified_at' => 'datetime',
  ];
}
