<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateWebhookInputsTable extends Migration
{
    
    public function up()
    {
        if(!Schema::connection('tenants')->hasTable('webhook_inputs')){
            Schema::connection('tenants')->create('webhook_inputs',function(Blueprint $table){
                $table->bigIncrements('id');
                $table->text('webhook_input')->nullable()->default(NULL);
                $table->unsignedBigInteger('store_id');
                $table->foreign('store_id')->references('id')->on(config('config.default_database').'.shopify_stores')->onDelete('cascade');
                $table->timestamps();
            });
        }
    }

    
    public function down()
    {
        Schema::connection('tenants')->dropIfExists('webhook_inputs');
    }
}
