<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Schema;

class CreateListingVariantsTable extends Migration
{
    public function up(){
        if(!Schema::connection('tenants')->hasTable('listing_variants')){
            Schema::connection('tenants')->create('listing_variants',function(Blueprint $table){
                $table->bigIncrements('id');
                $table->string('title',500);
                $table->string('ebay_item_id');
                $table->string('sku');
                $table->string('custom_sku')->nullable()->default(NULL);
                $table->string('image',500)->nullable()->default(NULL);
                $table->unsignedBigInteger('variant_id')->nullable()->default(NULL);
                $table->longText('listing_variant_data')->nullable()->default(NULL);
                $table->longText('ebay_item_data')->nullable()->default(NULL);
                $table->longText('additional_data')->nullable()->default(NULL);
                $table->timestamp('last_inventory_synced_at')->nullable()->default(NULL);
                $table->integer('last_inventory_synced')->nullable()->default(NULL);
                $table->timestamp('last_pricing_synced_at')->nullable()->default(NULL);
                $table->double('last_price_synced')->nullable()->default(NULL);
                $table->timestamp('last_order_at')->nullable()->default(NULL);
                $table->string('last_order_id',255)->nullable()->default(NULL);
                $table->unsignedBigInteger('listing_id');
                $table->foreign('listing_id')->references('id')->on('listings')->onDelete('cascade');
                $table->unsignedInteger('account_id')->nullable()->default(NULL);
                $table->foreign('account_id')->references('id')->on(config('config.default_database').'.ebay_accounts')->onDelete('set null');
                $table->unsignedBigInteger('store_id');
                $table->foreign('store_id')->references('id')->on(config('config.default_database').'.shopify_stores')->onDelete('cascade');
                $table->unsignedBigInteger('user_id');
                $table->foreign('user_id')->references('id')->on(config('config.default_database').'.users')->onDelete('cascade');
                $table->timestamps();
            });
        }
    }
    
    public function down(){
        Schema::connection('tenants')->dropIfExists('listing_variants');
    }
}
