<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Schema;

class CreateEbayStoreCategoriesTable extends Migration
{
    
    public function up()
    {
        if(!Schema::connection('tenants')->hasTable('ebay_store_categories')){
            Schema::connection('tenants')->create('ebay_store_categories',function(Blueprint $table){
                $table->increments('id');
                $table->string('category_name');
                $table->text('category_tree_name');
                $table->boolean('is_last_level')->default(0);
                $table->string('ebay_category_id');
                $table->string('category_level');
                $table->integer('parent_category_id')->nullable()->default(NULL);
                $table->string('parent_category_name')->nullable()->default(NULL);
                $table->string('ebay_parent_category_id')->nullable()->default(NULL);
                $table->unsignedInteger('account_id')->nullable()->default(NULL);
                $table->foreign('account_id')->references('id')->on(config('config.default_database').'.ebay_accounts')->onDelete('set null');
                $table->unsignedBigInteger('store_id');
                $table->foreign('store_id')->references('id')->on(config('config.default_database').'.shopify_stores')->onDelete('cascade');
                $table->unsignedBigInteger('user_id');
                $table->foreign('user_id')->references('id')->on(config('config.default_database').'.users')->onDelete('cascade');
                $table->timestamps();
            });
        }
    }
    
    public function down()
    {
        Schema::connection('tenants')->dropIfExists('ebay_store_categories');
    }
}