import React, { useState, useCallback, useEffect } from "react";

import {
	Button,
	Checkbox,
	Card,
	FormLayout,
	Layout,
	Page,
	Select,
	SkeletonBodyText,
	Tabs,
	TextField,
	Banner,
	Icon,
	Label,
	Link,
	Toast, Popover, ActionList,
    Tooltip,
} from "@shopify/polaris";
import axios from "axios";
import { PlusMinor } from '@shopify/polaris-icons';
import AutoCompleteField from "./AutoCompleteField";
import { useHistory } from "react-router-dom/cjs/react-router-dom.min";

export default function AddProfileForm(props) {
	// console.log("props", props);
	const [errors, setErrors] = useState({});
	const [trimTitle, setTrimTitle] = useState(false);
	const [selectedTab, setSelectedTab] = useState(0);
	const [isDefaultProfile, setIsDefaultProfile] = useState("");
	const [name, setName] = useState("");
	const [conditions_true, setConditions_true] = useState(false)
	const [listingFormat, setListingFormat] = useState("");
	const [listingDuration, setListingDuration] = useState("");
	const [itemLocation, setItemLocation] = useState("");
	const [postalCode, setPostalCode] = useState("");
	const [templateId, setTemplateId] = useState("");
	const [paymentProfile_val, setPaymentProfile_val] = useState("")
	const [returnProfile_val, setReturnProfile_val] = useState("")
	const [conditionDescriptors, setConditionDescriptors] = useState([]);

	/******start category********/
	const [profileId, setProfileId] = useState(props.profile_id);
	const [profilename, setProfilename] = useState("");

	const [ebayCategories, setEbayCategories] = useState([]);
	const [selectedCategory, setSelectedCategory] = useState(null);
	const [selectedCategoryID, setSelectedCategoryID] = useState("");

	const [filteredCategories, setFilteredCategories] = useState([]);
	const [searchTerm, setSearchTerm] = useState();
	const [businesspolicy_refresh, set_businesspolicy_refresh] = useState(false);
	const [menuIsOpen, setMenuIsOpen] = useState(false);
	/******end category********/
	/******start sub category********/
	const [additionalCategoryData, setAdditionalCategoryData] = useState([]);
	const [selectedCustomdropdownValue, setSelectedCustomdropdownValue] = useState('');
	const [dropdownValues, setDropdownValues] = useState({});
	/******end sub category********/
	/******start ebayspecificdata ********/
	const [shippingProfile, setShippingProfile] = useState("");
	const [paymentProfile, setPaymentProfile] = useState("");
	const [returnProfile, setReturnProfile] = useState("");
	// State for selected profiles
	const [selectedShippingProfile, setSelectedShippingProfile] = useState("");
	const [selectedPaymentProfile, setSelectedPaymentProfile] = useState("");
	const [selectedReturnProfile, setSelectedReturnProfile] = useState("");
	const [product_id_type, setpProductidtype] = useState("");
	const [item_condition, setItemCondition] = useState("");
	const [selectedItemConditionName, setSelectedConditionName] = useState('');

	/******end ebayspecificdata ********/
	const [successMessage, setSuccessMessage] = useState(null);
	const [errorMessage, setErrorMessage] = useState(null);
	const [templateOptions, setTemplateOptions] = useState([]);
	const [ebayCategoryAttributes, setEbayCategoryAttributes] = useState();
	const [selectedOptions, setSelectedOptions] = useState([]);
	const [ebay_account, setEbayaccount] = useState(props.store_data.ebay_account);
	const [shopify_url, setShopify_url] = useState(props.store_data.shopify_url);
	const [categoryId, setCategory] = useState("");
	const [conidtion_fetched, setConidtion_fetched] = useState(false)
    const [conidtion_fetched2, setConidtion_fetched2] = useState(false)
	const [page_title, setpage_title] = useState("");
	const [subTitle, setSubTitle] = useState("");
	const [subDescription, setSubDescription] = useState("");
	const [selectedValues, setSelectedValues] = useState({});
	const [paymentProfiles, setPaymentProfiles] = useState([]);
    const [shipping_profiles, setShipping_profiles] = useState([]);
    const [returnProfiles, setReturnProfiles] = useState([]);
    const [actionActive, toggleAction] = useState(false);
	const [actionActive2, toggleAction2] = useState(false);
	const [actionActive3, toggleAction3] = useState(false);
	const [isFieldHidden, setIsFieldHidden] = useState(false);
	const [selectedDescriptorValues, setSelectedDescriptorValues] = useState({});

	console.log('errors', errors.name);
	
	
	const hideToast = () => {
		setSuccessMessage(null);
		setErrorMessage(null);
	};
	
	const [conditions, setConditionOptions] = useState([]);
    const [selectedCondition, setSelectedCondition] = useState(null);

	const tabs = [
		{
			id: "required",
			content: "Step 1",
			accessibilityLabel: "Required Fields",
			panelID: "required-fields",
		},
		{
			id: "category",
			content: "Step 2",
			accessibilityLabel: "Category Fields",
			panelID: "category-fields",
		},
	];
    const customdropdownoptions = [
        { value: 'option1', label: 'Set eBay Recommendation' },
        { value: 'option2', label: 'Set Custom Value' },
    ];

	const yesNoOptions = [
		{ label: "Select a Option", value: "" },
		{ value: "1", label: "Yes" },
		{ value: "0", label: "No" },
	];

	const listingFormats = [
		{ label: "Select a Option", value: "" },
		{ value: "fixed_price", label: "Fixed Price" },
		{ value: "auction", label: "Auction" },
	];

	const fixedListingDuration = [
		{ label: "Select a Option", value: "" },
		{ value: "Days_14", label: "Days_14" },
		{ value: "Days_21", label: "Days_21" },
		{ value: "Days_30", label: "Days_30" },
		{ value: "Days_60", label: "Days_60" },
		{ value: "Days_90", label: "Days_90" },
		{ value: "Days_120", label: "Days_120" },
		{ value: "GTC", label: "GTC" },
	];

	const auctionListingDuration = [
		{ label: "Select a Option", value: "" },
		{ value: "Days_1", label: "Days_1" },
		{ value: "Days_3", label: "Days_3" },
		{ value: "Days_5", label: "Days_5" },
		{ value: "Days_7", label: "Days_7" },
		{ value: "Days_10", label: "Days_10" },
	];

	const product_id_type_options = [
		{ label: "Select a Option", value: "" },
		{ value: "UPC", label: "UPC" },
		{ value: "ISBN", label: "ISBN" },
		{ value: "EAN", label: "EAN" },
		{ value: "MPN", label: "MPN" },
	];

	const handleTabChange = useCallback(
		(selectedTabIndex) => setSelectedTab(selectedTabIndex),
		[]
	);
	const handleChangeDefaultProfile = useCallback(
		(value) => setIsDefaultProfile(value),
		[]
	);
	const handleChangeProfileName = useCallback((value) => setName(value), []);
	const handleChangeListingFormat = useCallback(
		(value) => setListingFormat(value),
		[]
	);
	const handleChangeListingDuration = useCallback(
		(value) => setListingDuration(value),
		[]
	);
	const handleChangeItemLocation = useCallback(
		(value) => setItemLocation(value),
		[]
	);
	const handleChangePostalCode = useCallback(
		(value) => setPostalCode(value),
		[]
	);
	const handleChangeTemplateOption = useCallback(
		(value) => setTemplateId(value),
		[]
	);
	const handleChangeProductType = useCallback(
		(value) => setpProductidtype(value),
		[]
	);
	const handleChangeConditionOption = useCallback(
		(value) => setItemCondition(value),
		[]
	);
	const getListingDurationOptions = () => {
		if (listingFormat === "auction") {
			return auctionListingDuration;
		} else if (listingFormat === "fixed_price") {
			return fixedListingDuration;
		} else {
			return [{ label: "Select a Option", value: "" }];
		}
	};
	const handleDescriptorValueChange = (descriptorId, descriptorName, selectedValueId, selectedValueName) => {
        setSelectedDescriptorValues(prevState => ({
            ...prevState,
            [descriptorId]: { id: selectedValueId, name: selectedValueName }
        }));

        // console.log('3333333333333333',     selectedDescriptorValues );
    };
	const validateForm = () => {
		let errors = {};

		if (!name) errors.name = "Profile Name is required";
		if (isDefaultProfile === "")
			errors.isDefaultProfile = "Default Profile is required";
		if (!listingFormat) errors.listingFormat = "Listing Format is required";
		if (!listingDuration)
			errors.listingDuration = "Listing Duration is required";
		if (!itemLocation) errors.itemLocation = "Item Location is required";
		if (!postalCode) errors.postalCode = "Postal Code is required";
		// if (!templateId) errors.templateId = "Description Template is required";

		setErrors(errors);

		return Object.keys(errors).length === 0;
	};

	useEffect(() => {
		set_businesspolicy_refresh(true)
		//fetchBusinessPolicies()

		
		const apiUrl = `${props.api_url}/ebayspecificdata?shopify_url=${props.store_data.shopify_url}&api_token=${props.store_data.user.api_token}`;
		fetch(apiUrl)
			.then((res) => res.json())
			.then((data) => {
			//	console.log("ebayyy",data);
				if (data.shipping_profiles.length != 0) {
					var ckey;
					
					var ship = [
						{ label: "Select Shipping", value: "" },
					];

					for (ckey in data.shipping_profiles) {
						ship.push({
							label: data.shipping_profiles[ckey].name,
							value: data.shipping_profiles[
								ckey
							].id.toString(),
						});
					}
					setShipping_profiles(ship)

					//console.log(shipping_profiles);
				} else {

					var ship = [
						{
							label: "Please add Shipping policy to your eBay account",
							value: "",
						},
					];
					setShipping_profiles(ship)
				}

				if (data.payment_profiles.length != 0) {


					var pay = [
						{ label: "Select Payment", value: "" },
					];

					for (ckey in data.payment_profiles) {
						pay.push({
							label: data.payment_profiles[ckey].name,
							value: data.payment_profiles[
								ckey
							].id.toString(),
						});
					}
					setPaymentProfiles(pay)


				} else {

					var pay = [
						{
							label: "Please add Payment policy to your eBay account",
							value: "",
						},
					];
					setPaymentProfiles(pay)
				}

				if (data.return_profiles.length != 0) {

					var ret = [
						{ label: "Select Return", value: "" },
					];

					for (ckey in data.return_profiles) {
						ret.push({
							label: data.return_profiles[ckey].name,
							value: data.return_profiles[ckey].id.toString(),
						});
					}
					setReturnProfiles(ret)
				} else {
					var ret = [
						{
							label: "Please add Return policy to your eBay account",
							value: "",
						},
					];
					setReturnProfiles(ret)
				}

				set_businesspolicy_refresh(false)
			})





		fetch(
			`${props.api_url}/templates?shopify_url=${props.store_data.shopify_url}&api_token=${props.store_data.user.api_token}`
		)
			.then((res) => res.json())
			.then((data) => {
				if (data && data.total > 0) {
					const options = data.data.map((template) => ({
						label: template.name,
						value: template.id.toString(),
					}));
					setTemplateOptions((prevOptions) => [
						...prevOptions,
						...options,
					]);
				}
			})
			.catch(console.log);
	}, [
		props.api_url,
		props.store_data.shopify_url,
		props.store_data.user.api_token,
	]);
	// start category function
	useEffect(() => {
		const fetchData = async () => {
			try {
				const response = await axios.get(
					`${props.service_url}/public/category-json/categories_${ebay_account.siteid}.json`
				);
				const data = response.data;
				setEbayCategories(data);
				setFilteredCategories(data);
				setSuccessMessage(data.msg);
			} catch (error) {
				console.log(error);
			}
		};

		fetchData();
	}, [props.service_url, ebay_account.siteid]);

	const handleSearchChange = (value) => {
		setIsFieldHidden(false);
		setConditions_true(false);
		setSearchTerm(value);
		filterCategories(value);
		setMenuIsOpen(value.length > 0); // Open the dropdown if search input is not empty
	};
	const filterCategories = (inputValue) => {
		const filtered = ebayCategories.filter((category) =>
			category.category_tree_name
				.toLowerCase()
				.includes(inputValue.toLowerCase())
		);
		setFilteredCategories(filtered);
	};


	const handleCategoryClick = async (category) => {
		setConidtion_fetched(true)
        setConidtion_fetched2(true)
		setSelectedCategory(category);
		setSearchTerm(category.category_tree_name);
		setMenuIsOpen(false); // Close the dropdown upon selection
		setSelectedCategoryID(category.id);
		// Construct the URL with query parameters
		const apiUrl = `${props.api_url}/ebaycategory?category_id=${category.id}&shopify_url=${props.store_data.shopify_url}&api_token=${props.store_data.user.api_token}`;
		// Make the API call
		try {
			const response = await axios.get(apiUrl);
			let category_attributes = response.data.category_attributes;
			setAdditionalCategoryData(category_attributes);

			const item_condition_data = response.data.item_condition_data;
			const getItemConditionData = item_condition_data;
			setConditionOptions([
                getItemConditionData // Add fetched options
            ]);
			if(response.data.category_attributes){
                setIsFieldHidden(true);
                setConidtion_fetched2(false)
             }
            if (response.data.item_condition_data) {
                setConidtion_fetched(false)
                setConditions_true(true)

            }

			// Initialize selectedValues with the first value of each attribute
			let initialSelectedValues = {};
			category_attributes.forEach(attr => {
				if (attr.values.length > 0) {
					initialSelectedValues[attr.name] = attr.values[0];
				}
			});
			setSelectedValues(initialSelectedValues);

			setSuccessMessage(response.msg);
		} catch (error) {
			console.error("Error calling the API:", error);
		}
	};
	const handleChangeCustomdropdown = (value) => {
        setSelectedCustomdropdownValue(value);
        console.log(`Option selected:`, value);
    };
	const handleCustomDropdownChange = (attributeName, value) => {
        // alert(value);
        setDropdownValues((prevValues) => ({
            ...prevValues,
            [attributeName]: value,
        }));
        handleChangeCustomdropdown(value);
    };

	// end category function
	const handleShippingProfileChange = (value) => {
		setSelectedShippingProfile(value);
	};
	const handlePaymentProfileChange = (value) => {
		setPaymentProfile_val(value);
	};
	const handleReturnProfileChange = (value) => {
		setReturnProfile_val(value);
	};
	const history = useHistory();
	// console.log("ebayCategoryID", ebayCategoryID);
	// end ebay specification data
	const handleFormSubmitFirstStep = async () => {
		if (!validateForm()) {
			return;
		}
	
		const formData = {
			name: name,
			trim_title: trimTitle,
			is_default_profile: isDefaultProfile,
			listing_format: listingFormat,
			listing_duration: listingDuration,
			item_location: itemLocation,
			postal_code: postalCode,
			template_id: templateId,
			product_id_type: product_id_type,
			update_install_step: false,
			shopify_url: shopify_url,
		};
	
		try {
			const fetch_url = `${props.api_url}/profile?api_token=${props.store_data.user.api_token}`;
			const response = await fetch(fetch_url, {
				method: "POST",
				headers: { "Content-Type": "application/json" },
				body: JSON.stringify(formData),
			});
	
		//	console.log('Response:', response);
	
			// if (!response.ok) {
			// 	const errorData = await response.json();
			// 	throw new Error(errorData.error || "Failed to save profile data");
			// }

			if (!response.ok) {
				const errorData = await response.json();
				if (errorData.errors) {
					// Assuming errorData.errors is an object with field-specific error messages
					const fieldErrors = {};
					Object.keys(errorData.errors).forEach((field) => {
						fieldErrors[field] = errorData.errors[field][0];
					});
					setErrors(fieldErrors);
					return;
				} else {
					throw new Error("Failed to save profile data");
				}
			}
	
			const data = await response.json();
			//setSuccessMessage(data.msg);
			const profileId = data.profile.id;
			const profilename = data.profile.name;
			setProfileId(profileId);
			setProfilename(profilename);
	
			const nextTab = selectedTab + 1;
			if (nextTab < tabs.length) {
				setSelectedTab(nextTab);
			}
	
		} catch (error) {
			console.error('Error:', error);
			setSuccessMessage(error.message);
		}
	};
	
	const handleSecondStep = async () => {
		// if (!searchTerm) errors.searchTerm = "category is required";

		let formIsValid = true;
		let errors = {};

		if (!searchTerm) {
			formIsValid = false;
			errors.searchTerm = "Category is required";
		}
		const ebayCategoryAttributesJSON = JSON.stringify(
			ebayCategoryAttributes
		);
		
		const ebayCategory = selectedCategoryID || categoryId;
		if(selectedShippingProfile == "" || paymentProfile_val == "" || returnProfile_val == ""){
			setErrorMessage("Please select business policies")
			return
		}

		if(ebayCategory == ""){
			setErrorMessage("Please select category ")
			return
		}

		const formData = {
			profile_id: profileId,
			name: name,
			shipping_profile: selectedShippingProfile,
			payment_profile: paymentProfile_val,
			return_profile: returnProfile_val,
			ebay_category_1: ebayCategory,
			// item_specifics: ebayCategoryAttributes,
			item_specifics: selectedValues,
			item_condition: selectedCondition,
			update_install_step: false,
			shopify_url: shopify_url,
		};
		//console.log("formdata ",formData);

		const fetch_url = `${props.api_url}/profile/${profileId}?api_token=${props.store_data.user.api_token}`;
		try {
			const response = await fetch(fetch_url, {
				method: "PUT",
				headers: {
					"Content-Type": "application/json",
				},
				body: JSON.stringify(formData),
			});

			// if (!response.ok) {
			// 	throw new Error("Failed to save profile data in step 2");
			// }

			if (!response.ok) {
				const errorData = await response.json();
				if (errorData.errors) {
					// Assuming errorData.errors is an object with field-specific error messages
					const fieldErrors = {};
					Object.keys(errorData.errors).forEach((field) => {
						fieldErrors[field] = errorData.errors[field][0];
					});
					setErrors(fieldErrors);
					return;
				} else {
					throw new Error("Failed to save profile data");
				}
			}

			const data = await response.json();
			setSuccessMessage(data.msg);
			// alert("Profile saved successfully");
			// console.log("Response Data:", data);

			// Move to the next tab
			const nextTab = selectedTab + 1;
			if (nextTab < tabs.length) {
				setSelectedTab(nextTab);
			}
			setTimeout(() => {
				history.push("/cp/profiles");
			}, 2000);
			
		} catch (error) {
			console.error(error);
		}
	};
	
	const handlePrevious = () => {
		const prevTab = selectedTab - 1;
		if (prevTab >= 0) {
			setSelectedTab(prevTab);
		}
	};

	const handleSelectionChange = (selectedOption, index) => {
		const updatedSelectedOptions = [...selectedOptions];
		updatedSelectedOptions[index] = selectedOption;
		setSelectedOptions(updatedSelectedOptions);
		//console.log("Selected option value:", selectedOption);

		// Send all dropdown values with their names
		sendAllDropdownValues(updatedSelectedOptions);
	};

	const sendAllDropdownValues = (options) => {
		const dropdownValues = options.map((option, index) => ({
			name: additionalCategoryData[index].name,
			value: option,
		}));

		// Do whatever you need to do with all dropdown values
		//console.log("All dropdown values:", dropdownValues);
		setEbayCategoryAttributes(dropdownValues);
	};

	const handleValueChange = (attributeName, newValue) => {
		setSelectedValues(prevState => ({
			...prevState,
			[attributeName]: newValue
		}));
	};

	// const handleChange = (event) => {  
    //     setSelectedCondition(event.target.value);
	// }
	const handleChange = async (event) => {
        // alert(event.target.value);
        const selectedConditionId = event.target.value;
        setSelectedCondition(selectedConditionId);
        // Find the selected condition by ID
        const selectedCondition = conditions[0].find(condition => condition.conditionId === selectedConditionId);
        // alert(1);
        // If the selected condition is found
        if (selectedCondition) {
            // Set both the ID and the name
            //  console.log("Condition found for name:", selectedCondition.conditionDescription);
            setSelectedConditionName(selectedCondition.conditionDescription);
        } else {
            //console.log("Condition not found for ID:", selectedConditionId);
        }

        const ebayCategory = selectedCategoryID || categoryId;
        const apiUrl = `${props.api_url}/ebaycategory?category_id=${ebayCategory}&conditionId=${event.target.value}&shopify_url=${props.store_data.shopify_url}&api_token=${props.store_data.user.api_token}`;
        try {
            const response = await axios.get(apiUrl);
            if(response.data.conditionDescriptors){
                const conditionDescriptors = response.data.conditionDescriptors; // Assuming conditionDescriptors is a property in the response data
                setConditionDescriptors(conditionDescriptors);
            }
            
        } catch (error) {
            console.error("Error calling the API:", error);
        }
    };

	const [popoverActive, setPopoverActive] = useState(true);

    const togglePopoverActive = useCallback(
        () => setPopoverActive((popoverActive) => !popoverActive),
        [],
    );
    const activator = (
    <Button onClick={togglePopoverActive} disclosure>
      +
    </Button>
    );
    const fetchBusinessPolicies = () => {


		var hasError = false;
		//console.log("entered in the fetch business ()");
		//var fetch_profile_text = this.state.fetch_profile_text;
		var fetch_profile_text = "Fetch Business Policies";
		if (fetch_profile_text === "Fetch Business Policies") {
			// this.setState(() => {
			// 	return {
			// 		fetch_profile_text: "Fetching...",
			// 	};
			// });
			if (hasError === false) {
				// this.setState({ button_loading: true });
			}

			var fetch_url =
				props.api_url +
				"/fetch_profiles?shopify_url=" +
				props.store_data.shopify_url +
				"&api_token=" +
				props.store_data.user.api_token;
			var requestOptions = {
				method: "GET",
				headers: { "Content-Type": "application/json" },
			};
			fetch(fetch_url, requestOptions)
				.then((response) => response.json())
				.then((data) => {
				//	console.log("here is the policy ", data)

					if (data.shipping_profiles.length != 0) {


						var ship = [
							{ label: "Select Shipping", value: "" },
						];

						for (ckey in data.shipping_profiles) {
							ship.push({
								label: data.shipping_profiles[ckey].name,
								value: data.shipping_profiles[
									ckey
								].id.toString(),
							});
						}
						setShipping_profiles(ship)

					//	console.log(shipping_profiles);
					} else {

						var ship = [
							{
								label: "Please add Shipping policy to your eBay account",
								value: "",
							},
						];
						setShipping_profiles(ship)
					}

					if (data.payment_profiles.length != 0) {


						var pay = [
							{ label: "Select Payment", value: "" },
						];

						for (ckey in data.payment_profiles) {
							pay.push({
								label: data.payment_profiles[ckey].name,
								value: data.payment_profiles[
									ckey
								].id.toString(),
							});
						}
						setPaymentProfiles(pay)


					} else {

						var pay = [
							{
								label: "Please add Payment policy to your eBay account",
								value: "",
							},
						];
						setPaymentProfiles(pay)
					}

					if (data.return_profiles.length != 0) {

						var ret = [
							{ label: "Select Return", value: "" },
						];

						for (ckey in data.return_profiles) {
							ret.push({
								label: data.return_profiles[ckey].name,
								value: data.return_profiles[ckey].id.toString(),
							});
						}
						setReturnProfiles(ret)
					} else {
						var ret = [
							{
								label: "Please add Return policy to your eBay account",
								value: "",
							},
						];
						setReturnProfiles(ret)
					}

					set_businesspolicy_refresh(false)
					return
					setTimeout(function () {
					}, 5000);					
					var ckey;
					if (data.shipping_profiles.length != 0) {
						this.state.shipping_status = false;
						this.state.symbol_policy = true;
						var shipping_profiles = [
							{ label: "Select a Shipping Profile", value: "" },
						];
						for (ckey in data.shipping_profiles) {
							shipping_profiles.push({
								label: data.shipping_profiles[ckey].name,
								value: data.shipping_profiles[
									ckey
								].id.toString(),
							});
						}
					} else {

						var shipping_profiles = [
							{
								label: "Please add Shipping policiy to your eBay account",
								value: "",
							},
						];
					}
					if (data.payment_profiles.length != 0) {
						this.state.payment_status = false;
						// console.log(data.payment_profiles);
						this.state.symbol_policy = true;
						var payment_profiles = [
							{ label: "Select a Payment Profile", value: "" },
						];
						// payment_profiles = payment_profiles.slice(1);
						for (ckey in data.payment_profiles) {
							payment_profiles.push({
								label: data.payment_profiles[ckey].name,
								value: data.payment_profiles[
									ckey
								].id.toString(),
							});
						}
					} else {
						var payment_profiles = [
							{
								label: "Please add Payment policiy to your eBay account",
								value: "",
							},
						];
					}
					if (data.return_profiles.length != 0) {
						this.state.return_status = false;
						// console.log(data.return_profiles);
						this.state.symbol_policy = true;
						var return_profiles = [
							{ label: "Select a Return Profile", value: "" },
						];
						// return_profiles = return_profiles.slice(1);
						for (ckey in data.return_profiles) {
							return_profiles.push({
								label: data.return_profiles[ckey].name,
								value: data.return_profiles[ckey].id.toString(),
							});
						}
					} else {
						var return_profiles = [
							{
								label: "Please add Return policiy to your eBay account",
								value: "",
							},
						];
					}
					this.setState({
						button_loading: false,
						success_message: null,
					});
					this.setState(() => {
						return {
							shipping_profiles: shipping_profiles,
							// shipping_profiles_msg:shipping_profiles_msg,
							payment_profiles: payment_profiles,
							// payment_profiles_msg:payment_profiles_msg,
							return_profiles: return_profiles,
							// return_profiles_msg:return_profiles_msg,
						};
					});
				})
				.catch((error) => {
					//console.error(error);
				});
		} else {
			console.log("here is not the policy ")
		}
	};
	const fetchBusinessPolicies1 = (num) => {

	//	console.log("num -> ", num);
		if (num == 1) {
			handleToggle()
		} else if (num == 2) {
			handleToggle2()
		} else if (num == 3) {
			handleToggle3()
		}



		var hasError = false;
		var fetch_profile_text = "Fetch Business Policies";
		if (fetch_profile_text === "Fetch Business Policies") {

			if (hasError === false) {

			}

			var fetch_url =
				props.api_url +
				"/fetch_profiles?shopify_url=" +
				props.store_data.shopify_url +
				"&api_token=" +
				props.store_data.user.api_token;
			var requestOptions = {
				method: "GET",
				headers: { "Content-Type": "application/json" },
			};
			fetch(fetch_url, requestOptions)
				.then((response) => response.json())
				.then((data) => {
				//	console.log("here is the policy ", data)
					var ckey;
					if (data.shipping_profiles.length != 0) {

						var ship = [];

						for (ckey in data.shipping_profiles) {
							ship.push({
								label: data.shipping_profiles[ckey].name,
								value: data.shipping_profiles[
									ckey
								].id.toString(),
							});
						}
						setShipping_profiles(ship)

						//console.log(shipping_profiles);
					} else {

						var ship = [
							{
								label: "Please add Shipping policy to your eBay account",
								value: "",
							},
						];
						setShipping_profiles(ship)
					}

					if (data.payment_profiles.length != 0) {


						var pay = [];

						for (ckey in data.payment_profiles) {
							pay.push({
								label: data.payment_profiles[ckey].name,
								value: data.payment_profiles[
									ckey
								].id.toString(),
							});
						}
						setPaymentProfiles(pay)


					} else {

						var pay = [
							{
								label: "Please add Payment policy to your eBay account",
								value: "",
							},
						];
						setPaymentProfiles(pay)
					}

					if (data.return_profiles.length != 0) {

						var ret = [];

						for (ckey in data.return_profiles) {
							ret.push({
								label: data.return_profiles[ckey].name,
								value: data.return_profiles[ckey].id.toString(),
							});
						}
						setReturnProfiles(ret)
					} else {
						var ret = [
							{
								label: "Please add Return policy to your eBay account",
								value: "",
							},
						];
						setReturnProfiles(ret)
					}

					set_businesspolicy_refresh(false)

					return


				})
				.catch((error) => {
					//console.error(error);
				});
		} else {
			console.log("here is not the policy ")
		}
	};

	const handleExportedAction = useCallback(

		() => {
			set_businesspolicy_refresh(true)
			fetchBusinessPolicies1(1)
		},
		[]
	);
	const handleExportedAction2 = useCallback(
		() => {
			set_businesspolicy_refresh(true)
			fetchBusinessPolicies1(2)

		},
		[]
	);
	const handleExportedAction3 = useCallback(
		() => {
			set_businesspolicy_refresh(true)
			fetchBusinessPolicies1(3)
		},
		[]
    );
    const handleImportedAction = useCallback(() => {
		handleToggle()
		window.open(
			"https://www.bizpolicy.ebay.com/businesspolicy/shipping?pageNumber=1&totalPages=1&source=manage",
			"_blank"
		);

	}, []);

	const handleImportedAction2 = useCallback(() => {
		handleToggle2()
		window.open(
			"https://www.bizpolicy.ebay.com/businesspolicy/payment?pageNumber=1&totalPages=1&source=manage",
			"_blank"
		);

    }, []);
    
    const handleImportedAction3 = useCallback(() => {
		handleToggle3()
		window.open(
			"https://www.ebay.com/bp/rtn/create",
			"_blank"
		);

    }, []);
    
    const handleToggleAction = () => {

		toggleAction(!actionActive);
	};
	const handleToggleAction2 = () => {

		toggleAction2(!actionActive2);
	};
	const handleToggleAction3 = () => {

		toggleAction3(!actionActive3);
	};

	const handleToggle = () => {
		toggleAction(false);
	};
	const handleToggle2 = () => {
		toggleAction2(false);
	};
	const handleToggle3 = () => {
		toggleAction3(false);
	};

    const disclosureButtonActivator = (
		<Button icon={PlusMinor} onClick={handleToggleAction}>

		</Button>
	);
	const disclosureButtonActivator2 = (
		<Button icon={PlusMinor} onClick={handleToggleAction2}>

		</Button>
	);
	const disclosureButtonActivator3 = (
		<Button icon={PlusMinor} onClick={handleToggleAction3}>

		</Button>
	);

	return (
		<Page title={page_title}>
			<Layout>
				<Layout.AnnotatedSection
					title={subTitle}
					description={subDescription}
				>
					<Card sectioned>
						<Tabs
							tabs={tabs}
							selected={selectedTab}
							onSelect={handleTabChange}
						>
							<Card.Section>
								<form
									onSubmit={handleFormSubmitFirstStep}
									method="post"
									encType="multipart/form-data"
								// preventDefault="true"
								>
									{selectedTab === 0 && (
										<FormLayout>
											<Checkbox
												label="Trim Title"
												checked={trimTitle}
												onChange={() =>
													setTrimTitle(!trimTitle)
												}
												error={errors.trimTitle}
											/>
											<Select
												label="Default Profile ?"
												options={yesNoOptions}
												onChange={
													handleChangeDefaultProfile
												}
												value={isDefaultProfile}
												error={errors.isDefaultProfile}
											/>
											<TextField
												type="text"
												label="Profile Name"
												value={name}
												onChange={
													handleChangeProfileName
												}
												error={errors.name}
											/>
											<Select
												label="Listing Format"
												options={listingFormats}
												onChange={
													handleChangeListingFormat
												}
												value={listingFormat}
												error={errors.listingFormat}
											/>
											{listingFormat && (
												<Select
													label="Listing Duration"
													options={getListingDurationOptions()}
													onChange={
														handleChangeListingDuration
													}
													value={listingDuration}
													error={
														errors.listingDuration
													}
												/>
											)}
											<TextField
												type="text"
												label="Item Location"
												value={itemLocation}
												onChange={
													handleChangeItemLocation
												}
												error={errors.itemLocation}
											/>
											<TextField
												type="text"
												label="Postal Code"
												value={postalCode}
												onChange={
													handleChangePostalCode
												}
												error={errors.postalCode}
											/>
											<Select
												label="Description Template"
												options={templateOptions}
												onChange={
													handleChangeTemplateOption
												}
												value={templateId}
												error={errors.templateId}
											/>

											<Select
												label="Product ID Type"
												options={
													product_id_type_options
												}
												onChange={
													handleChangeProductType
												}
												value={product_id_type}
											/>
										</FormLayout>
									)}
									 {selectedTab === 1 && (
                                            <FormLayout>
                                                <div className="dropdown-container">

												{businesspolicy_refresh ?
                                                    <Card sectioned roundedAbove="sm">
                                                        <div>
                                                            <label className="category-lable">Fetching Business Policies...</label>
                                                            <SkeletonBodyText lines={10} />

                                                        </div>
                                                    </Card>
                                                    :
                                                    <Card sectioned roundedAbove="sm">
                                                        <div
                                                            style={{
                                                               
                                                                display: "flex",
                                                                alignItems: "center",

                                                            }}
                                                        >
                                                            <div style={{ width: "100%" }}>
                                                                <Select
                                                                    label="Shipping Profile"
                                                                    options={shipping_profiles}
                                                                    onChange={handleShippingProfileChange}
                                                                    value={selectedShippingProfile}

                                                                />

                                                            </div>
                                                            <div style={{ padding: "24px 0px 0px 10px" }}>


                                                                <Popover
                                                                    active={actionActive}
                                                                    activator={disclosureButtonActivator}
                                                                    onClose={handleToggleAction}
                                                                    autofocusTarget="first-node"
                                                                >
                                                                    <ActionList actionRole="menuitem"
                                                                        items={[
                                                                            {
                                                                                content: 'Create',
                                                                                onAction: handleImportedAction,
                                                                            },
                                                                            {
                                                                                content: 'Refresh',
                                                                                onAction: handleExportedAction,
                                                                            },
                                                                        ]} />
                                                                </Popover>

                                                            </div>
                                                        </div>
                                                        <div
                                                            style={{
                                                              
                                                                display: "flex",
                                                                alignItems: "center",

                                                            }}
                                                        >
                                                            <div style={{ width: "100%" }}>

                                                                <Select
                                                                    label="Payment Profile"
                                                                    options={paymentProfiles}
                                                                    onChange={handlePaymentProfileChange}
                                                                    value={paymentProfile_val}
                                                                />
                                                            </div>

                                                            <div style={{ padding: "24px 0px 0px 10px" }}>
                                                                <Popover

                                                                    active={actionActive2}
                                                                    activator={disclosureButtonActivator2}
                                                                    onClose={handleToggleAction2}
                                                                    autofocusTarget="first-node"
                                                                >
                                                                    <ActionList actionRole="menuitem"
                                                                        items={[
                                                                            {
                                                                                content: 'Create',
                                                                                onAction: handleImportedAction2,
                                                                            },
                                                                            {
                                                                                content: 'Refresh',
                                                                                onAction: handleExportedAction2,
                                                                            },
                                                                        ]} />
                                                                </Popover>
                                                            </div>


                                                        </div>
                                                        <div
                                                            style={{
                                                               
                                                                display: "flex",
                                                                alignItems: "center",

                                                            }}
                                                        >
                                                            <div style={{ width: "100%" }}>
                                                                <Select
                                                                    label="Return Profile"
                                                                    options={returnProfiles}
                                                                    onChange={handleReturnProfileChange}
                                                                    value={returnProfile_val}
                                                                />
                                                            </div>
                                                            <div style={{ padding: "24px 0px 0px 10px" }}>
                                                                <Popover
                                                                    active={actionActive3}
                                                                    activator={disclosureButtonActivator3}
                                                                    onClose={handleToggleAction3}
                                                                    autofocusTarget="first-node"
                                                                >
                                                                    <ActionList actionRole="menuitem"
                                                                        items={[
                                                                            {
                                                                                content: 'Create',
                                                                                onAction: handleImportedAction3,
                                                                            },
                                                                            {
                                                                                content: 'Refresh',
                                                                                onAction: handleExportedAction3,
                                                                            },
                                                                        ]} />
                                                                </Popover>
                                                            </div>

                                                        </div>
                                                    </Card>
                                                 }

                                                    <div style={{
                                                        width: "100%",

                                                        padding: "40px 0px 10px"
                                                    }}>



                                                        <Card sectioned >
                                                            <div> 
															<TextField
                                                                    label="Select Category"
                                                                    value={searchTerm}
                                                                    onChange={
                                                                        handleSearchChange
                                                                    }
                                                                    placeholder="Search category..."
                                                                    autoComplete="off"
                                                                    error={errors.searchTerm}
                                                                />
                                                                {menuIsOpen &&
                                                                    filteredCategories.length >
                                                                    0 && (
                                                                        <ul className="dropdown-menu">
                                                                            {filteredCategories.map(
                                                                                (category) => (
                                                                                    <li
                                                                                        key={
                                                                                            category.id
                                                                                        }
                                                                                        onClick={() =>
                                                                                            handleCategoryClick(
                                                                                                category
                                                                                            )
                                                                                        }
                                                                                        className="dropdown-item"
                                                                                    >
                                                                                        {
                                                                                            category.category_tree_name
                                                                                        }
                                                                                    </li>
                                                                                )
                                                                            )}
                                                                        </ul>
                                                                    )}{ }





                                                            </div>
                                                        </Card>

														{isFieldHidden && (
                                                            <div style={{
                                                                width: "100%",

                                                                padding: "40px 0px 10px"
                                                            }}>

                                                                <Card sectioned roundedAbove="sm">
                                                                    <div
                                                                      
                                                                    >
                                                                        <span>
                                                                            <div className="subcategory-dropdown custom-polaris-select">


                                                                                {/* {additionalCategoryData.map(attribute => (
                                                                                    <div key={attribute.name} className="Polaris-Select">
                                                                                        <label className="category-lable">{attribute.name}</label>
                                                                                        <select
                                                                                            value={selectedValues[attribute.name] || ''}
                                                                                            onChange={(e) => handleValueChange(attribute.name, e.target.value)}
                                                                                            className="selected-cat"
                                                                                        >
                                                                                            {attribute.values.map(value => (
                                                                                                <option  key={value} value={value}>
                                                                                                    {value}
                                                                                                </option>
                                                                                            ))}
                                                                                        </select>
                                                                                    </div>
                                                                                ))} */}
																				{Array.isArray(additionalCategoryData) && additionalCategoryData.length > 0 ? (
                                                                            additionalCategoryData.map(attribute => (
                                                                                <div key={attribute.name} className="Polaris-Select">
                                                                                    <label className="category-label">{attribute.name}</label>
                                                                                    <select 
                                                                                        id="customdropdown"
                                                                                        className="selected-cat"
                                                                                        onChange={(e) => handleCustomDropdownChange(attribute.name, e.target.value)}
                                                                                        value={dropdownValues[attribute.name] || ''} // Ensure dropdownValues[attribute.name] is defined
                                                                                    >
                                                                                        {customdropdownoptions.map(option => (
                                                                                            <option key={option.value} value={option.value}>
                                                                                                {option.label}
                                                                                            </option>
                                                                                        ))}
                                                                                    </select>
                                                                                    <br></br>
                                                                                    
                                                                                    
                                                                                    {dropdownValues[attribute.name] === 'option2' ? (
                                                                                        <div>
                                                                                        <input
                                                                                            type="text"
                                                                                            value={selectedValues[attribute.name] || ''}
                                                                                            onChange={(e) => handleValueChange(attribute.name, e.target.value)}
                                                                                            className="selected-cat"
																							// placeholder={!selectedValues[attribute.name] ? "":"please insert a value"}
                                                                                            required
                                                                                            
                                                                                        />
                                                                                        <br></br>
                                                                                        <br></br>
                                                                                        </div>
                                                                                    ) : (
                                                                                        <div>
                                                                                        <select
                                                                                            value={selectedValues[attribute.name] || ''}
                                                                                            onChange={(e) => handleValueChange(attribute.name, e.target.value)}
                                                                                            className="selected-cat"
                                                                                            required
                                                                                        >
                                                                                            <option value="" disabled>{attribute.values.length > 0 ? "Select an option" : "No eBay Recommendation" }</option>
                                                                                            {Array.isArray(attribute.values) && attribute.values.map(value => (
                                                                                                <option key={value} value={value}>
                                                                                                    {value}
                                                                                                </option>
                                                                                            ))}
                                                                                        </select>
                                                                                        <br></br>
                                                                                        <br></br>
                                                                                        </div>
                                                                                    )}
                                                                                </div>
                                                                            ))
                                                                        ) : (
                                                                            <div>No additional category data available</div>
                                                                        )}
                                                                            </div>
                                                                        </span>

                                                                    </div>
                                                                </Card>


                                                            </div>
                                                        )}
                                                        {conidtion_fetched2 && (
                                                            <div style={{
                                                                width: "100%",

                                                                padding: "40px 0px 10px"
                                                            }}>



                                                                <Card sectioned roundedAbove="sm">
                                                                    <div
                                                                      
                                                                    >
                                                                        <label className="category-lable">Loading...</label>
                                                                        <SkeletonBodyText />

                                                                    </div>
                                                                </Card>

                                                            </div>
                                                        )}
                                                        <br></br>



                                                        {conditions_true && (
                                                            <div style={{
                                                                width: "100%",

                                                            }}>

                                                                {/* <Card sectioned roundedAbove="sm">
                                                                    <div
                                                                      
                                                                    >
                                                                        <label className="category-lable">Select Condition:</label>
                                                                        <select className="selected-cat" value={selectedCondition} onChange={handleChange}>
                                                                            {conditions.length > 0 && conditions[0].map(condition => (
                                                                                <option key={condition.conditionId} value={condition.conditionId}>
                                                                                    {condition.conditionDescription}
                                                                                </option>
                                                                            ))}
                                                                        </select>
                                                                    </div>
                                                                </Card> */}

<Card sectioned roundedAbove="sm">
                                                                            <div className="subcategory-dropdown custom-polaris-select">

                                                                                <div>
                                                                                    <label className="category-lable">Select Condition</label>
                                                                                    <select id='selected-cat' className="selected-cat" value={selectedCondition} onChange={handleChange}>
                                                                                        <option value="" disabled selected>{conditions.length === 0 ? "Loading..." : "Select an option"}</option>
                                                                                        {conditions.length > 0 && conditions[0].map(condition => (
                                                                                            <option key={condition.conditionId} value={condition.conditionId}>
                                                                                                {condition.conditionDescription}
                                                                                            </option>
                                                                                        ))}
                                                                                    </select>

                                                                                    <div>
                                                                                        <div>
                                                                                            {conditionDescriptors.map(descriptor => {
                                                                                                // Check if the descriptor has values
                                                                                                const hasValues = descriptor.conditionDescriptorValues && descriptor.conditionDescriptorValues.length > 0;
                                                                                                return hasValues ? (
                                                                                                    <div key={descriptor.conditionDescriptorId}>
                                                                                                        <label className="category-label">{descriptor.conditionDescriptorName}</label>
                                                                                                        <select
                                                                                                            className="selected-cat"
                                                                                                            id={`selected-descriptor-value-${descriptor.conditionDescriptorId}`}
                                                                                                            value={selectedDescriptorValues[descriptor.conditionDescriptorId]?.id || ""}
                                                                                                            onChange={(e) => {
                                                                                                                const selectedValueId = e.target.value;
                                                                                                                const selectedValueName = e.target.options[e.target.selectedIndex].text;
                                                                                                                handleDescriptorValueChange(descriptor.conditionDescriptorId, descriptor.conditionDescriptorName, selectedValueId, selectedValueName);
                                                                                                            }}
                                                                                                        >
                                                                                                            <option value="" disabled hidden>
                                                                                                                {selectedDescriptorValues[descriptor.conditionDescriptorId] ? '' : `Select ${descriptor.conditionDescriptorName} Value`}
                                                                                                            </option>
                                                                                                            {descriptor.conditionDescriptorValues.map(value => (
                                                                                                                <option key={value.conditionDescriptorValueId} value={value.conditionDescriptorValueId}>
                                                                                                                    {value.conditionDescriptorValueName}
                                                                                                                </option>
                                                                                                            ))}
                                                                                                        </select>
                                                                                                    </div>
                                                                                                ) : null;
                                                                                            })}
                                                                                        </div>
                                                                                    </div>

                                                                                </div>
                                                                            </div>
                                                                        </Card>

                                                            </div>
                                                        )}

                                                        {conidtion_fetched && (
                                                            <div style={{
                                                                width: "100%",

                                                                padding: "40px 0px 10px"
                                                            }}>



                                                                <Card sectioned roundedAbove="sm">
                                                                    <div
                                                                       
                                                                    >
                                                                        <label className="category-lable">Loading...</label>
                                                                        <SkeletonBodyText />

                                                                    </div>
                                                                </Card>

                                                            </div>
                                                        )}


                                                    </div>
                                                </div>
                                            </FormLayout>
                                        )}
									
									{/* <button type="submit">Submit</button> */}
								</form>
							</Card.Section>
						</Tabs>
						<div
							style={{
								display: "flex",
								justifyContent: "space-between",
								marginTop: "20px",
							}}
						>
							{selectedTab == 0 && (
								<>
									<Button primary onClick={handleFormSubmitFirstStep}>
										Next
									</Button>
								</>
							)}

							{selectedTab == 1 && (
								<>
									<Button primary onClick={handlePrevious}>
										Previous
									</Button>
									<Button
										primary
										id="secondStepNextButton"
										onClick={() =>
											handleSecondStep(profileId)
										}
									>
										Next
									</Button>
								</>
							)}
							{selectedTab == 2 && (
								<>

								</>
							)}
						</div>
					</Card>
				</Layout.AnnotatedSection>
			</Layout>
			<>
				{successMessage && (
					<Toast
						content={successMessage}
						onDismiss={hideToast}
						duration="2000"
					/>
				)}
				{errorMessage && (
					<Toast
						content={errorMessage}
						error
						onDismiss={hideToast}
						duration="2000"
					/>
				)}
			</>
		</Page>
	);
}
