import React, {Component} from 'react';

import {Layout} from '@shopify/polaris';
import './Bootstrap.css';

class AppIntro extends Component
{
  state = {
    install_shopify_url:""
  };

  constructor(props){
    super(props);
    console.log(props);
  }

  _isMounted = false

  componentDidMount() {
    this._isMounted = true;
    document.title = 'Install App - ' + document.title;
  }

  render(){
    return(
      <React.Fragment>
        <nav className="navbar navbar-expand-lg navbar-dark bg-dark fixed-top">
          <div className="container">
            <a className="navbar-brand" href="#">ECOMSHORE - Integration With eBay</a>
            <button className="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarResponsive" aria-controls="navbarResponsive" aria-expanded="false" aria-label="Toggle navigation">
              <span className="navbar-toggler-icon"></span>
            </button>
            <div className="collapse navbar-collapse" id="navbarResponsive">
              <ul className="navbar-nav ml-auto">
                <li className="nav-item active">
                  <a className="nav-link" href="mailto:support@ecomshore.com">Support Email: <u>support@ecomshore.com</u></a>
                </li>
              </ul>
            </div>
          </div>
        </nav>

        <div className="container">
          <header className="jumbotron my-4">
            <h1 className="display-4 text-center">ECOMSHORE - Integration With eBay</h1>
            <p className="lead">This APP can be used to import/sync products from your Shopify store to your eBay Seller account in just a few clicks. This will save you lots of time in manually adding products.</p>
            <p>&nbsp;</p>
            <form action="" method="post">
              <div className="row text-center">
                <div className="col-sm-3 text-right" style={{"paddingTop":"5px"}}><strong>Enter your store's URL:</strong></div>
                <div className="col-sm-6">
                  <input type="text" className="form-control" placeholder="your-store-url.myshopify.com" id="shop" required
                    value={this.state.install_shopify_url}
                    onChange={(e) => { this.setState(() => { return {install_shopify_url:e.value} }) }}
                  />
                </div>
                <div className="col-sm-3"></div>
              </div>
              <div className="row text-center" style={{"paddingTop":"10px"}}>
                <div className="col-sm-3"></div>
                <div className="col-sm-6 text-right">
                  <input type="button" name="install" className="btn btn-primary btn-lg" value="Install Now" 
                    onClick={() => { if(this.state.install_shopify_url === ""){alert('Please Enter Shopify Store URL'); return false;} alert(this.state.install_shopify_url); window.location.href = `${this.props.app_domain}/shopify-apps/${this.props.sub_folder}/service/shopifyinstall?test_install=1&shop=${this.state.install_shopify_url}`;}}
                  />
                </div>
                <div className="col-sm-3"></div>
              </div>
            </form>
          </header>
          
          <div className="row text-center">
            <div className="col-lg-3 col-md-6 mb-4">
              <div className="card">
                <div className="card-body">
                  <h4 className="card-title">Bulk Listings</h4><p>Import products from your Shopify store to your eBay seller account in just few clicks.</p>
                </div>
              </div>
            </div>
            <div className="col-lg-3 col-md-6 mb-4">
              <div className="card">
                <div className="card-body">
                  <h4 className="card-title">Real-time Syncing</h4><p>Synchronize all your product details like Title, Inventory, Price, and Order details to sell on eBay in real-time.</p>
                </div>
              </div>
            </div>
                <div className="col-lg-3 col-md-6 mb-4">
              <div className="card">
                <div className="card-body">
                  <h4 className="card-title">Business Policies</h4><p>The app supports managing your business policies by creating, fetching & updating their old policies.</p>
                </div>
              </div>
            </div>
            <div className="col-lg-3 col-md-6 mb-4">
              <div className="card">
                <div className="card-body">
                  <h4 className="card-title">Import Orders</h4><p>Import all eBay orders to your Shopify store automatically. It will help you to manage the order fulfillment easily.</p>
                </div>
              </div>
            </div>
          </div>
          
        </div>

        <footer className="py-5 bg-dark">
          <div className="container">
            <p className="m-0 text-center text-white">Copyright &copy; 2022 InfoShore Software Private Limited. All right reserved.</p>
          </div>
        </footer>

      </React.Fragment>
    );
  }
}

export default AppIntro;