import React, { Component } from 'react';

import {Button, Card, Form, FormLayout, Layout, Page, Stack, DataTable, FooterHelp, Link, Toast} from '@shopify/polaris';
import $ from 'jquery';

class AttributeMappingForm extends Component{
  _isMounted = false;

  state = {
    button_loading:false,
    mapping_data: {},
    categories:[],
    mapping_rows: [],
    profile:{}
  };

  errors_data = {};

  constructor(props){
    super(props);
    this.handleChange = this.handleChange.bind(this);
    this.updateAttributeMapping = this.updateAttributeMapping.bind(this);
    this.hideToast = this.hideToast.bind(this);
  }

  componentWillUnmount(){
    this._isMounted = false;
  }

  componentDidMount(){
    this._isMounted = true;
    this.setState({page_title: "Update Profile Attribute Mappings"});
    fetch(this.props.api_url+'/amazonspecificdata')
    .then(res => res.json())
    .then((data) => {
      if(data && data.categories){
        var categories = data.categories;
        this.setState({ categories: data.categories},function(){
          fetch(this.props.api_url+'/profile/'+this.props.profile_id+'/attributemapping?shopify_url='+this.props.store_data.shopify_url+'&api_token='+this.props.store_data.user.api_token)
          .then(res => res.json())
          .then((data) => {
            if(data && data.id){
              var profile = data;
              var mapping_rows = [];

              for(var ckey in categories){
                if(categories[ckey].id === profile.category_id){
                  var field,fkey;
                  
                  if(profile.category_fields_data && profile.category_fields_data["VariationTheme"]){
                    for(fkey in categories[ckey].fields){
                      field = categories[ckey].fields[fkey];
                      if(field.name === "Parentage" || field.name === "VariationTheme") continue;
                      mapping_rows.push([
                        <p><b>{field.name}</b></p>,
                        <div>
                          <div className="Polaris-Connected">
                            <div className="Polaris-Connected__Item Polaris-Connected__Item--primary">
                              <div className="Polaris-TextField">
                                <input name={field.name} key={"attrf_"+field.name} id={field.name} placeholder="Enter Related Shopify Option Name" className="Polaris-TextField__Input" type="text" aria-labelledby="AmperageLabel" aria-invalid="false" aria-multiline="false" onChange={this.handleChange(field.name)} />
                                <div className="Polaris-TextField__Backdrop"></div>
                              </div>
                            </div>
                          </div>
                        </div>
                        //<TextField type="text" label="Enter Related Shopify Option Name" value={this.state.mapping_data[field.name] ? this.state.mapping_data[field.name] : ''} onChange={this.handleChange(field.name)} />
                      ]);
                    }
                  }
                  else if(profile.product_type_fields_data && profile.product_type && profile.product_type_fields_data["VariationTheme"] && categories[ckey].product_type_fields[profile.product_type]){
                    for(fkey in categories[ckey].product_type_fields[profile.product_type]){
                      field = categories[ckey].product_type_fields[profile.product_type][fkey];
                      if(field.name === "Parentage" || field.name === "VariationTheme") continue;
                      mapping_rows.push([
                        <b>{field.name}</b>,
                        <div>
                          <div className="Polaris-Connected">
                            <div className="Polaris-Connected__Item Polaris-Connected__Item--primary">
                              <div className="Polaris-TextField">
                                <input name={field.name} id={field.name} placeholder="Enter Related Shopify Option Name" className="Polaris-TextField__Input" type="text" aria-labelledby="AmperageLabel" aria-invalid="false" aria-multiline="false" onChange={this.handleChange(field.name)} />
                                <div className="Polaris-TextField__Backdrop"></div>
                              </div>
                            </div>
                          </div>
                        </div>
                      ]);
                      /*
                      <input id={field.name} key={field.name} type="text" label="Enter Related Shopify Option Name" onChange={this.handleChange(field.name)} />
                      */
                    }
                  }
                  break;
                }
              }

              var mapping_data = {};
              if(profile.attribute_mapping && profile.attribute_mapping.length > 0){
                for(var akey in profile.attribute_mapping){
                  mapping_data[profile.attribute_mapping[akey].attribute_name] = profile.attribute_mapping[akey].option_name;
                }
              }

              this.setState({mapping_rows:mapping_rows,profile:profile,mapping_data:mapping_data},function(){
                if(profile.attribute_mapping && profile.attribute_mapping.length > 0){
                  for(var akey in profile.attribute_mapping){
                    $("#"+profile.attribute_mapping[akey].attribute_name).val(profile.attribute_mapping[akey].option_name);
                  }
                }
              });
            }
          })
          .catch(console.log);
        });
      }
    })
    .catch(console.log);
  }

  hideToast(){
    this.setState({success_message: null,error_message: null});
  }

  updateAttributeMapping(){
    var hasError = false;
    if(!this.state.mapping_data){
      hasError = true;
      this.errors_data.name_error = "update mapping data";
    }

    if(hasError === false){
      this.setState({button_loading:true});
      
      var request_data = {
        mapping_data: this.state.mapping_data,
        shopify_url:this.props.store_data.shopify_url
      };

      var requestOptions = {
        method: 'POST',
        headers: {'Content-Type': 'application/json'},
        body: JSON.stringify(request_data)
      };
      var fetch_url = this.props.api_url+'/profile/'+this.props.profile_id+'/attributemapping?api_token='+this.props.store_data.user.api_token;
      
      fetch(fetch_url,requestOptions)
      .then(response => response.json())
      .then((data) => {
        if(data && data.status && data.status === "success"){
          if(this._isMounted){
            this.setState({button_loading:false,success_message:data.msg});
          }
        }
        else{
          var error_message = "there was something wrong, please try again.";
          if(data && data.status && data.status === "error"){
            if(data.errors){
              for(var key in data.errors){
                error_message += key + " : ";
                for(var fkey in data.errors[key]){error_message += data.errors[key][fkey] + "\n";}
                error_message += "\n";
              }
            }
            else if(data.msg){error_message = data.msg;}
          }
        }
        if(this._isMounted){
          this.setState({button_loading:false,error_message:error_message});
        }
      })
      .catch(error => {
        console.error(error);
      });
    }
    else{
      this.setState({button_loading:false});
    }
  } 

  handleChange = (field) => {
    return (value) => {
      var mapping_data = this.state.mapping_data;
      mapping_data[field] = value.target.value;
      //mapping_data[field] = value;
      this.setState({ mapping_data: mapping_data });
      //console.log(mapping_data);
    }
  };
  
  render(){
    return (
      <Page title={this.state.page_title}>
        <Layout>
          
          <Layout.Section>
            {this.state.success_message &&
              <Toast content={this.state.success_message} onDismiss={this.hideToast} duration="6000" />
            }
            {this.state.error_message &&
              <Toast content={this.state.error_message} error onDismiss={this.hideToast} duration="6000" />
            }
          </Layout.Section>

          <Layout.Section title="Update Profile Attribute Mappings">
            <Card sectioned>
              {this.state.mapping_rows.length === 0 &&
                <p>
                  No Mapping Data available
                </p>
              }
              {this.state.mapping_rows.length > 0 &&
              <Form onSubmit={this.updateAttributeMapping} method="post" encType="multipart/form-data" preventDefault="true">
                <FormLayout>

                  <DataTable
                    columnContentTypes={['text','text']}
                    headings={['Attribute Name','Option Name']}
                    rows={this.state.mapping_rows}
                    truncate="true"
                    verticalAlign="middle"
                    hideScrollIndicator="true"
                  />
                  
                  <Stack distribution="trailing">
                    <Button primary submit loading={this.state.button_loading}>Update</Button>
                  </Stack>
                </FormLayout>
              </Form>
              }
            </Card>
          </Layout.Section>

          <Layout.Section>
            <FooterHelp>
              For more details on Polaris, visit our{' '}
              <Link url="https://www.google.com" external="true">documentation</Link>.
            </FooterHelp>
          </Layout.Section>
        </Layout>
      </Page>
    );
  }
}


export default AttributeMappingForm;