import React, {useCallback, useState} from 'react';
import {Icon, Autocomplete} from '@shopify/polaris';
import {SearchMinor} from '@shopify/polaris-icons';

export default function AutoCompleteField(props){
  const deselectedOptions = props.options || [];
  const [selectedOptions, setSelectedOptions] = useState(props.selected);
  const [inputValue, setInputValue] = useState(props.inputValue);
  const [options, setOptions] = useState(deselectedOptions);
  const [loading, setLoading] = useState(false);

  const updateText = useCallback(
    (value) => {
        setInputValue(value);
        if(!loading){setLoading(true);}

        if(value && value.length >= 3){
            props.searchOptions(value).then(soptions => {
                if(soptions && soptions.length > 0){
                    setOptions(soptions);
                }
                else{
                    setOptions([]);
                }

                
                setTimeout(() => {
                    if(value === ''){
                        setOptions(deselectedOptions);
                        setLoading(true);
                        return;
                    }
                    const filterRegex = new RegExp(value, 'i');
                    const resultOptions = options.filter((option) =>
                        option.label.match(filterRegex),
                    );
                    //setOptions(resultOptions);
                    setLoading(false);
                    window.scrollBy(0, 2);
                }, 300);
            })
            .catch(console.log);
        }
        else{
            setOptions(props.options);
            setTimeout(() => {
                if(value === ''){
                    setOptions(deselectedOptions);
                    setLoading(true);
                    return;
                }
                const filterRegex = new RegExp(value, 'i');
                const resultOptions = options.filter((option) =>
                    option.label.match(filterRegex),
                );
                setOptions(resultOptions);
                setLoading(false);
            }, 300);
        }
    },
    [deselectedOptions, options, loading],
  );

  const updateSelection = useCallback(
    (selected) => {
      const selectedText = selected.map((selectedItem) => {
        const matchedOption = options.find((option) => {
          return option.value.match(selectedItem);
        });
        return matchedOption && matchedOption.label;
      });
      
      setSelectedOptions(selected);
      setInputValue(selectedText[0]);

      props.handleAutoCompleteFieldChange(props.field_name,selected[0]);
    },
    [options],
  );

  const textField = (
    <Autocomplete.TextField
      onChange={updateText}
      label={props.label}
      value={inputValue}
      prefix={<Icon source={SearchMinor} color="base" />}
      placeholder={props.placeholder}
      error={props.error}
    />
  );

  return (
    <Autocomplete
        options={options}
        selected={selectedOptions}
        onSelect={updateSelection}
        loading={loading}
        textField={textField}
        id={props.field_name}
    />
  );
}