import React, {useCallback, useState} from 'react';
import {Button, TextContainer, Modal} from '@shopify/polaris';

export default function DataModal(props) {
  const [active, setActive] = useState(props.active);
  const handleChange = useCallback(() => {
    setActive(!active);
   
    props.hideModel();
  });
  const activator = <Button onClick={handleChange}>Open</Button>;

  return (
    <div style={{height: '500px'}}>
      <Modal
        aactivator={activator}
        open={active}
        onClose={handleChange}
        title={props.title}
        secondaryActions={[
          {
            content: 'Close',
            onAction: handleChange,
          },
        ]}
      >
        <Modal.Section>
          <TextContainer>
            <div dangerouslySetInnerHTML={{ __html: props.content }} />
          </TextContainer>
        </Modal.Section>
      </Modal>
    </div>
  );
}