import React, { Component } from 'react';

import {
  Button,
  Card,
  Form,
  FormLayout,
  Layout,
  Page,
  Stack,
  TextField,
  Select,
  FooterHelp,
  Link,
  Checkbox,
  Banner,
} from '@shopify/polaris';
import Setup1 from './Setup1';

class EbayAccountForm extends Component{
  _isMounted = false;

  state = {
    name: "Ebay",
    siteid: "0",
    import_products: false
  };
  
  errors_data = {};

  componentWillUnmount(){
    this._isMounted = false;
  }

  componentDidMount(){
    this._isMounted = true;
  }

  ebaySiteList = [
    {value:'0', label:'eBay United States'},
    {value:'2', label:'eBay Canada (English)'},
    {value:'3', label:'eBay UK'},
    {value:'15', label:'eBay Australia'},
    {value:'16', label:'eBay Austria'},
    {value:'23', label:'eBay Belgium (French)'},
    {value:'71', label:'eBay France'},
    {value:'77', label:'eBay Germany'},
    {value:'100', label:'eBay Motors'},
    {value:'101', label:'eBay Italy'},
    {value:'123', label:'eBay Belgium (Dutch)'},
    {value:'146', label:'eBay Netherlands'},
    {value:'186', label:'eBay Spain'},
    {value:'193', label:'eBay Switzerland'},
    {value:'201', label:'eBay Hong Kong'},
    {value:'203', label:'eBay India'},
    {value:'205', label:'eBay Ireland'},
    {value:'207', label:'eBay Malaysia'},
    {value:'210', label:'eBay Canada (French)'},
    {value:'211', label:'eBay Philippines'},
    {value:'212', label:'eBay Poland'},
    {value:'216', label:'eBay Singapore'}
  ];

  constructor(props){
    super(props);
    this.handleChange = this.handleChange.bind(this);
    this.addEbayAccount = this.addEbayAccount.bind(this);

    /*
    if(window.location.search){
      var urlParams = new URLSearchParams(window.location.search);
      if(urlParams.has('amazon_callback_uri') && urlParams.has('amazon_state')){

        this.state.button_loading = true;
        
        var request_data = {
          amazon_callback_uri: urlParams.get('amazon_callback_uri'),
          amazon_state: urlParams.get('amazon_state'),
          version: urlParams.get('version'),
          merchant_id: urlParams.get('selling_partner_id'),
          shopify_url:this.props.store_data.shopify_url
        };

        const requestOptions = {
          method: 'POST',
          headers: {'Content-Type': 'application/json'},
          body: JSON.stringify(request_data)
        };
        fetch(this.props.api_url+'/amazonappinstall?api_token='+this.props.store_data.user.api_token,requestOptions)
        .then(response => response.json())
        .then((data) => {
          if(data && data.status && data.status === "success"){
            window.location.href = data.auth_link;
            return null;
          }
          else{
            var error_message = "there was something wrong, please try again.";
            if(data && data.status && data.status === "error"){
              if(data.errors){
                for(var key in data.errors){
                  error_message += key + " : ";
                  for(var fkey in data.errors[key]){
                    error_message += data.errors[key][fkey] + "\n";
                  }
                  error_message += "\n";
                }
              }
              else if(data.msg){
                error_message = data.msg;
              }
            }
          }
  
          if(this._isMounted){
            this.setState({
              button_loading:false,
              error_message:error_message
            });
          }
          
        })
        .catch(error => {
          console.error(error);
        });

      }
      
    }
    */

  }

  addEbayAccount(){
    this.setState({
      button_loading:true,
      name: this.state.name,
      siteid: this.state.siteid,
      import_products: this.state.import_products,
      error_message:null
    });

    var hasError = false;
    if(this.state.name.length <= 0){
      hasError = true;
      this.errors_data.name_error = "name is required";
    }
    
    if(this.state.siteid.length <= 0){
      hasError = true;
      this.errors_data.siteid_error = "ebay site is required";
    }

    if(hasError === false){
      var request_data = {
        name: this.state.name,
        siteid: this.state.siteid,
        import_products: this.state.import_products,
        update_install_step: false,
        shopify_url:this.props.store_data.shopify_url
      };

      const requestOptions = {
        method: 'POST',
        headers: {'Content-Type': 'application/json'},
        body: JSON.stringify(request_data)
      };
      fetch(this.props.api_url+'/ebay_account?api_token='+this.props.store_data.user.api_token,requestOptions)
      .then(response => response.json())
      .then((data) => {
        if(data && data.status && data.status === "success"){
          window.location.href = data.install_link;
          //return null;
         this.props.updateInstallStep(3);
        }
        else{
          var error_message = "there was something wrong, please try again.";
          if(data && data.status && data.status === "error"){
            if(data.errors){
              for(var key in data.errors){
                error_message += key + " : ";
                for(var fkey in data.errors[key]){
                  error_message += data.errors[key][fkey] + "\n";
                }
                error_message += "\n";
              }
            }
            else if(data.msg){
              error_message = data.msg;
            }
          }
        }

        if(this._isMounted){
          this.setState({
            button_loading:false,
            error_message:error_message
          });
        }
        
      })
      .catch(error => {
        console.error(error);
      });
    }
    else{
      this.setState({
        button_loading:false
      });
    }
  }

  handleChange = (field) => {
    return (value) => {
      if(value.length <= 0 && field !== "import_products"){
        this.errors_data[field+"_error"] = field.replace("_"," ") + " is required";
      }
      else{
        this.errors_data[field+"_error"] = null;
      }
      this.setState({ [field]: value });
    }
  };

  render(){
    return (
     <>
     hjkhk
     </>
    );
  }
}

export default EbayAccountForm;