import React, { useState, useCallback } from 'react';
import {
    Button,
    Checkbox,
    Card,
    FormLayout,
    SkeletonBodyText,
    Layout,
    Page,
    Select,
    Tabs,
    TextField,
    Banner,
    Icon,
    Label,
    Link,
    Toast, Popover, ActionList,
    Tooltip
} from '@shopify/polaris'; // Assuming you're using Polaris for UI components
import { useEffect } from 'react';
import axios from 'axios';
import { useHistory } from "react-router-dom/cjs/react-router-dom.min";
import { PlusMinor } from '@shopify/polaris-icons';

export default function EditProfileForm(props) {
    const [errors, setErrors] = useState({});
    const [errorMessage, setErrorMessage] = useState(null);
    const [successMessage, setSuccessMessage] = useState(null);
    const [pageTitle, setpage_title] = useState("");
    const [subTitle, setSubTitle] = useState("");
    const [subDescription, setSubDescription] = useState("");
    const [profileId, setProfileId] = useState(props.profile_id);
    const [selectedTab, setSelectedTab] = useState(0);
    const [childConditionExit, setChildConditionExit] = useState(false);
    
    const [trimTitle, setTrimTitle] = useState(false);
    const [isDefaultProfile, setIsDefaultProfile] = useState('');
    const [conditions_true, setConditions_true] = useState(false)
    const [conidtion_fetched, setConidtion_fetched] = useState(false)
    const [conidtion_fetched2, setConidtion_fetched2] = useState(false)
    const [conidtion_fetched3, setConidtion_fetched3] = useState(false)
    const [name, setName] = useState('');
    const [paymentProfile_val, setPaymentProfile_val] = useState("")
    const [returnProfile_val, setReturnProfile_val] = useState("")
    const [listingFormat, setListingFormat] = useState('');
    const [listingDuration, setListingDuration] = useState('');
    const [itemLocation, setItemLocation] = useState('');
    const [postalCode, setPostalCode] = useState('');
    const [templateId, setTemplateId] = useState('');
    const [searchTerm, setSearchTerm] = useState('');
    const [businesspolicy_refresh, set_businesspolicy_refresh] = useState(false);
    const [menuIsOpen, setMenuIsOpen] = useState(false);
    const [filteredCategories, setFilteredCategories] = useState([]);
    const [additionalCategoryData, setAdditionalCategoryData] = useState([]);
    const [itemConditionArr, setItemConditionArr] = useState([]);
    const [dBItemcondition, setDBItemcondition] = useState(false);

    const [selectedOptions, setSelectedOptions] = useState([]);
    const [selectedOption, setSelectedOption] = useState([]);
    const [shippingProfile, setShippingProfile] = useState('');
    const [paymentProfile, setPaymentProfile] = useState('');
    const [returnProfile, setReturnProfile] = useState('');
    const [productIDType, setProductIDType] = useState('');
    const [item_condition, setItemCondition] = useState('');
    const [childItemCondition, setChildItemCondition] = useState('');
    const [profilename, setProfilename] = useState("");
    const [ebayCategoryAttributes, setEbayCategoryAttributes] = useState();
    const [selectedCategoryID, setSelectedCategoryID] = useState("");
    const [ebayCategoryID, setEbayCategoryID] = useState();
    const [categoryId, setCategory] = useState("");
    const [product_id_type, setpProductidtype] = useState("");
    const [searchTermedit, setSearchTermedit] = useState("");
    const [itemSpecifics, setItemSpecifics] = useState([]);
    const [subCategoryEdit, setSubCategoryEdit] = useState([]);
    const [templateOptions, setTemplateOptions] = useState([]);
    const [selectedShippingProfile, setSelectedShippingProfile] = useState("");
    const [selectedReturnProfile, setSelectedReturnProfile] = useState("");
    const [selectedPaymentProfile, setSelectedPaymentProfile] = useState("");
    const [selectedCategory, setSelectedCategory] = useState(null);
    const [ebay_account, setEbayaccount] = useState(props.store_data.ebay_account);
    const [shopify_url, setShopify_url] = useState(props.store_data.shopify_url);
    const [ebayCategories, setEbayCategories] = useState([]);
    const [options, setOptions] = useState([]);
    const [isFieldHidden, setIsFieldHidden] = useState(true);
    const [conditions, setConditionOptions] = useState([]);
    const [selectedCondition, setSelectedCondition] = useState(null);
    const [selectedCondition2, setSelectedCondition2] = useState(null);
    const [category_fetched, setCategory_fetched] = useState(false);
    const [selectedOptionnew, setSelectedOptionnew] = useState('');
    const [paymentProfiles, setPaymentProfiles] = useState([]);
    const [shipping_profiles, setShipping_profiles] = useState([]);
    const [returnProfiles, setReturnProfiles] = useState([]);
    const [actionActive, toggleAction] = useState(false);
    const [actionActive2, toggleAction2] = useState(false);
    const [actionActive3, toggleAction3] = useState(false);
    const [conditionDescriptors, setConditionDescriptors] = useState([]);
    const [selectedDescriptor, setSelectedDescriptor] = useState('');
    const [descriptorValues, setDescriptorValues] = useState([]);
    const [selectedDescriptorValue, setSelectedDescriptorValue] = useState('');
    const [descriptor, setDescriptor] = useState('');
    const [descriptorValue, setDescriptorValue] = useState('');
    const [selectedDescriptorName, setSelectedDescriptorName] = useState('');
    const [selectedDescriptorValueName, setSelectedDescriptorValueName] = useState({});
    const [selectedItemConditionName, setSelectedConditionName] = useState('');


    const history = useHistory();

    useEffect(() => {
        set_businesspolicy_refresh(true)
        if (props.form_type === "edit_profile") {
            setpage_title("Update Profile");
            setSubTitle("Edit Ebay Profile");
            setSubDescription("Enter profile data and click on Save");

            const apiUrl = `${props.api_url}/ebayspecificdata?shopify_url=${props.store_data.shopify_url}&api_token=${props.store_data.user.api_token}`;
            fetch(apiUrl)
                .then((res) => res.json())
                .then((data) => {
                 //   console.log("ebayyy", data);
                    if (data.shipping_profiles.length != 0) {
                        var ckey;
                        var ship = [];

                        for (ckey in data.shipping_profiles) {
                            ship.push({
                                label: data.shipping_profiles[ckey].name,
                                value: data.shipping_profiles[
                                    ckey
                                ].id.toString(),
                            });
                        }
                        setShipping_profiles(ship)

                        // console.log(shipping_profiles);
                    } else {

                        var ship = [
                            {
                                label: "Please add Shipping policy to your eBay account",
                                value: "",
                            },
                        ];
                        setShipping_profiles(ship)
                    }

                    if (data.payment_profiles.length != 0) {

                        var pay = [];

                        for (ckey in data.payment_profiles) {
                            pay.push({
                                label: data.payment_profiles[ckey].name,
                                value: data.payment_profiles[
                                    ckey
                                ].id.toString(),
                            });
                        }
                        setPaymentProfiles(pay)


                    } else {

                        var pay = [
                            {
                                label: "Please add Payment policy to your eBay account",
                                value: "",
                            },
                        ];
                        setPaymentProfiles(pay)
                    }

                    if (data.return_profiles.length != 0) {

                        var ret = [];

                        for (ckey in data.return_profiles) {
                            ret.push({
                                label: data.return_profiles[ckey].name,
                                value: data.return_profiles[ckey].id.toString(),
                            });
                        }
                        setReturnProfiles(ret)
                    } else {
                        var ret = [
                            {
                                label: "Please add Return policy to your eBay account",
                                value: "",
                            },
                        ];
                        setReturnProfiles(ret)
                    }

                    set_businesspolicy_refresh(false)
                })




            var ebcat;
            const fetchData = async () => {
                try {
                    const response = await axios.get(
                        `${props.api_url}/profile/${props.profile_id}?shopify_url=${props.store_data.shopify_url}&api_token=${props.store_data.user.api_token}`
                    );
                    const data = response.data;
                 //   console.log("hello", data);
                    // step 1
                    setTrimTitle(data.trim_title === 1);
                    setIsDefaultProfile(data.is_default_profile.toString());
                    setName(data.name);
                    setListingFormat(data.listing_format);
                    setListingDuration(data.listing_duration);
                    setItemLocation(data.item_location);
                    setPostalCode(data.postal_code);
                    setTemplateId(data.template_id);
                    setpProductidtype(data.product_id_type);
                    // step 2
                    setSearchTermedit(data.ebay_category_1.category_tree_name);
                    setSearchTerm(data.ebay_category_1.category_tree_name || "");

                    setEbayCategoryID(data.ebay_category_1.id || "");
                    setAdditionalCategoryData(data.item_specifics);
                    // console.log("qqqqqqqqqqqqqq", data.item_specifics);
                    setSelectedValues(data.item_specifics);
                    if (data.item_condition) {
                        const data11 = JSON.parse(data.item_condition);

                        // console.log("valueeee",data11["value"]);
                        // console.log("valueeee",data11.value);
                        setSelectedCondition(data11.value)
                    }
                    var ebcat = data.ebay_category_1.id;
                    const json_item_condition = data.item_condition;

                    if (json_item_condition) {
                        // JSON string ko object me convert karen
                        const parsedData = JSON.parse(json_item_condition);
                        // selected_condition_name aur selected_condition_id ko extract karen
                        const selected_condition_name = parsedData.name;
                        const selected_condition_id = parsedData.value;
                        setItemCondition(selected_condition_name);
                    }

                    setSelectedShippingProfile(data.shipping_profile.toString() || "");
                    setPaymentProfile_val(data.payment_profile.toString() || "");
                    setReturnProfile_val(data.return_profile.toString() || "");
                    if (data.child_item_condition) {
                        const jsonChildItemCondition = data.child_item_condition;
                        const parsedData = JSON.parse(jsonChildItemCondition);
                        setChildItemCondition(parsedData[0]);
                        setChildConditionExit(true)
                    }
                    setConditions_true(true)
                    const categoryId = data.ebay_category_1.id;
                    setCategory(categoryId);


                } catch (error) {
                    console.error(
                        "There was an error fetching the profile:",
                        error
                    );
                }

                const apiUrl = `${props.api_url}/ebaycategory?category_id=${ebcat}&shopify_url=${props.store_data.shopify_url}&api_token=${props.store_data.user.api_token}`;
                fetch(apiUrl)

                    .then((res) => res.json())
                    .then((data) => {
                     //   console.log('ebayspecificdata', data);
                        setAdditionalCategoryData(data.category_attributes)

                        setCategory_fetched(true);
                        if (data.item_condition_data) {
                            setItemConditionArr(data.item_condition_data)
                            setDBItemcondition(true)
                        }
                    })
                    .catch(console.log);
            };
            fetchData();
        } else if (props.form_type === "app_setup") {
            setpage_title("App Setup - Step 3 of 4");
            setSubTitle("Add Ebay Profile");
            setSubDescription("Enter profile data and click on Save.");
        }
    }, [
        props.form_type,
        props.api_url,
        props.profile_id,
        props.store_data.user.api_token,
        props.store_data.shopify_url,
    ]);

    const hideToast = () => {
        setSuccessMessage(null);
        setErrorMessage(null);
    };
    const tabs = [
        {
            id: "required",
            content: "Step 1",
            accessibilityLabel: "Required Fields",
            panelID: "required-fields",
        },
        {
            id: "category",
            content: "Step 2",
            accessibilityLabel: "Category Fields",
            panelID: "category-fields",
        }
    ];
    const yesNoOptions = [
        { label: "Select a Option", value: "" },
        { value: "1", label: "Yes" },
        { value: "0", label: "No" },
    ];
    const listingFormats = [
        { label: "Select a Option", value: "" },
        { value: "fixed_price", label: "Fixed Price" },
        { value: "auction", label: "Auction" },
    ];
    const fixedListingDuration = [
        { label: "Select a Option", value: "" },
        { value: "Days_14", label: "Days_14" },
        { value: "Days_21", label: "Days_21" },
        { value: "Days_30", label: "Days_30" },
        { value: "Days_60", label: "Days_60" },
        { value: "Days_90", label: "Days_90" },
        { value: "Days_120", label: "Days_120" },
        { value: "GTC", label: "GTC" },
    ];
    const auctionListingDuration = [
        { label: "Select a Option", value: "" },
        { value: "Days_1", label: "Days_1" },
        { value: "Days_3", label: "Days_3" },
        { value: "Days_5", label: "Days_5" },
        { value: "Days_7", label: "Days_7" },
        { value: "Days_10", label: "Days_10" },
    ];
    const product_id_type_options = [
        { label: "Select a Option", value: "" },
        { value: "UPC", label: "UPC" },
        { value: "ISBN", label: "ISBN" },
        { value: "EAN", label: "EAN" },
        { value: "MPN", label: "MPN" },
    ];
    const handleTabChange = useCallback(
        (selectedTabIndex) => setSelectedTab(selectedTabIndex),
        []
    );
    const handleChangeDefaultProfile = useCallback(
        (value) => setIsDefaultProfile(value),
        []
    );
    const handleChangeProfileName = useCallback((value) => setName(value), []);
    const handleChangeListingFormat = useCallback(
        (value) => setListingFormat(value),
        []
    );
    const handleChangeListingDuration = useCallback(
        (value) => setListingDuration(value),
        []
    );
    const handleChangeItemLocation = useCallback(
        (value) => setItemLocation(value),
        []
    );
    // const handleChangePostalCode = (event) => {
    //     // Update postalCode state with the new value entered in the TextField
    //     setPostalCode(event.target.value);
    // };
    const handleChangePostalCode = useCallback(
        (value) => setPostalCode(value),
        []
    );
    const handleChangeTemplateOption = useCallback(
        (value) => setTemplateId(value),
        []
    );
    const handleChangeProductType = useCallback(
        (value) => setpProductidtype(value),
        []
    );
    const getListingDurationOptions = () => {
        if (listingFormat === "auction") {
            return auctionListingDuration;
        } else if (listingFormat === "fixed_price") {
            return fixedListingDuration;
        } else {
            return [{ label: "Select a Option", value: "" }];
        }
    };

    const validateForm = () => {
        let errors = {};
        if (!name) errors.name = "Profile Name is required";
        if (isDefaultProfile === "")
            errors.isDefaultProfile = "Default Profile is required";
        if (!listingFormat) errors.listingFormat = "Listing Format is required";
        if (!listingDuration)
            errors.listingDuration = "Listing Duration is required";
        if (!itemLocation) errors.itemLocation = "Item Location is required";
        if (!postalCode) errors.postalCode = "Postal Code is required";
        setErrors(errors);
        return Object.keys(errors).length === 0;
    };
    // fetch templates api
    useEffect(() => {

        fetch(
            `${props.api_url}/templates?shopify_url=${props.store_data.shopify_url}&api_token=${props.store_data.user.api_token}`
        )
            .then((res) => res.json())
            .then((data) => {
                if (data && data.total > 0) {
                    const options = data.data.map((template) => ({
                        label: template.name,
                        value: template.id.toString(),
                    }));
                    setTemplateOptions((prevOptions) => [
                        ...prevOptions,
                        ...options,
                    ]);
                }
            })
            .catch(console.log);
    }, [
        props.api_url,
        props.store_data.shopify_url,
        props.store_data.user.api_token,
    ]);

    // fetch ebaycategory api
    // useEffect((ebayCategoryID) => {
    //     console.log("dataaaa",ebayCategoryID);
    //     const apiUrl = `${props.api_url}/ebaycategory?category_id=${ebayCategoryID}&shopify_url=${props.store_data.shopify_url}&api_token=${props.store_data.user.api_token}`;
    //     fetch(apiUrl)

    //         .then((res) => res.json())
    //         .then((data) => {
    //             // console.log('ebayspecificdata',data);
    //         })
    //         .catch(console.log);
    // }, [
    //     props.api_url,
    //     props.store_data.shopify_url,
    //     props.store_data.user.api_token,
    // ]);
    // start category function
    useEffect(() => {
        const fetchData = async () => {
            try {
                const response = await axios.get(
                    `${props.service_url}/public/category-json/categories_${ebay_account.siteid}.json`
                );
                const data = response.data;
                // console.log("categories_-data", data);
                setEbayCategories(data);
                setFilteredCategories(data);
                setSuccessMessage(data.msg);
            } catch (error) {
                console.log(error);
            }
        };

        fetchData();
    }, [props.service_url, ebay_account.siteid]);

    const handleSearchChange = (value) => {
        // console.log("select category value", value);
        // setConidtion_fetched3(false)
        // setCategory_fetched(false)
        // setDBItemcondition(false)
        setIsFieldHidden(false)
        setConditions_true(false);
        setSearchTerm(value);
        filterCategories(value);
        setMenuIsOpen(value.length > 0); // Open the dropdown if search input is not empty
    };
    const filterCategories = (inputValue) => {
        const filtered = ebayCategories.filter((category) =>
            category.category_tree_name
                .toLowerCase()
                .includes(inputValue.toLowerCase())
        );
        setFilteredCategories(filtered);
    };
    const [selectedValues, setSelectedValues] = useState({});
    //const catdataArray = Object.entries(selectedValues).map(([key, value]) => ({ key, value }));


    const handleCategoryClick = async (category) => {

        setConidtion_fetched3(false)
        setCategory_fetched(false)
        setDBItemcondition(false)
        setIsFieldHidden(false);
        setConidtion_fetched(true)
        setConidtion_fetched2(true)
        setSelectedCategory(category);
        setSearchTerm(category.category_tree_name);
        setMenuIsOpen(false); // Close the dropdown upon selection
        setSelectedCategoryID(category.id);
        setDBItemcondition(false)
        setChildConditionExit(false)
        const apiUrl = `${props.api_url}/ebaycategory?category_id=${category.id}&shopify_url=${props.store_data.shopify_url}&api_token=${props.store_data.user.api_token}`;
        // Make the API call
        try {
            const response = await axios.get(apiUrl);

          //  console.log("response", response);
            
            let category_attributes = response.data.category_attributes;
            setAdditionalCategoryData(category_attributes);
            const item_condition_data = response.data.item_condition_data
            const getItemConditionData = item_condition_data;
            setConditionOptions([
                getItemConditionData // Add fetched options
            ]);


            let initialSelectedValues = {};
            category_attributes.forEach(attr => {
                if (attr.values.length > 0) {
                    initialSelectedValues[attr.name] = attr.values[0];
                }
            });
            // console.log('1',initialSelectedValues);
            setSelectedValues(initialSelectedValues);

            if (response.data.category_attributes) {

                setConidtion_fetched2(false)
                setConidtion_fetched3(true)
            }
            if (response.data.item_condition_data) {
               
                setConidtion_fetched(false)
                setConditions_true(true)

            }
            setSuccessMessage(response.msg);
        } catch (error) {
            console.error("Error calling the API:", error);
        }
    };
    const handleValueChange = (attributeName, newValue) => {
        setSelectedValues(prevState => ({
            ...prevState,
            [attributeName]: newValue
        }));
    };
    // end category function
    const handleShippingProfileChange = (value) => {
        setSelectedShippingProfile(value);
    };
    const handlePaymentProfileChange = (value) => {
        setPaymentProfile_val(value);
    };
    const handleReturnProfileChange = (value) => {
        setReturnProfile_val(value);
    };
    // console.log("1 step category", selectedValues);
    // console.log("ebayCategoryAttributes", ebayCategoryAttributes);
    // end ebay specification data	
    const handleFormSubmitFirstStep = async () => {
        if (!validateForm()) {
            return;
        }
        const ebayCategoryAttributesJSON = JSON.stringify(
            ebayCategoryAttributes
        );
        const ebayCategory = selectedCategoryID || categoryId;
       // console.log("ebay cat");
        localStorage.setItem('ebayCategoryID 1', ebayCategoryID);
        // Construct formData object
        const formData = {
            profile_id: profileId,
            name: name,
            trim_title: trimTitle,
            is_default_profile: isDefaultProfile,
            listing_format: listingFormat,
            listing_duration: listingDuration,
            item_location: itemLocation,
            postal_code: postalCode.toString(),
            template_id: templateId,
            // ebay_category_1: ebayCategoryID,
            ebay_category_1: localStorage.getItem('ebayCategoryID 1'),
            item_specifics: selectedValues,
            product_id_type: product_id_type,
            update_install_step: false,
            shopify_url: shopify_url, // Hardcoded for now, ensure it's correct

        };

        // console.log('step 1 data', formData);

        try {
            const fetch_url = `${props.api_url}/profile/${props.profile_id}?api_token=${props.store_data.user.api_token}`;

            const response = await fetch(fetch_url, {
                method: "PUT",
                headers: {
                    "Content-Type": "application/json",
                },
                body: JSON.stringify(formData),
            });

            if (!response.ok) {
                const errorData = await response.json();
                if (errorData.errors) {
                    // Assuming errorData.errors is an object with field-specific error messages
                    const fieldErrors = {};
                    Object.keys(errorData.errors).forEach((field) => {
                        fieldErrors[field] = errorData.errors[field][0];
                    });
                    setErrors(fieldErrors);
                    return;
                } else {
                    throw new Error("Failed to save profile data");
                }
            }

            const data = await response.json();
            //setSuccessMessage(data.msg);
            const updatedProfileId = data.profile.id;
            const updatedProfilename = data.profile.name;
            setProfileId(updatedProfileId);
            setProfilename(updatedProfilename);

            const nextTab = selectedTab + 1;
            if (nextTab < tabs.length) {
                setSelectedTab(nextTab);
            }
        } catch (error) {
            console.error("Error while updating profile data:", error);
            setErrorMessage("Failed to update profile data"); // Set error message appropriately
        }
    };
    const handleSecondStep = async () => {
        // if (!searchTerm) errors.searchTerm = "category is required";
        let formIsValid = true;
        let errors = {};

        if (!searchTerm) {
            formIsValid = false;
            errors.searchTerm = "Category is required";
        }
        const ebayCategoryAttributesJSON = JSON.stringify(
            ebayCategoryAttributes
        );
        let ebayCategory = selectedCategoryID || categoryId;
        // if (ebayCategory == null) {
        //     ebayCategory = localStorage.getItem('categoryId')
        // }
        console.log("here is the categoryyy->", ebayCategory);
        localStorage.setItem('ebayCategory 2', ebayCategory);
        const selecteItemdCondition = {
            name: selectedItemConditionName, // Save the selected condition name
            value: selectedCondition, // Save the selected condition ID
        }

        const formData = {
            profile_id: profileId,
            name: name,
            shipping_profile: selectedShippingProfile,
            payment_profile: paymentProfile_val,
            return_profile: returnProfile_val,
            // ebay_category_1: ebayCategory,
            ebay_category_1: localStorage.getItem('ebayCategoryID 1'),
            item_specifics: selectedValues,
            item_condition: selecteItemdCondition,
            child_item_condition: [selectedDescriptorValues], // Save as JSON
            update_install_step: false,
            shopify_url: shopify_url,

        };
        console.log('formData step 2', formData);
        const fetch_url = `${props.api_url}/profile/${profileId}?api_token=${props.store_data.user.api_token}`;
        try {
            const response = await fetch(fetch_url, {
                method: "PUT",
                headers: {
                    "Content-Type": "application/json",
                },
                body: JSON.stringify(formData),
            });

            if (!response.ok) {
                throw new Error("Failed to save profile data in step 2");
            }

            const data = await response.json();
            setSuccessMessage(data.msg);
            //localStorage.removeItem('categoryId');
            // alert("Profile saved successfully");
            // console.log("Response Data:", data);

            // Move to the next tab
            // const nextTab = selectedTab + 1;
            // if (nextTab < tabs.length) {
            //     setSelectedTab(nextTab);
            // }

            // history.push("/profiles");
            setTimeout(() => {
                history.push("/cp/profiles");
            }, 1000);
        } catch (error) {
            console.error(error);
        }
    };
    const handlePrevious = () => {
        const prevTab = selectedTab - 1;
        if (prevTab >= 0) {
            setSelectedTab(prevTab);
        }
    };

    const handleSelectionChange = (selectedOption, index) => {

        const updatedSelectedOptions = [...selectedOptions];
        updatedSelectedOptions[index] = selectedOption;
        setSelectedOptions(updatedSelectedOptions);
        // console.log("Selected option value:", selectedOption);
        // Send all dropdown values with their names
        sendAllDropdownValues(updatedSelectedOptions);
    };

    const sendAllDropdownValues = (options) => {
        //console.log("options");
        const dropdownValues = options.map((option, index) => ({
            name: additionalCategoryData[index].name,
            value: option,
        }));

        // Do whatever you need to do with all dropdown values
        // console.log("All dropdown values:", dropdownValues);
        setEbayCategoryAttributes(dropdownValues);
    };

    const handleChange = async (event) => {
        // alert(event.target.value);
        const selectedConditionId = event.target.value;
        setSelectedCondition(selectedConditionId);
        // Find the selected condition by ID
        const selectedCondition = conditions[0].find(condition => condition.conditionId === selectedConditionId);
        // alert(1);
        // If the selected condition is found
        if (selectedCondition) {
            // Set both the ID and the name
            //  console.log("Condition found for name:", selectedCondition.conditionDescription);
            setSelectedConditionName(selectedCondition.conditionDescription);
        } else {
            //console.log("Condition not found for ID:", selectedConditionId);
        }

        const ebayCategory = selectedCategoryID || categoryId;
        const apiUrl = `${props.api_url}/ebaycategory?category_id=${ebayCategory}&conditionId=${event.target.value}&shopify_url=${props.store_data.shopify_url}&api_token=${props.store_data.user.api_token}`;
        try {
            const response = await axios.get(apiUrl);
            if(response.data.conditionDescriptors){
                const conditionDescriptors = response.data.conditionDescriptors; // Assuming conditionDescriptors is a property in the response data
                setConditionDescriptors(conditionDescriptors);
            }
            
        } catch (error) {
            console.error("Error calling the API:", error);
        }
    };
    const handleChange1 = async (event) => {
        setChildConditionExit(false)
        // alert(event.target.value);
        const selectedConditionId = event.target.value;
        setSelectedCondition(selectedConditionId);
        // Find the selected condition by ID
        const selectedCondition = itemConditionArr.find(condition => condition.conditionId === selectedConditionId);
       
        // If the selected condition is found
        if (selectedCondition) {
            // Set both the ID and the name
            //  console.log("Condition found for name:", selectedCondition.conditionDescription);
            setSelectedConditionName(selectedCondition.conditionDescription);
        } else {
            //console.log("Condition not found for ID:", selectedConditionId);
        }

        const ebayCategory = selectedCategoryID || categoryId;
        const apiUrl = `${props.api_url}/ebaycategory?category_id=${ebayCategory}&conditionId=${event.target.value}&shopify_url=${props.store_data.shopify_url}&api_token=${props.store_data.user.api_token}`;
        try {
            const response = await axios.get(apiUrl);
            const conditionDescriptors = response.data.conditionDescriptors; // Assuming conditionDescriptors is a property in the response data
            setConditionDescriptors(conditionDescriptors);
        } catch (error) {
            console.error("Error calling the API:", error);
        }
    };

    const [selectedDescriptorValues, setSelectedDescriptorValues] = useState({});

    const handleDescriptorValueChange = (descriptorId, descriptorName, selectedValueId, selectedValueName) => {
        setSelectedDescriptorValues(prevState => ({
            ...prevState,
            [descriptorId]: { id: selectedValueId, name: selectedValueName }
        }));

        // console.log('3333333333333333',     selectedDescriptorValues );
    };

    const [popoverActive, setPopoverActive] = useState(true);
    const togglePopoverActive = useCallback(
        () => setPopoverActive((popoverActive) => !popoverActive),
        [],
    );
    const activator = (
        <Button onClick={togglePopoverActive} disclosure>
            +
        </Button>
    );
    const fetchBusinessPolicies = () => {
        var hasError = false;
        //console.log("entered in the fetch business ()");
        //var fetch_profile_text = this.state.fetch_profile_text;
        var fetch_profile_text = "Fetch Business Policies";
        if (fetch_profile_text === "Fetch Business Policies") {
            // this.setState(() => {
            // 	return {
            // 		fetch_profile_text: "Fetching...",
            // 	};
            // });
            if (hasError === false) {
                // this.setState({ button_loading: true });
            }

            var fetch_url =
                props.api_url +
                "/fetch_profiles?shopify_url=" +
                props.store_data.shopify_url +
                "&api_token=" +
                props.store_data.user.api_token;
            var requestOptions = {
                method: "GET",
                headers: { "Content-Type": "application/json" },
            };
            fetch(fetch_url, requestOptions)
                .then((response) => response.json())
                .then((data) => {
                    //console.log("here is the policy ", data)

                    if (data.shipping_profiles.length != 0) {


                        var ship = [];

                        for (ckey in data.shipping_profiles) {
                            ship.push({
                                label: data.shipping_profiles[ckey].name,
                                value: data.shipping_profiles[
                                    ckey
                                ].id.toString(),
                            });
                        }
                        setShipping_profiles(ship)

                        //console.log(shipping_profiles);
                    } else {

                        var ship = [
                            {
                                label: "Please add Shipping policy to your eBay account",
                                value: "",
                            },
                        ];
                        setShipping_profiles(ship)
                    }

                    if (data.payment_profiles.length != 0) {


                        var pay = [];

                        for (ckey in data.payment_profiles) {
                            pay.push({
                                label: data.payment_profiles[ckey].name,
                                value: data.payment_profiles[
                                    ckey
                                ].id.toString(),
                            });
                        }
                        setPaymentProfiles(pay)


                    } else {

                        var pay = [
                            {
                                label: "Please add Payment policy to your eBay account",
                                value: "",
                            },
                        ];
                        setPaymentProfiles(pay)
                    }

                    if (data.return_profiles.length != 0) {

                        var ret = [];

                        for (ckey in data.return_profiles) {
                            ret.push({
                                label: data.return_profiles[ckey].name,
                                value: data.return_profiles[ckey].id.toString(),
                            });
                        }
                        setReturnProfiles(ret)
                    } else {
                        var ret = [
                            {
                                label: "Please add Return policy to your eBay account",
                                value: "",
                            },
                        ];
                        setReturnProfiles(ret)
                    }


                    return
                    // this.setState(() => {
                    // 	return {
                    // 		fetch_profile_text: "Fetching Done",
                    // 	};
                    // });
                    setTimeout(function () {
                        // this.setState(() => {
                        // 	return {
                        // 		fetch_profile_text: "Fetch Business Policies",
                        // 	};
                        // });
                    }, 5000);
                    //   console.log(data);
                    // this.setState({
                    // 	button_loading: false,
                    // 	success_message: "",
                    // });					
                    var ckey;
                    // this.setState({
                    // 	button_loading: false,
                    // 	success_message: "request has been submitted",
                    // });
                    if (data.shipping_profiles.length != 0) {
                        this.state.shipping_status = false;
                        //console.log("made shipping_status true on line no 1161");
                        //console.log("entered in the fetch business poilcy function");
                        this.state.symbol_policy = true;
                        var shipping_profiles = [
                            { label: "Select a Shipping Profile", value: "" },
                        ];
                        //shipping_profiles = shipping_profiles.slice(1);
                        for (ckey in data.shipping_profiles) {
                            shipping_profiles.push({
                                label: data.shipping_profiles[ckey].name,
                                value: data.shipping_profiles[
                                    ckey
                                ].id.toString(),
                            });
                        }
                    } else {

                        var shipping_profiles = [
                            {
                                label: "Please add Shipping policiy to your eBay account",
                                value: "",
                            },
                        ];
                    }
                    if (data.payment_profiles.length != 0) {
                        this.state.payment_status = false;
                        // console.log(data.payment_profiles);
                        this.state.symbol_policy = true;
                        var payment_profiles = [
                            { label: "Select a Payment Profile", value: "" },
                        ];
                        // payment_profiles = payment_profiles.slice(1);
                        for (ckey in data.payment_profiles) {
                            payment_profiles.push({
                                label: data.payment_profiles[ckey].name,
                                value: data.payment_profiles[
                                    ckey
                                ].id.toString(),
                            });
                        }
                    } else {
                        var payment_profiles = [
                            {
                                label: "Please add Payment policiy to your eBay account",
                                value: "",
                            },
                        ];
                    }
                    if (data.return_profiles.length != 0) {
                        this.state.return_status = false;
                        // console.log(data.return_profiles);
                        this.state.symbol_policy = true;
                        var return_profiles = [
                            { label: "Select a Return Profile", value: "" },
                        ];
                        // return_profiles = return_profiles.slice(1);
                        for (ckey in data.return_profiles) {
                            return_profiles.push({
                                label: data.return_profiles[ckey].name,
                                value: data.return_profiles[ckey].id.toString(),
                            });
                        }
                    } else {
                        var return_profiles = [
                            {
                                label: "Please add Return policiy to your eBay account",
                                value: "",
                            },
                        ];
                    }
                    this.setState({
                        button_loading: false,
                        success_message: null,
                    });
                    this.setState(() => {
                        return {
                            shipping_profiles: shipping_profiles,
                            // shipping_profiles_msg:shipping_profiles_msg,
                            payment_profiles: payment_profiles,
                            // payment_profiles_msg:payment_profiles_msg,
                            return_profiles: return_profiles,
                            // return_profiles_msg:return_profiles_msg,
                        };
                    });
                })
                .catch((error) => {
                    //console.error(error);
                });
        } else {
            console.log("here is not the policy ")
        }
    };
    const fetchBusinessPolicies1 = (num) => {

        //  console.log("num -> ", num);
        if (num == 1) {
            handleToggle()
        } else if (num == 2) {
            handleToggle2()
        } else if (num == 3) {
            handleToggle3()
        }


        var hasError = false;
        var fetch_profile_text = "Fetch Business Policies";
        if (fetch_profile_text === "Fetch Business Policies") {

            if (hasError === false) {

            }

            var fetch_url =
                props.api_url +
                "/fetch_profiles?shopify_url=" +
                props.store_data.shopify_url +
                "&api_token=" +
                props.store_data.user.api_token;
            var requestOptions = {
                method: "GET",
                headers: { "Content-Type": "application/json" },
            };
            fetch(fetch_url, requestOptions)
                .then((response) => response.json())
                .then((data) => {
                    //	console.log("here is the policy ", data)
                    var ckey;
                    if (data.shipping_profiles.length != 0) {

                        var ship = [];

                        for (ckey in data.shipping_profiles) {
                            ship.push({
                                label: data.shipping_profiles[ckey].name,
                                value: data.shipping_profiles[
                                    ckey
                                ].id.toString(),
                            });
                        }
                        setShipping_profiles(ship)

                        //console.log(shipping_profiles);
                    } else {

                        var ship = [
                            {
                                label: "Please add Shipping policy to your eBay account",
                                value: "",
                            },
                        ];
                        setShipping_profiles(ship)
                    }

                    if (data.payment_profiles.length != 0) {


                        var pay = [];

                        for (ckey in data.payment_profiles) {
                            pay.push({
                                label: data.payment_profiles[ckey].name,
                                value: data.payment_profiles[
                                    ckey
                                ].id.toString(),
                            });
                        }
                        setPaymentProfiles(pay)


                    } else {

                        var pay = [
                            {
                                label: "Please add Payment policy to your eBay account",
                                value: "",
                            },
                        ];
                        setPaymentProfiles(pay)
                    }

                    if (data.return_profiles.length != 0) {

                        var ret = [];

                        for (ckey in data.return_profiles) {
                            ret.push({
                                label: data.return_profiles[ckey].name,
                                value: data.return_profiles[ckey].id.toString(),
                            });
                        }
                        setReturnProfiles(ret)
                    } else {
                        var ret = [
                            {
                                label: "Please add Return policy to your eBay account",
                                value: "",
                            },
                        ];
                        setReturnProfiles(ret)
                    }

                    set_businesspolicy_refresh(false)
                    return


                })
                .catch((error) => {
                    //console.error(error);
                });
        } else {
            console.log("here is not the policy ")
        }
    };
    const handleExportedAction = useCallback(

        () => {
            set_businesspolicy_refresh(true)
            fetchBusinessPolicies1(1)
        },
        []
    );
    const handleExportedAction2 = useCallback(
        () => {
            set_businesspolicy_refresh(true)
            fetchBusinessPolicies1(2)

        },
        []
    );
    const handleExportedAction3 = useCallback(
        () => {
            set_businesspolicy_refresh(true)
            fetchBusinessPolicies1(3)
        },
        []
    );
    const handleImportedAction = useCallback(() => {
        handleToggle()
        window.open(
            "https://www.bizpolicy.ebay.com/businesspolicy/shipping?pageNumber=1&totalPages=1&source=manage",
            "_blank"
        );

    }, []);
    const handleImportedAction2 = useCallback(() => {
        handleToggle2()
        window.open(
            "https://www.bizpolicy.ebay.com/businesspolicy/payment?pageNumber=1&totalPages=1&source=manage",
            "_blank"
        );

    }, []);
    const handleImportedAction3 = useCallback(() => {
        handleToggle3()
        window.open(
            "https://www.ebay.com/bp/rtn/create",
            "_blank"
        );

    }, []);
    const handleToggleAction = () => {
        toggleAction(!actionActive);
    };
    const handleToggleAction2 = () => {
        toggleAction2(!actionActive2);
    };
    const handleToggleAction3 = () => {
        toggleAction3(!actionActive3);
    };
    const handleToggle = () => {
        toggleAction(false);
    };
    const handleToggle2 = () => {
        toggleAction2(false);
    };
    const handleToggle3 = () => {
        toggleAction3(false);
    };
    const disclosureButtonActivator = (
        <Button icon={PlusMinor} onClick={handleToggleAction}>
        </Button>
    );
    const disclosureButtonActivator2 = (
        <Button icon={PlusMinor} onClick={handleToggleAction2}>

        </Button>
    );
    const disclosureButtonActivator3 = (
        <Button icon={PlusMinor} onClick={handleToggleAction3}>

        </Button>
    );

    const getChildItemEntries = Object.entries(childItemCondition);

    return (
        <>
            <Page title={pageTitle}>
                <Layout>
                    <Layout.AnnotatedSection
                        title={subTitle}
                        description={subDescription}
                    >
                        <Card sectioned>
                            <Tabs
                                tabs={tabs}
                                selected={selectedTab}
                                onSelect={handleTabChange}
                            >
                                <Card.Section>
                                    <form
                                        onSubmit={handleFormSubmitFirstStep}
                                        method="post"
                                        encType="multipart/form-data"
                                    // preventDefault="true"
                                    >
                                        {selectedTab === 0 && (
                                            <FormLayout>
                                                <Checkbox
                                                    label="Trim Title"
                                                    checked={trimTitle}
                                                    onChange={() =>
                                                        setTrimTitle(!trimTitle)
                                                    }
                                                    error={errors.trimTitle}
                                                />
                                                <Select
                                                    label="Default Profile ?"
                                                    options={yesNoOptions}
                                                    onChange={
                                                        handleChangeDefaultProfile
                                                    }
                                                    value={isDefaultProfile}
                                                    error={errors.isDefaultProfile}
                                                />
                                                <TextField
                                                    type="text"
                                                    label="Profile Name"
                                                    value={name}
                                                    onChange={
                                                        handleChangeProfileName
                                                    }
                                                    error={errors.name}
                                                />
                                                <Select
                                                    label="Listing Format"
                                                    options={listingFormats}
                                                    onChange={
                                                        handleChangeListingFormat
                                                    }
                                                    value={listingFormat}
                                                    error={errors.listingFormat}
                                                />
                                                {listingFormat && (
                                                    <Select
                                                        label="Listing Duration"
                                                        options={getListingDurationOptions()}
                                                        onChange={
                                                            handleChangeListingDuration
                                                        }
                                                        value={listingDuration}
                                                        error={
                                                            errors.listingDuration
                                                        }
                                                    />
                                                )}
                                                <TextField
                                                    type="text"
                                                    label="Item Location"
                                                    value={itemLocation}
                                                    onChange={
                                                        handleChangeItemLocation
                                                    }
                                                    error={errors.itemLocation}
                                                />

                                                <TextField
                                                    type="text"
                                                    label="Postal Code"
                                                    value={postalCode}
                                                    onChange={handleChangePostalCode}
                                                    error={errors.postalCode}
                                                    placeholder={postalCode}
                                                />
                                                <Select
                                                    label="Description Template"
                                                    options={templateOptions}
                                                    onChange={
                                                        handleChangeTemplateOption
                                                    }
                                                    value={templateId}
                                                    error={errors.templateId}
                                                />
                                                <Select
                                                    label="Product ID Type"
                                                    options={
                                                        product_id_type_options
                                                    }
                                                    onChange={
                                                        handleChangeProductType
                                                    }
                                                    value={product_id_type}
                                                />
                                            </FormLayout>
                                        )}
                                        {selectedTab === 1 && (
                                            <FormLayout>
                                                <div className="dropdown-container">
                                                    {businesspolicy_refresh ?
                                                        <Card sectioned roundedAbove="sm">
                                                            <div>
                                                                <label className="category-lable">Fetching Business Policies...</label>
                                                                <SkeletonBodyText lines={10} />
                                                            </div>
                                                        </Card>
                                                        :
                                                        <Card sectioned roundedAbove="sm">
                                                            <div
                                                                style={{
                                                                    width: "100%",
                                                                    display: "flex",

                                                                }}
                                                            >
                                                                <div style={{ width: "100%" }}>
                                                                    <Select
                                                                        label="Shipping Profile"
                                                                        options={shipping_profiles}
                                                                        onChange={handleShippingProfileChange}
                                                                        value={selectedShippingProfile}
                                                                    />
                                                                </div>

                                                                <div style={{ padding: "24px 0px 0px 10px" }}>

                                                                    <Popover
                                                                        active={actionActive}
                                                                        activator={disclosureButtonActivator}
                                                                        onClose={handleToggleAction}
                                                                        autofocusTarget="first-node"
                                                                    >
                                                                        <ActionList actionRole="menuitem"
                                                                            items={[
                                                                                {
                                                                                    content: 'Create',
                                                                                    onAction: handleImportedAction,
                                                                                },
                                                                                {
                                                                                    content: 'Refresh',
                                                                                    onAction: handleExportedAction,
                                                                                },
                                                                            ]} />
                                                                    </Popover>

                                                                </div>


                                                            </div>

                                                            <div
                                                                style={{
                                                                    display: "flex",
                                                                    alignItems: "center",                                                                }}
                                                            >
                                                                <div style={{ width: "100%" }}>
                                                                    <Select
                                                                        label="Payment Profile"
                                                                        options={paymentProfiles}
                                                                        onChange={handlePaymentProfileChange}
                                                                        value={paymentProfile_val}
                                                                    />
                                                                </div>

                                                                <div style={{ padding: "24px 0px 0px 10px" }}>

                                                                    <Popover
                                                                        active={actionActive2}
                                                                        activator={disclosureButtonActivator2}
                                                                        onClose={handleToggleAction2}
                                                                        autofocusTarget="first-node"
                                                                    >
                                                                        <ActionList actionRole="menuitem"
                                                                            items={[
                                                                                {
                                                                                    content: 'Create',
                                                                                    onAction: handleImportedAction2,
                                                                                },
                                                                                {
                                                                                    content: 'Refresh',
                                                                                    onAction: handleExportedAction2,
                                                                                },
                                                                            ]} />
                                                                    </Popover>

                                                                </div>

                                                            </div>

                                                            <div
                                                                style={{
                                                                    display: "flex",
                                                                    alignItems: "center",
                                                                }}
                                                            >
                                                                 <div style={{ width: "100%" }}>
                                                                    <Select
                                                                        label="Return Profile"
                                                                        options={returnProfiles}
                                                                        onChange={handleReturnProfileChange}
                                                                        value={returnProfile_val}
                                                                    />
                                                                </div>

                                                                <div style={{ padding: "24px 0px 0px 10px" }}>
                                                                    <Popover
                                                                        active={actionActive3}
                                                                        activator={disclosureButtonActivator3}
                                                                        onClose={handleToggleAction3}
                                                                        autofocusTarget="first-node"
                                                                    >
                                                                        <ActionList actionRole="menuitem"
                                                                            items={[
                                                                                {
                                                                                    content: 'Create',
                                                                                    onAction: handleImportedAction3,
                                                                                },
                                                                                {
                                                                                    content: 'Refresh',
                                                                                    onAction: handleExportedAction3,
                                                                                },
                                                                            ]} />
                                                                    </Popover>

                                                                </div>

                                                            </div>
                                                        </Card>
                                                    }
                                                    <div style={{
                                                        width: "100%",
                                                        padding: "40px 0px 10px"
                                                    }}>

                                                        <Card sectioned >
                                                            <div>
                                                                <TextField
                                                                    label="Select Category"
                                                                    value={searchTerm}
                                                                    onChange={
                                                                        handleSearchChange
                                                                    }
                                                                    placeholder="Search category..."
                                                                    autoComplete="off"
                                                                    error={errors.searchTerm}
                                                                />
                                                                {menuIsOpen &&
                                                                    filteredCategories.length >
                                                                    0 && (
                                                                        <ul className="dropdown-menu">
                                                                            {filteredCategories.map(
                                                                                (category) => (
                                                                                    <li
                                                                                        key={
                                                                                            category.id
                                                                                        }
                                                                                        onClick={() =>
                                                                                            handleCategoryClick(
                                                                                                category
                                                                                            )
                                                                                        }
                                                                                        className="dropdown-item"
                                                                                    >
                                                                                        {
                                                                                            category.category_tree_name
                                                                                        }
                                                                                    </li>
                                                                                )
                                                                            )}
                                                                        </ul>
                                                                    )}{ }
                                                            </div>
                                                        </Card>


                                                        {/* {isFieldHidden && (
                                                         <div style={{
                                                            width: "100%",
                                                            padding: "40px 0px 10px"
                                                        }}>

                                                        <Card>
                                                            <div className="selected-cat-data" id="selected-cat-data">
                                                                
                                                                {catdataArray.map((item, index) => (
                                                                    <div key={index}>
                                                                        <label>{item.key}</label>
                                                                        <TextField
                                                                            value={item.value}
                                                                            placeholder=""
                                                                            autoComplete="off"
                                                                            disabled
                                                                        />
                                                                    </div>
                                                                ))}

                                                                <TextField
                                                                    type="text"
                                                                    label="Item Condition"
                                                                    value={item_condition}    
                                                                    disabled
                                                                />
                                                                 </div>
                                                                </Card>

                                                               <Card>
                                                            <div className="selected-cat-data" id="selected-cat-data">
                                                                
                                                              
                                                                    {getChildItemEntries.map(([key, item]) => (
                                                                        <div key={key}>
                                                                            <label>
                                                                                {key === "27501" ? "Professional Grader" : key === "27502" ? "Grade" : key === "27503" ? "Certification Number" : key}
                                                                            </label>
                                                                            <TextField
                                                                                type="text"
                                                                                label=""
                                                                                value={item.name}
                                                                                disabled
                                                                            />
                                                                        </div>
                                                                    ))}
                                                                </div> 
                                                                </Card>                                                              
                                                              
                                                        </div>
                                                    )}  */}
                                                        {category_fetched && (
                                                            <div style={{
                                                                width: "100%",
                                                                padding: "40px 0px 10px"
                                                            }}>

                                                                <Card sectioned roundedAbove="sm">
                                                                    <div className="subcategory-dropdown custom-polaris-select">

                                                                        {additionalCategoryData.map(attribute => (
                                                                            <div key={attribute.name} className="Polaris-Select">
                                                                                <label className="category-lable">{attribute.name}</label>
                                                                                <select
                                                                                    value={selectedValues[attribute.name] || ''}
                                                                                    onChange={(e) => handleValueChange(attribute.name, e.target.value)}
                                                                                    className="selected-cat"
                                                                                >
                                                                                    {attribute.values.map(value => (
                                                                                        <option className="" key={value} value={value}>
                                                                                            {value}
                                                                                        </option>
                                                                                    ))}
                                                                                </select>
                                                                            </div>
                                                                        ))}

                                                                    </div>
                                                                </Card>
                                                            </div>
                                                        )
                                                        }

                                                        {dBItemcondition && (
                                                            <div style={{
                                                                width: "100%",
                                                                padding: "40px 0px 10px"
                                                            }}>
                                                                <Card sectioned roundedAbove="sm">
                                                                    <div className="subcategory-dropdown custom-polaris-select">


                                                                        <label className="category-lable">Select Condition</label>
                                                                        <select id='selected-cat' className="selected-cat" value={selectedCondition} onChange={handleChange1}>
                                                                            {/* <option value="" disabled selected>{itemConditionArr.length === 0 ? "Loading..." : "Select an option"}</option> */}
                                                                            {itemConditionArr.length > 0 && itemConditionArr.map(condition => (
                                                                                <option key={condition.conditionId} value={condition.conditionId}>
                                                                                    {condition.conditionDescription}
                                                                                </option>
                                                                            ))}
                                                                        </select>
                                                                    </div>
                                                                      {childConditionExit &&(
                                                                        <div className="selected-cat-data" id="selected-cat-data"> 
                                                                                {getChildItemEntries.map(([key, item]) => (
                                                                                    <div key={key}>
                                                                                        <label>
                                                                                            {key === "27501" ? "Professional Grader" : key === "27502" ? "Grade" : key === "27503" ? "Certification Number" : key}
                                                                                        </label>
                                                                                        <TextField
                                                                                            type="text"
                                                                                            label=""
                                                                                            value={item.name}
                                                                                            disabled
                                                                                        />
                                                                                    </div>
                                                                                ))}
                                                                         </div> 
                                                                      )}
                                                                   
                                                                        <div>
                                                                            {conditionDescriptors.map(descriptor => {
                                                                                // Check if the descriptor has values
                                                                                const hasValues = descriptor.conditionDescriptorValues && descriptor.conditionDescriptorValues.length > 0;
                                                                                return hasValues ? (
                                                                                    <div key={descriptor.conditionDescriptorId}>
                                                                                        <label className="category-label">{descriptor.conditionDescriptorName}</label>
                                                                                        <select
                                                                                            className="selected-cat"
                                                                                            id={`selected-descriptor-value-${descriptor.conditionDescriptorId}`}
                                                                                            value={selectedDescriptorValues[descriptor.conditionDescriptorId]?.id || ""}
                                                                                            onChange={(e) => {
                                                                                                const selectedValueId = e.target.value;
                                                                                                const selectedValueName = e.target.options[e.target.selectedIndex].text;
                                                                                                handleDescriptorValueChange(descriptor.conditionDescriptorId, descriptor.conditionDescriptorName, selectedValueId, selectedValueName);
                                                                                            }}
                                                                                        >
                                                                                            <option value="" disabled hidden>
                                                                                                {selectedDescriptorValues[descriptor.conditionDescriptorId] ? '' : `Select ${descriptor.conditionDescriptorName} Value`}
                                                                                            </option>
                                                                                            {descriptor.conditionDescriptorValues.map(value => (
                                                                                                <option key={value.conditionDescriptorValueId} value={value.conditionDescriptorValueId}>
                                                                                                    {value.conditionDescriptorValueName}
                                                                                                </option>
                                                                                            ))}
                                                                                        </select>
                                                                                    </div>
                                                                                ) : null;
                                                                            })}
                                                                        </div>
                                                                  
                                                                    
                                                                </Card>
                                                                {/* {setChildConditionExit &&(
                                                                     <Card>
                                                                        jk
                                                                     <div className="selected-cat-data" id="selected-cat-data">
                                                                         
                                                                       
                                                                             {getChildItemEntries.map(([key, item]) => (
                                                                                 <div key={key}>
                                                                                     <label>
                                                                                         {key === "27501" ? "Professional Grader" : key === "27502" ? "Grade" : key === "27503" ? "Certification Number" : key}
                                                                                     </label>
                                                                                     <TextField
                                                                                         type="text"
                                                                                         label=""
                                                                                         value={item.name}
                                                                                         disabled
                                                                                     />
                                                                                 </div>
                                                                             ))}
                                                                         </div> 
                                                                         </Card>      
                                                                )} */}
                                                            </div>
                                                        )}


                                                        {conidtion_fetched2 && (
                                                            <div style={{
                                                                width: "100%",
                                                                padding: "40px 0px 10px"
                                                            }}>



                                                                <Card sectioned roundedAbove="sm">
                                                                    <div

                                                                    >
                                                                        <label className="category-lable">Loading...</label>
                                                                        <SkeletonBodyText />

                                                                    </div>
                                                                </Card>

                                                            </div>
                                                        )}

                                                        {conidtion_fetched3 && (

                                                            <div style={{
                                                                width: "100%",
                                                                padding: "40px 0px 10px"
                                                            }}>

                                                                <Card sectioned roundedAbove="sm">
                                                                    <div className="subcategory-dropdown custom-polaris-select">

                                                                        {additionalCategoryData.map(attribute => (
                                                                            <div key={attribute.name} className="Polaris-Select">
                                                                                <label className="category-lable">{attribute.name}</label>
                                                                                <select
                                                                                    value={selectedValues[attribute.name] || ''}
                                                                                    onChange={(e) => handleValueChange(attribute.name, e.target.value)}
                                                                                    className="selected-cat"
                                                                                >
                                                                                    {attribute.values.map(value => (
                                                                                        <option className="" key={value} value={value}>
                                                                                            {value}
                                                                                        </option>
                                                                                    ))}
                                                                                </select>
                                                                            </div>
                                                                        ))}

                                                                    </div>
                                                                </Card>


                                                                {conidtion_fetched && (
                                                                    <div style={{
                                                                        width: "100%",

                                                                        padding: "40px 0px 10px"
                                                                    }}>



                                                                        <Card sectioned roundedAbove="sm">
                                                                            <div

                                                                            >
                                                                                <label className="category-lable">Loading...</label>
                                                                                <SkeletonBodyText />

                                                                            </div>
                                                                        </Card>

                                                                    </div>
                                                                )}
                                                                {conditions_true && (
                                                                    <div style={{
                                                                        width: "100%",
                                                                        padding: "40px 0px 10px"

                                                                    }}>

                                                                        <Card sectioned roundedAbove="sm">
                                                                            <div className="subcategory-dropdown custom-polaris-select">

                                                                                <div>
                                                                                    <label className="category-lable">Select Condition</label>
                                                                                    <select id='selected-cat' className="selected-cat" value={selectedCondition} onChange={handleChange}>
                                                                                        <option value="" disabled selected>{conditions.length === 0 ? "Loading..." : "Select an option"}</option>
                                                                                        {conditions.length > 0 && conditions[0].map(condition => (
                                                                                            <option key={condition.conditionId} value={condition.conditionId}>
                                                                                                {condition.conditionDescription}
                                                                                            </option>
                                                                                        ))}
                                                                                    </select>

                                                                                    <div>
                                                                                        <div>
                                                                                            {conditionDescriptors.map(descriptor => {
                                                                                                // Check if the descriptor has values
                                                                                                const hasValues = descriptor.conditionDescriptorValues && descriptor.conditionDescriptorValues.length > 0;
                                                                                                return hasValues ? (
                                                                                                    <div key={descriptor.conditionDescriptorId}>
                                                                                                        <label className="category-label">{descriptor.conditionDescriptorName}</label>
                                                                                                        <select
                                                                                                            className="selected-cat"
                                                                                                            id={`selected-descriptor-value-${descriptor.conditionDescriptorId}`}
                                                                                                            value={selectedDescriptorValues[descriptor.conditionDescriptorId]?.id || ""}
                                                                                                            onChange={(e) => {
                                                                                                                const selectedValueId = e.target.value;
                                                                                                                const selectedValueName = e.target.options[e.target.selectedIndex].text;
                                                                                                                handleDescriptorValueChange(descriptor.conditionDescriptorId, descriptor.conditionDescriptorName, selectedValueId, selectedValueName);
                                                                                                            }}
                                                                                                        >
                                                                                                            <option value="" disabled hidden>
                                                                                                                {selectedDescriptorValues[descriptor.conditionDescriptorId] ? '' : `Select ${descriptor.conditionDescriptorName} Value`}
                                                                                                            </option>
                                                                                                            {descriptor.conditionDescriptorValues.map(value => (
                                                                                                                <option key={value.conditionDescriptorValueId} value={value.conditionDescriptorValueId}>
                                                                                                                    {value.conditionDescriptorValueName}
                                                                                                                </option>
                                                                                                            ))}
                                                                                                        </select>
                                                                                                    </div>
                                                                                                ) : null;
                                                                                            })}
                                                                                        </div>
                                                                                    </div>

                                                                                </div>
                                                                            </div>
                                                                        </Card>
                                                                    </div>
                                                                )}
                                                            </div>


                                                        )}

                                                    </div>

                                                </div>
                                            </FormLayout>
                                        )}
                                    </form>
                                </Card.Section>
                            </Tabs>
                            <div
                                style={{
                                    display: "flex",
                                    justifyContent: "space-between",
                                    marginTop: "20px",
                                }}
                            >
                                {selectedTab == 0 && (
                                    <>
                                        <Button primary onClick={handleFormSubmitFirstStep}>
                                            Next
                                        </Button>
                                    </>
                                )}

                                {selectedTab == 1 && (
                                    <>
                                        <Button primary onClick={handlePrevious}>
                                            Previous
                                        </Button>
                                        <Button
                                            primary
                                            id="secondStepNextButton"
                                            onClick={() =>
                                                handleSecondStep(profileId)
                                            }
                                        >
                                            Next
                                        </Button>
                                    </>
                                )}

                            </div>
                        </Card>
                    </Layout.AnnotatedSection>
                </Layout>
                <>
                    {successMessage && (
                        <Toast
                            content={successMessage}
                            onDismiss={hideToast}
                            duration="1000"
                        />
                    )}
                    {errorMessage && (
                        <Toast
                            content={errorMessage}
                            error
                            onDismiss={hideToast}
                            duration="1000"
                        />
                    )}
                </>
            </Page>
        </>
    )
}
