import React, { Component } from "react";
import {
	Page,
	Button,
	Layout,
	Card,
	DataTable,
	Checkbox,
	ChoiceList,
	Filters,
	Banner,
	Thumbnail,
	Popover,
	ActionList,
	Pagination,
	Modal,
	Stack,
	Select,
	Spinner,
	Toast,
	Autocomplete,
	Icon,
	FooterHelp,
	Tooltip,
	Link,
	EmptyState,
} from "@shopify/polaris";
import $ from "jquery";
import {
	CancelSmallMinor,
	SearchMinor,
	ConnectMinor,
	DeleteMajorMonotone,
	AddProductMajorMonotone,
} from "@shopify/polaris-icons";
class Listings extends Component {
	_isMounted = false;
	productOptions = [];
	aProductOptions = [];
	state = {
		listings: {},
		products: {},
		actions: {},
		checkboxes: {},
		queryValue: "",
		queryType: "",
		listingStatus: "",
		appliedFilters: [],
		hasActiveCheckBox: false,
		lastQueryType: "",
		sortBy: "updated_at",
		sortOrder: "asc",
		showLinkProductModel: false,
		loadingProducts: false,
		listing_id: "",
		product_id: "",
		autocompleteTextFieldValue: "",
		linkProductSuccMsg: null,
		linkProductErrMsg: null,
		linkProductErr: null,
		linkProductLoading: false,
		autocompleteLoading: false,
		selectedProduct: [],
		linkProductVariants: [],
		linkListingVariants: [],
		variantsMapping: {},
		actionLoading: false,
		actionSuccMsg: null,
		actionErrMsg: null,
		paction_loading: false,
		showDefaultPagination: true,
		showAlternativePagination: false,
		currentPage: 1,
		totalPages: 1,
		listings: null,
		loading: true,
		itemsPerPage: 20,
		searchdata: "",
	};
	errors_data = {};
	constructor(props) {
		super(props);
		this.getListings = this.getListings.bind(this);
		this.getListingsData = this.getListingsData.bind(this);
		this.toggleAction = this.toggleAction.bind(this);
		this.toggleCheckbox = this.toggleCheckbox.bind(this);
		this.handleQueryChange = this.handleQueryChange.bind(this);
		this.handleListingStatusChange =
			this.handleListingStatusChange.bind(this);
		this.handleQueryTypeChange = this.handleQueryTypeChange.bind(this);
		this.handleQueryRemove = this.handleQueryRemove.bind(this);
		this.handleFiltersClearAll = this.handleFiltersClearAll.bind(this);
		this.clearQueryTypeChange = this.clearQueryTypeChange.bind(this);
		this.clearListingStatusChange =
			this.clearListingStatusChange.bind(this);
		this.handleSort = this.handleSort.bind(this);
		this.showLinkProductModel = this.showLinkProductModel.bind(this);
		this.submitLinkProduct = this.submitLinkProduct.bind(this);
		this.cancelLinkProduct = this.cancelLinkProduct.bind(this);
		this.hideToast = this.hideToast.bind(this);
		this.updateProductOptions = this.updateProductOptions.bind(this);
		this.updateProductSelection = this.updateProductSelection.bind(this);
		this.handleVariantChange = this.handleVariantChange.bind(this);
		this.getVariantsMappingValue = this.getVariantsMappingValue.bind(this);
		this.submitUnLinkProduct = this.submitUnLinkProduct.bind(this);
		this.submitDeleteListings = this.submitDeleteListings.bind(this);
		this.submitCreateProducts = this.submitCreateProducts.bind(this);
		this.submitCreateProductsBulk =
			this.submitCreateProductsBulk.bind(this);
		this.submitListingsImportRequest =
			this.submitListingsImportRequest.bind(this);
		this.handleNextPage = this.handleNextPage.bind(this);
		this.handlePrevPage = this.handlePrevPage.bind(this);
	}
	componentWillUnmount() {
		this._isMounted = false;
	}
	componentDidMount() {
		this._isMounted = true;
		document.title =
			this.props.link_status.charAt(0).toUpperCase() +
			this.props.link_status.slice(1) +
			" Listings - " +
			document.title;
		this.getListings();
	}
	submitLinkProduct() {
		if (this.state.linkProductLoading === false) {
			var product_id = this.state.product_id;
			var listing_id = this.state.listing_id;
			var variantsMapping = this.state.variantsMapping;
			var count = {};
			for (var key in variantsMapping) {
				count[variantsMapping[key]] =
					(count[variantsMapping[key]] || 0) + 1;
			}
			var hasDuplicate = false;
			var isSelected = false;
			for (key in count) {
				if (key <= 0) continue;
				if (count[key] > 1) {
					hasDuplicate = true;
					break;
				} else if (count[key] > 0) {
					isSelected = true;
				}
			}
			if (hasDuplicate === true) {
				this.setState({
					linkProductErr:
						"2 listing variants can not be linked to same product variant",
				});
			} else if (isSelected === false) {
				this.setState({
					linkProductErr: "Please map at least one variant",
				});
			} else {
				this.setState({
					linkProductLoading: true,
					linkProductErr: null,
				});
				var request_data = {
					product_id: product_id,
					listing_id: listing_id,
					variants_mapping: variantsMapping,
					shopify_url: this.props.store_data.shopify_url,
				};
				var requestOptions = {
					method: "POST",
					headers: { "Content-Type": "application/json" },
					body: JSON.stringify(request_data),
				};
				var fetch_url =
					this.props.api_url +
					"/linkproduct?api_token=" +
					this.props.store_data.user.api_token;
				fetch(fetch_url, requestOptions)
					.then((response) => response.json())
					.then((data) => {
						if (data && data.status && data.status === "success") {
							this.setState({
								linkProductLoading: false,
								linkProductSuccMsg: data.msg,
								product_id: "",
								listing_id: "",
								autocompleteTextFieldValue: "",
								selectedProduct: [],
								showLinkProductModel: false,
								linkListingVariants: [],
								linkProductVariants: [],
								variantsMapping: {},
								linkProductErrMsg: null,
								hasActiveCheckBox: false,
								checkboxes: {},
							});
							this.aProductOptions = this.productOptions;
							this.getListings();
						} else {
							var error_message =
								"there was something wrong, please try again.";
							if (data.msg) {
								error_message = data.msg;
							}
							this.setState({
								linkProductLoading: false,
								linkProductErr: error_message,
							});
						}
					})
					.catch((error) => {
						console.error(error);
					});

					// console.log('anshu1',this.aProductOptions = this.productOptions);
			}
		}
	}
	SpinnerExample() {
		return <Spinner accessibilityLabel="Spinner example" size="large" />;
	}
	hideToast() {
		this.setState({
			linkProductSuccMsg: null,
			linkProductErrMsg: null,
			actionSuccMsg: null,
			actionErrMsg: null,
		});
	}
	
	handleVariantChange = (field) => {
		return (value) => {
			var variantsMapping = this.state.variantsMapping;
			variantsMapping[field] = parseInt(value);
			this.setState({
				variantsMapping: variantsMapping,
				linkProductErr: null,
			});
			var opval = $("#PolarisSelect" + field + " option:selected").text();
			$("#PolarisSelect" + field)
				.parent()
				.find(".Polaris-Select__SelectedOption")
				.html(opval);
		};
	};
	getVariantsMappingValue(index) {
		var variantsMapping = this.state.variantsMapping;
		if (!variantsMapping[index]) return "";
		return variantsMapping[index];
	}

	showLinkProductModel(listing, title) {

		document.body.classList.add('disable-scroll');

		this.resetModalStateAndProductOptions();
	
		var encodedTitle = encodeURIComponent(title);
		var linkListingVariants = [];
	
		for (var key in listing.variants) {
			var variant = listing.variants[key];
			if (typeof variant.ebay_item_data === "string")
				variant.ebay_item_data = JSON.parse(variant.ebay_item_data);
			if (typeof variant.listing_variant_data === "string")
				variant.listing_variant_data = JSON.parse(variant.listing_variant_data);
			linkListingVariants.push(variant);
		}
	
		this.setState({
			product_id: "",
			listing_id: listing.id,
			autocompleteTextFieldValue: "",
			selectedProduct: [],
			showLinkProductModel: true,
			linkListingVariants: linkListingVariants,
			linkProductVariants: [],
			variantsMapping: {},
			loadingProducts: true
		});
	
		var queryData = [
			"shopify_url=" + this.props.store_data.shopify_url,
			"api_token=" + this.props.store_data.user.api_token,
			"title=" + encodedTitle,
		];
	
		var queryStr = queryData.join("&");
	
		// Clear productOptions before fetching new data
		this.productOptions = [];
	
		fetch(this.props.api_url + "/allproducts?" + queryStr)
			.then((res) => res.json())
			.then((data) => {
				console.log('fetch data', data);
				if (data && data.length > 0) {
					for (key in data) {
						this.productOptions.push({
							label: data[key].title,
							value: data[key].id.toString(),
						});
					}
				} else {
					// If no data found, push a "no data found" option
					this.productOptions.push({
						label: "No data found",
						value: "",
					});
				}
				this.aProductOptions = this.productOptions;
				this.setState({ loadingProducts: false, products: data });
			})
			.catch(console.log);
	}
	


	updateProductOptions(value) {
		this.setState({ autocompleteTextFieldValue: value.toString() });
		if (this.productOptions.length > 0) {
			if (!this.state.autocompleteLoading) {
				this.setState({ autocompleteLoading: true });
			}
			setTimeout(() => {
				if (value === "") {
					this.aProductOptions = this.productOptions;
					this.setState({ autocompleteLoading: false });
					return;
				}
				var filterRegex = new RegExp(value, "i");
				var resultOptions = this.productOptions.filter((option) =>
					option.label.match(filterRegex)
				);
				this.aProductOptions = resultOptions;
				this.setState({ autocompleteLoading: false });
			}, 300);
		}
	}

	updateProductSelection(value) {
		this.setState({
			linkProductVariants: [],
			variantsMapping: {},
			variantsMappingRows: {},
			linkProductErr: null,
		});
		var linkProductVariants = [];
		var products = this.state.products;
		for (var key in products) {
			var product = products[key];
			var product_id = product.id.toString();
			if (product_id === value[0]) {
				this.setState({
					product_id: product_id,
					autocompleteTextFieldValue: product.title,
				});
				for (var vkey in product.variants) {
					var variant = product.variants[vkey];
					if (
						variant.shopify_variant_data &&
						typeof variant.shopify_variant_data === "string"
					) {
						variant.shopify_variant_data = JSON.parse(
							variant.shopify_variant_data
						);
						products[key].variants[vkey].shopify_variant_data =
							variant.shopify_variant_data;
					}
					linkProductVariants.push(variant);
				}
				this.setState({ linkProductVariants: linkProductVariants });
			}
		}
		this.aProductOptions = [];
		var variantsMappingRows = [];
		var proVarOps = [];
		proVarOps.push({ label: "Select Variant", value: null });
		for (key in linkProductVariants) {
			proVarOps.push({
				label:
					linkProductVariants[key].title +
					" (" +
					linkProductVariants[key].sku +
					")",
				value: linkProductVariants[key].id,
			});
		}
		var linkListingVariants = this.state.linkListingVariants;
		for (key in linkListingVariants) {
			var index = linkListingVariants[key].id;
			variantsMappingRows.push([
				<Tooltip content={linkListingVariants[key].title}>
					<b>{linkListingVariants[key].sku}</b>
				</Tooltip>,
				<Select
					id={"PolarisSelect" + index}
					options={proVarOps}
					onChange={this.handleVariantChange(index)}
					value={
						this.state.variantsMapping[index]
							? this.state.variantsMapping[index]
							: ""
					}
				/>,
			]);
		}
		this.setState({
			products: products,
			selectedProduct: [value],
			variantsMappingRows: variantsMappingRows,
		});
	}
	
	submitUnLinkProduct() {
		this.setState({
			actionLoading: true,
			actionErrMsg: null,
			actionSuccMsg: null,
		});
		var checkboxes = this.state.checkboxes;
		var listing_ids = [];
		for (var id in checkboxes) {
			if (checkboxes[id]) {
				listing_ids.push(id);
			}
		}
		var request_data = {
			listing_ids: listing_ids,
			shopify_url: this.props.store_data.shopify_url,
		};
		var requestOptions = {
			method: "POST",
			headers: { "Content-Type": "application/json" },
			body: JSON.stringify(request_data),
		};
		var fetch_url =
			this.props.api_url +
			"/unlinkproduct?api_token=" +
			this.props.store_data.user.api_token;
		fetch(fetch_url, requestOptions)
			.then((response) => response.json())
			.then((data) => {
				if (data && data.status && data.status === "success") {
					this.setState(
						{
							actionLoading: false,
							actionSuccMsg: data.msg,
							actionErrMsg: null,
							hasActiveCheckBox: false,
							checkboxes: {},
						},
						() => {
							this.getListings();
						},
						2000
					);
				} else {
					var error_message =
						"there was something wrong, please try again.";
					if (data.msg) {
						error_message = data.msg;
					}
					this.setState({
						actionLoading: false,
						actionErrMsg: error_message,
					});
				}
			})
			.catch((error) => {
				console.error(error);
			});
	}

	submitCreateProductsSingle = (listing_id) => {
		var checkboxes = [];
		checkboxes[listing_id] = true;
		this.setState(
			() => {
				return {
					hasActiveCheckBox: true,
					checkboxes: checkboxes,
					loading: true,
				};
			},
			() => {
				this.toggleAction(listing_id);
				this.submitCreateProducts();
			}
		);
	};

	submitCreateProducts() {
		this.setState({
			actionLoading: true,
			actionErrMsg: null,
			actionSuccMsg: null,
		});
		var checkboxes = this.state.checkboxes;
		var listing_ids = [];
		for (var id in checkboxes) {
			if (checkboxes[id]) {
				listing_ids.push(id);
			}
		}
		var request_data = {
			listing_ids: listing_ids,
			shopify_url: this.props.store_data.shopify_url,
		};
		var requestOptions = {
			method: "POST",
			headers: { "Content-Type": "application/json" },
			body: JSON.stringify(request_data),
		};
		var fetch_url =
			this.props.api_url +
			"/createproducts?api_token=" +
			this.props.store_data.user.api_token;
		fetch(fetch_url, requestOptions)
			.then((response) => response.json())
			.then((data) => {
				if (data && data.status && data.status === "success") {
					this.setState(
						{
							actionLoading: false,
							actionSuccMsg: data.msg,
							actionErrMsg: null,
							hasActiveCheckBox: false,
							checkboxes: {},
						},
						() => {
							this.getListings();
						},
						2000
					);
				} else {
					var error_message =
						"there was something wrong, please try again.";
					if (data.msg) {
						error_message = data.msg;
					}
					this.setState({
						actionLoading: false,
						actionErrMsg: error_message,
					});
				}
			})
			.catch((error) => {
				console.error(error);
			});
	}

	submitCreateProductsBulk(type) {
		this.setState({
			actionLoading: true,
			actionErrMsg: null,
			actionSuccMsg: null,
		});
		var request_data = {};
		if (type && type === "filter") {
			if (this.state.queryValue && this.state.queryValue.length > 0) {
				if (this.state.queryType.length > 0) {
					request_data[this.state.queryType] = this.state.queryValue;
				} else {
					request_data.title = this.state.queryValue;
				}
			}
			if (
				this.state.listingStatus &&
				this.state.listingStatus.length > 0
			) {
				request_data.status = this.state.listingStatus;
			}
		}
		request_data.shopify_url = this.props.store_data.shopify_url;
		var requestOptions = {
			method: "POST",
			headers: { "Content-Type": "application/json" },
			body: JSON.stringify(request_data),
		};
		var fetch_url =
			this.props.api_url +
			"/createproductsbulk?api_token=" +
			this.props.store_data.user.api_token;
		fetch(fetch_url, requestOptions)
			.then((response) => response.json())
			.then((data) => {
				if (data && data.status && data.status === "success") {
					this.setState(
						{
							actionLoading: false,
							actionSuccMsg: data.msg,
							actionErrMsg: null,
							hasActiveCheckBox: false,
							checkboxes: {},
						},
						() => {
							this.getListings();
						},
						2000
					);
				} else {
					var error_message =
						"there was something wrong, please try again.";
					if (data.msg) {
						error_message = data.msg;
					}
					this.setState({
						actionLoading: false,
						actionErrMsg: error_message,
					});
				}
			})
			.catch((error) => {
				console.error(error);
			});
	}

	submitDeleteListings() {
		this.setState({
			actionLoading: true,
			actionErrMsg: null,
			actionSuccMsg: null,
		});
		var checkboxes = this.state.checkboxes;
		var listing_ids = [];
		for (var id in checkboxes) {
			if (checkboxes[id]) {
				listing_ids.push(id);
			}
		}
		var request_data = {
			listing_ids: listing_ids,
			shopify_url: this.props.store_data.shopify_url,
		};
		var requestOptions = {
			method: "DELETE",
			headers: { "Content-Type": "application/json" },
			body: JSON.stringify(request_data),
		};
		var fetch_url =
			this.props.api_url +
			"/listings?api_token=" +
			this.props.store_data.user.api_token;
		fetch(fetch_url, requestOptions)
			.then((response) => response.json())
			.then((data) => {
				if (data && data.status && data.status === "success") {
					this.setState(
						{
							actionLoading: false,
							actionSuccMsg: data.msg,
							actionErrMsg: null,
							hasActiveCheckBox: false,
							checkboxes: {},
						},
						() => {
							this.getListings();
						},
						2000
					);
				} else {
					var error_message =
						"there was something wrong, please try again.";
					if (data.msg) {
						error_message = data.msg;
					}
					this.setState({
						actionLoading: false,
						actionErrMsg: error_message,
					});
				}
			})
			.catch((error) => {
				console.error(error);
			});
	}

	getListings(pageno = 1) {
		if (this._isMounted === true) {
			var queryData = [];
			if (this.state.queryValue && this.state.queryValue.length > 0) {
				if (this.state.queryType.length > 0) {
					queryData.push(
						this.state.queryType + "=" + this.state.queryValue
					);
				} else {
					queryData.push("title=" + this.state.queryValue);
				}
			}
			if (
				this.state.listingStatus &&
				this.state.listingStatus.length > 0
			) {
				queryData.push("status=" + this.state.listingStatus);
			}
			queryData.push("link_status=" + this.props.link_status);
			queryData.push("sort_by=" + this.state.sortBy);
			queryData.push("sort_order=" + this.state.sortOrder);
			queryData.push("page=" + pageno);
			queryData.push("shopify_url=" + this.props.store_data.shopify_url);
			queryData.push("api_token=" + this.props.store_data.user.api_token);
			var queryStr = queryData.join("&");
			fetch(this.props.api_url + "/listings?" + queryStr)
				.then((res) => res.json())
				.then((data) => {
					// this.setState({ listings: data, loading: false });

					// console.log('data', data);
					if (data && data.data && data.data.length > 0) {
						this.setState({ listings: data, loading: false, searchdata: "" });
						// alert("data found!");
					} else {
						this.setState({ listings: data, loading: false, searchdata: "do not search data" });
						// alert("No data found!");
					}
				})
				.catch((error) => {
					console.error("Error fetching data:", error);
					this.setState({ loading: false }); // Set loading state to false in case of error
				});
		}
	}
	
	handleSort(colind) {
		var sortBy = this.state.sortBy;
		var sortOrder = this.state.sortOrder;
		if (colind === 4) {
			sortBy = "title";
		} else if (colind === 5) {
			// If sorting by updatedAt column
			sortBy = "status";
		} else if (colind === 8) {
			// If sorting by updatedAt column
			sortBy = "updated_at";
		}
		if (sortOrder === "asc") {
			sortOrder = "desc";
		} else {
			sortOrder = "asc";
		}
		const { itemsPerPage } = this.state; // Extracting itemsPerPage from state
		this.setState(
			(prevState) => ({
				sortBy: sortBy,
				sortOrder: sortOrder,
			}),
			() => {
				this.handleItemsPerPageChange({
					target: { value: itemsPerPage },
				}); // Passing itemsPerPage value
			}
		);
	}
	handleQueryTypeChange(value) {
		var queryType = value[0] || "";
		var appliedFilters = this.state.appliedFilters;
		var fk = null;
		for (var key in appliedFilters) {
			if (appliedFilters[key]["key"] === "queryType") {
				fk = key;
			}
		}
		var filterObj = {
			key: "queryType",
			label: "Query Type : " + queryType,
			onRemove: this.clearQueryTypeChange,
		};
		if (fk && fk !== null) {
			appliedFilters[fk] = filterObj;
		} else {
			appliedFilters.push(filterObj);
		}
		this.setState(
			{
				appliedFilters: appliedFilters,
				queryType: queryType,
				lastQueryType: queryType,
			},
			() => {
				this.getListings();
			}
		);
	}
	clearQueryTypeChange() {
		var appliedFilters = this.state.appliedFilters;
		var fk = null;
		for (var key in appliedFilters) {
			if (appliedFilters[key]["key"] === "queryType") {
				fk = key;
			}
		}
		if (fk && fk !== null) {
			appliedFilters.splice(fk, 1);
		}
		fk = null;
		for (key in appliedFilters) {
			if (appliedFilters[key]["key"] === "queryValue") {
				fk = key;
			}
		}
		if (fk && fk !== null) {
			appliedFilters.splice(fk, 1);
		}
		this.setState(
			{ appliedFilters: appliedFilters, queryType: "", queryValue: "" },
			() => {
				this.getListings();
			}
		);
	}
	handleListingStatusChange(value) {
		var listingStatus = value[0] || "";
		var appliedFilters = this.state.appliedFilters;
		var fk = null;
		for (var key in appliedFilters) {
			if (appliedFilters[key]["key"] === "listingStatus") {
				fk = key;
			}
		}
		var filterObj = {
			key: "listingStatus",
			label: "Status : " + listingStatus,
			onRemove: this.clearListingStatusChange,
		};
		if (fk && fk !== null) {
			appliedFilters[fk] = filterObj;
		} else {
			appliedFilters.push(filterObj);
		}
		this.setState(
			{ appliedFilters: appliedFilters, listingStatus: listingStatus },
			() => {
				this.getListings();
			}
		);
	}
	clearListingStatusChange() {
		var appliedFilters = this.state.appliedFilters;
		var fk = null;
		for (var key in appliedFilters) {
			if (appliedFilters[key]["key"] === "listingStatus") {
				fk = key;
			}
		}
		if (fk && fk !== null) {
			appliedFilters.splice(fk, 1);
		}
		this.setState(
			{ appliedFilters: appliedFilters, listingStatus: "" },
			() => {
				this.getListings();
			}
		);
	}
	handleQueryChange(value) {
		var appliedFilters = this.state.appliedFilters;
		var fk = null;
		for (var key in appliedFilters) {
			if (appliedFilters[key]["key"] === "queryValue") {
				fk = key;
			}
		}
		if (!value || value.length === 0) {
			if (fk && fk !== null) {
				appliedFilters.splice(fk, 1);
			}
			fk = null;
			for (key in appliedFilters) {
				if (appliedFilters[key]["key"] === "queryType") {
					fk = key;
				}
			}
			if (fk && fk !== null) {
				appliedFilters.splice(fk, 1);
			}
		} else {
			var filterObj = {
				key: "queryValue",
				label: "Query : " + value,
				onRemove: this.handleQueryRemove,
			};
			if (fk && fk !== null) {
				appliedFilters[fk] = filterObj;
			} else {
				appliedFilters.push(filterObj);
			}
			fk = null;
			for (key in appliedFilters) {
				if (appliedFilters[key]["key"] === "queryType") {
					fk = key;
				}
			}
			if (!fk || fk === null) {
				var queryType = this.state.lastQueryType;
				if (!queryType || queryType === "" || queryType.length === 0) {
					queryType = "title";
				}
				filterObj = {
					key: "queryType",
					label: "Query Type : " + queryType,
					onRemove: this.clearQueryTypeChange,
				};
				appliedFilters.push(filterObj);
				this.setState(() => {
					return { queryType: queryType };
				});
			}
		}
		this.setState(
			{ queryValue: value, appliedFilters: appliedFilters },
			() => {
				this.getListings();
			}
		);
	}
	handleQueryRemove() {
		var appliedFilters = this.state.appliedFilters;
		var fk = null;
		for (var key in appliedFilters) {
			if (appliedFilters[key]["key"] === "queryValue") {
				fk = key;
			}
		}
		if (fk && fk !== null) {
			appliedFilters.splice(fk, 1);
		}
		fk = null;
		for (key in appliedFilters) {
			if (appliedFilters[key]["key"] === "queryType") {
				fk = key;
			}
		}
		if (fk && fk !== null) {
			appliedFilters.splice(fk, 1);
		}
		this.setState(
			{ queryValue: "", queryType: "", appliedFilters: appliedFilters },
			() => {
				this.getListings();
			}
		);
	}
	handleFiltersClearAll(value) {
		this.setState(
			{
				appliedFilters: [],
				queryValue: null,
				queryType: "",
				listingStatus: "",
			},
			() => {
				this.getListings();
			}
		);
	}
	toggleAction(value) {
		var actions = this.state.actions;
		if (actions[value]) {
			actions[value] = false;
		} else {
			actions[value] = true;
		}
		this.setState({ actions: actions });
	}
	toggleCheckbox(value) {
		var checkboxes = this.state.checkboxes;
		if (checkboxes[value]) {
			checkboxes[value] = false;
		} else {
			checkboxes[value] = true;
		}
		if (value == "all") {
			for (var key in this.state.listings.data) {
				checkboxes[this.state.listings.data[key].id] =
					checkboxes[value];
			}
			var hasActiveCheckBox = false;
			for (var key in checkboxes) {
				if (checkboxes[key] === true) {
					hasActiveCheckBox = true;
					break;
				}
			}
			this.setState(() => {
				return {
					hasActiveCheckBox: hasActiveCheckBox,
					checkboxes: checkboxes,
				};
			});
			return;
		}
		var hasActiveCheckBox = false;
		for (var key in checkboxes) {
			if (checkboxes[key] === true) {
				hasActiveCheckBox = true;
				break;
			}
		}
		this.setState(() => {
			return {
				hasActiveCheckBox: hasActiveCheckBox,
				checkboxes: checkboxes,
			};
		});
	}
	submitListingsImportRequest() {
		this.setState(
			{ paction_loading: true, actionSuccMsg: null, actionErrMsg: null },
			function () {
				var request_data = {
					shopify_url: this.props.store_data.shopify_url,
				};
				var requestOptions = {
					method: "POST",
					headers: { "Content-Type": "application/json" },
					body: JSON.stringify(request_data),
				};
				var fetch_url =
					this.props.api_url +
					"/importlistings?api_token=" +
					this.props.store_data.user.api_token;
				fetch(fetch_url, requestOptions)
					.then((response) => response.json())
					.then((data) => {
						if (data && data.status && data.status === "success") {
							this.setState({
								paction_loading: false,
								actionSuccMsg: data.msg,
								actionErrMsg: null,
							});
						} else {
							var error_message =
								"there was something wrong, please try again.";
							if (data.msg) {
								error_message = data.msg;
							}
							this.setState({
								paction_loading: false,
								actionSuccMsg: null,
								actionErrMsg: error_message,
							});
						}
					})
					.catch((error) => {
						console.error(error);
					});
			}
		);
	}

	

	
	getListingsData() {
		var activator, checkbox;
		var filters = [
			{
				key: "queryType",
				label: "Query Type",
				filter: (
					<ChoiceList
						title="Query Type"
						titleHidden
						choices={[
							{ label: "Title", value: "title" },
							{ label: "Ebay Itme ID", value: "ebay_item_id" },
							{ label: "Sku", value: "sku" },
						]}
						selected={this.state.queryType || ""}
						onChange={this.handleQueryTypeChange}
					/>
				),
				shortcut: true,
			},
			{
				key: "listingStatus",
				label: "Listing Status",
				filter: (
					<ChoiceList
						title="Listing Status"
						titleHidden
						choices={[
							{ label: "Published", value: " published" },
							{ label: "Unpublished", value: "unpublished" },
							{ label: "Error", value: "error" },
						]}
						selected={this.state.listingStatus || ""}
						onChange={this.handleListingStatusChange}
					/>
				),
			},
		];
		const rows = [];
		if (this.state.listings && this.state.listings.total > 0) {
			for (var key in this.state.listings.data) {
				var listing = this.state.listings.data[key];
				var img_url = listing.image;
				if (!img_url || img_url === "") {
					img_url = process.env.PUBLIC_URL + "/no_image.png";
				}
				var thumbnail = (
					<Thumbnail source={img_url} alt={listing.title} />
				);
				activator = (
					<Button
						onClick={this.toggleAction.bind(this, listing.id)}
						disclosure
					>
						Actions
					</Button>
				);
				checkbox = (
					<Checkbox
						checked={this.state.checkboxes[listing.id]}
						onChange={this.toggleCheckbox.bind(this, listing.id)}
					/>
				);
				if (this.props.link_status === "linked") {
					rows.push([
						<div style={{ width: "20px" }}>{checkbox}</div>,
						<div style={{ width: "50px" }}>{thumbnail}</div>,
						listing.id,
						listing.ebay_item_id,
						<div style={{ maxWidth: "800px", overflow: "hidden" }}>
							<Link external url={listing.listing_url}>
								{listing.product.title}
							</Link>
						</div>,
						listing.variants.length,
						<Link
							external
							url={
								"https://" +
								this.props.store_data.shopify_url +
								"/admin/products/" +
								listing.product.shopify_product_id
							}
						>
							{listing.product.shopify_product_id}
						</Link>,
						<div style={{ width: "50px" }}>
							{listing.product.updated_at}
						</div>,
					]);
				} else {
					rows.push([
						<div style={{ width: "20px" }}>{checkbox}</div>,
						<div style={{ width: "50px" }}>{thumbnail}</div>,
						// listing.id,
						listing.ebay_item_id,

						<Link external url={listing.listing_url}>
							{listing.title}
						</Link>,
						listing.variants.length,
						listing.status === "published" ? "Active" : "Ended",
						listing.status === "published" ? (
							<div>
								<Popover
									active={this.state.actions[listing.id]}
									activator={activator}
									onClose={this.toggleAction.bind(
										this,
										listing.id
									)}
								>
									<ActionList
										items={[
											{
												content: "Link Product",
												icon: ConnectMinor,
												onAction:
													this.showLinkProductModel.bind(
														this,
														listing,
														listing.title
													),
											},
											{
												content: "Create Product",
												icon: ConnectMinor,
												onAction:
													this.submitCreateProductsSingle.bind(
														this,
														listing.id
													),
											},
										]}
									/>
								</Popover>
							</div>
						) : (
							<>
								<span
									style={{
										paddingLeft: "10px",
										paddingRight: "10px",
									}}
								>
									<Button variant="monochromePlain" disabled>
										Actions
									</Button>
								</span>
							</>
						),
						<div style={{ width: "50px" }}>
							{listing.updated_at}
						</div>,
					]);
				}
			}
		}
		activator = (
			<Button onClick={this.toggleAction.bind(this, "common")} disclosure>
				Actions
			</Button>
		);
		var currentPage = 1;
		var hasNext = false;
		var nextPage = 0;
		var hasPrevious = false;
		var previousPage = 0;
		if (this.state.listings) {
			currentPage = this.state.listings.current_page;
			if (this.state.listings.next_page_url) {
				hasNext = true;
				nextPage = currentPage + 1;
			}
			if (this.state.listings.prev_page_url) {
				hasPrevious = true;
				previousPage = currentPage - 1;
			}
		}
		var autocompleteTextField = (
			<Autocomplete.TextField
				onChange={this.updateProductOptions}
				value={this.state.autocompleteTextFieldValue}
				prefix={<Icon source={SearchMinor} color="inkLighter" />}
				placeholder="Search Product..."
			/>
		);
		var columnContentTypes = [
			"text",
			"text",
			// "numeric",
			"text",
			"text",
			"numeric",
			"text",
			"text",
			"timestamp",
			"timestamp",
		];
		var headings = [
			"",
			"Image",
			"Item ID",
			"Title",
			"Variants",
			"Ebay Status",
			"Link / Create Product" 
			/*"created"*/,			
			"Updated",
		];
		var sortable = [
			false,
			false,
			false,
			true,
			false,
			true,
			false,
			true,
			true,
		];
		var actionList = [];
		if (this.state.hasActiveCheckBox) {
			actionList.push({
				content: "Create Product",
				icon: AddProductMajorMonotone,
				onAction: this.submitCreateProducts,
			});
			actionList.push({
				content: "Delete",
				icon: DeleteMajorMonotone,
				onAction: this.submitDeleteListings,
			});
		}
		actionList.push({
			content: "Create Products from All Listings",
			icon: AddProductMajorMonotone,
			onAction: this.submitCreateProductsBulk,
		});
		if (this.state.appliedFilters.length > 0) {
			actionList.push({
				content: "Create Products from All Filtered Listings",
				icon: AddProductMajorMonotone,
				onAction: () => this.submitCreateProductsBulk("filter"),
			});
		} else {
		}
		if (this.props.link_status === "linked") {
			columnContentTypes = [
				"text",
				"text",
				"numeric",
				"text",
				"text",
				"numeric",
				"numeric",
				"timestamp",
				"timestamp",
			];
			headings = [
				"",
				"",
				"ID",
				"Item ID",
				"Title",
				"Variants",
				"Product",
				// "Created",
				"Updated",
			];
			sortable = [
				false,
				false,
				false,
				false,
				true,
				false,
				false,
				true,
				true,
			];
			actionList = [
				{
					content: "Unlink",
					icon: CancelSmallMinor,
					onAction: this.submitUnLinkProduct,
				},
			];
		}
		const { itemsPerPage } = this.state;
		const { listings } = this.state;
		const disableNextButton = listings.to === listings.total;
		const disablePrevButton = currentPage === 1;
		return (
			<>
				{/* {console.log("listing", rows.length)} */}

				<>
					<Page
						fullWidth="true"
						title={
							this.props.link_status.charAt(0).toUpperCase() +
							this.props.link_status.slice(1) +
							" Listings"
						}
						primaryAction={{
							content: "Import Products",
							loading: this.state.paction_loading,
							primary: false,
							onAction: this.submitListingsImportRequest,
						}}
					>
						<Card>

                            {rows && rows.length > 0 && (
                                <Card.Section>

                                    <Filters
                                        queryValue={this.state.queryValue}
                                        filters={filters}
                                        appliedFilters={this.state.appliedFilters}
                                        onQueryChange={this.handleQueryChange}
                                        onQueryClear={this.handleQueryRemove}
                                        onClearAll={this.handleFiltersClearAll}
                                    />
                                    {this.state.linkProductSuccMsg && (
                                        <Toast
                                            content={this.state.linkProductSuccMsg}
                                            onDismiss={this.hideToast}
                                            duration="6000"
                                        />
                                    )}
                                    {this.state.linkProductErrMsg && (
                                        <Toast
                                            content={this.state.linkProductErrMsg}
                                            error
                                            onDismiss={this.hideToast}
                                            duration="6000"
                                        />
                                    )}
                                    {this.state.actionSuccMsg && (
                                        <Toast
                                            content={this.state.actionSuccMsg}
                                            onDismiss={this.hideToast}
                                            duration="6000"
                                        />
                                    )}
                                    {this.state.actionErrMsg && (
                                        <Toast
                                            content={this.state.actionErrMsg}
                                            error
                                            onDismiss={this.hideToast}
                                            duration="6000"
                                        />
                                    )}
                                    <Modal
                                        open={this.state.showLinkProductModel}
                                        title="Link Listing to Product"
                                        // onClose={this.cancelLinkProduct}
										onClose={() => {
                                            this.cancelLinkProduct();
                                            this.setState({ aProductOptions: [] }); // Clearing the options
                                        }}
                                        primaryAction={{
                                            content: "Link",
                                            onAction: this.submitLinkProduct,
                                        }}
                                        secondaryActions={[
                                            {
                                                content: "Cancel",
                                                onAction: this.cancelLinkProduct,
                                            },
                                        ]}
                                        loading={this.state.loadingProducts}
                                    >
                                        <Modal.Section>
                                            <Stack vertical>
                                                <Stack.Item>
                                                    {this.state.linkProductErr && (
                                                        <Banner title="Error" status="critical"><p>{this.state.linkProductErr}</p></Banner>
                                                    )}
                                                    {this.state.linkProductLoading && (
                                                        <Spinner accessibilityLabel="Linking..." size="large" color="teal" />
                                                    )}
                                                </Stack.Item>
                                                <Stack.Item>
                                                    {!this.state.linkProductLoading && (
                                                        <Autocomplete
                                                            options={this.aProductOptions}
															selected={this.state.selectedProduct}
															onSelect={this.updateProductSelection}
															loading={this.state.autocompleteLoading}
															textField={autocompleteTextField}
                                                        />
                                                    )}
                                                </Stack.Item>
                                                <Stack.Item>
                                                    {!this.state.linkProductLoading &&
                                                        this.state.listing_id &&
                                                        this.state.product_id &&
                                                        this.state.linkProductVariants &&
                                                        this.state.linkListingVariants && (
                                                            <DataTable
                                                                columnContentTypes={[
                                                                    "text",
                                                                    "text",
                                                                ]}
                                                                headings={[
                                                                    "Listing SKU",
                                                                    "Product Variant",
                                                                ]}
                                                                rows={
                                                                    this.state
                                                                        .variantsMappingRows
                                                                }
                                                                sortable={[
                                                                    false,
                                                                    false,
                                                                ]}
                                                                truncate="true"
                                                                verticalAlign="middle"
                                                                hideScrollIndicator="true"
                                                            />
                                                        )}
                                                </Stack.Item>
                                            </Stack>
                                        </Modal.Section>
                                    </Modal>
                                    {!this.state.actionLoading &&
                                        (this.state.hasActiveCheckBox ||
                                            this.props.link_status !==
                                                "linked") && (
                                            <div>
                                                <br />
                                                <Popover
                                                    active={
                                                        this.state.actions["common"]
                                                    }
                                                    activator={activator}
                                                    onClose={this.toggleAction.bind(
                                                        this,
                                                        "common"
                                                    )}
                                                >
                                                    <ActionList
                                                        items={actionList}
                                                    />
                                                </Popover>
                                            </div>
                                        )}
                                    {/* {this.state.actionLoading && (
                                <div>
                                    <br />
                                    <Spinner
                                    accessibilityLabel="Processing..."
                                    size="large"
                                    color="teal"
                                    />
                                </div>
                                )} */}
                                </Card.Section>
                            )}

							{rows && rows.length > 0 && (
								<div style={{ margin: "0 2.0rem 0 1.6rem" }}>
									<Checkbox
										checked={this.state.checkboxes["all"]}
										onChange={this.toggleCheckbox.bind(
											this,
											"all"
										)}
									/>
									<span
										style={{
											position: "relative",
											top: "-3px",
										}}
									>
										Select All
									</span>
								</div>
							)}

							{rows && rows.length > 0 && (
								<DataTable
									columnContentTypes={columnContentTypes}
									headings={headings}
									rows={rows}
									sortable={sortable}
									defaultSortDirection="ascending"
									initialSortColumnIndex={4}
									onSort={this.handleSort}
									truncate="false"
									hideScrollIndicator="true"
									footerContent={`Showing from ${this.state.listings.from} to ${this.state.listings.to} of total ${this.state.listings.total}`}
								/>
							)}

							{rows && rows.length > 0 && (
								<Card.Section align="center">
									<div>
										{this.state.showDefaultPagination && (
											<Pagination
												hasPrevious={hasPrevious}
												previousKeys={[74]}
												previousTooltip={previousPage}
												onPrevious={() => {
													this.getListings(
														previousPage
													);
												}}
												hasNext={hasNext}
												nextKeys={[75]}
												nextTooltip={nextPage}
												onNext={() => {
													this.getListings(nextPage);
												}}
											/>
										)}
										{this.state
											.showAlternativePagination && (
											<>
												<button
													className="previousButton"
													onClick={
														this.handlePrevPage
													}
													disabled={disablePrevButton}
												>
													<svg
														viewBox="0 0 20 20"
														className="Polaris-Icon__Svg"
														focusable="false"
														aria-hidden="true"
													>
														<path
															d="M17 9H5.414l3.293-3.293a.999.999 0 1 0-1.414-1.414l-5 5a.999.999 0 0 0 0 1.414l5 5a.997.997 0 0 0 1.414 0 .999.999 0 0 0 0-1.414L5.414 11H17a1 1 0 1 0 0-2"
															fillRule="evenodd"
														></path>
													</svg>
												</button>
												<button
													className="nextButton"
													onClick={
														this.handleNextPage
													}
													disabled={disableNextButton}
												>
													<svg
														viewBox="0 0 20 20"
														className="Polaris-Icon__Svg"
														focusable="false"
														aria-hidden="true"
													>
														<path
															d="M17.707 9.293l-5-5a.999.999 0 1 0-1.414 1.414L14.586 9H3a1 1 0 1 0 0 2h11.586l-3.293 3.293a.999.999 0 1 0 1.414 1.414l5-5a.999.999 0 0 0 0-1.414"
															fillRule="evenodd"
														></path>
													</svg>
												</button>
											</>
										)}
										<select
											id="itemsPerPage"
											onChange={
												this.handleItemsPerPageChange
											}
											value={itemsPerPage}
										>
											<option value="20">20</option>
											<option value="50">50</option>
											<option value="100">100</option>
											<option value="200">200</option>
											<option value="500">500</option>
										</select>
									</div>
								</Card.Section>
							)}

							{rows.length <= 0 && (
								
								<Card.Section>
									{this.state.queryValue && this.state.queryValue.length > 0 && (
									<>
										<Filters
											queryValue={this.state.queryValue}
											filters={filters}
											appliedFilters={this.state.appliedFilters}
											onQueryChange={this.handleQueryChange}
											onQueryClear={this.handleQueryRemove}
											onClearAll={this.handleFiltersClearAll}
										/>
									</>
									)}
									<EmptyState
									heading=""						
									image="https://cdn.shopify.com/s/files/1/0262/4071/2726/files/emptystate-files.png"
									>
									<p>
									No Products Found , 
									Please Add .
									</p>						
									</EmptyState>
								</Card.Section>
                                
							)}
                            
						</Card>
					</Page>
				</>
			</>
		);
	}
	handleItemsPerPageChange = (event, pageno = 1) => {
		const itemsPerPage = event.target.value;
		this.setState({ itemsPerPage: itemsPerPage });
		this.setState({ totalPages: "" });
		if (this._isMounted === true) {
			var queryData = [];
			this.setState({ showDefaultPagination: false });
			this.setState({ showAlternativePagination: true });
			this.setState({ loading: true });
			if (this.state.queryValue && this.state.queryValue.length > 0) {
				if (this.state.queryType.length > 0) {
					queryData.push(
						this.state.queryType + "=" + this.state.queryValue
					);
				} else {
					queryData.push("title=" + this.state.queryValue);
				}
			}
			if (
				this.state.listingStatus &&
				this.state.listingStatus.length > 0
			) {
				queryData.push("status=" + this.state.listingStatus);
			}
			queryData.push("link_status=" + this.props.link_status);
			queryData.push("sort_by=" + this.state.sortBy);
			queryData.push("sort_order=" + this.state.sortOrder);
			queryData.push("page=" + this.state.currentPage);
			queryData.push("limit=" + itemsPerPage);
			queryData.push("shopify_url=" + this.props.store_data.shopify_url);
			queryData.push("api_token=" + this.props.store_data.user.api_token);
			var queryStr = queryData.join("&");
			fetch(this.props.api_url + "/listings?" + queryStr)
				.then((res) => res.json())
				.then((data) => {
					this.setState({ listings: data, loading: false });
				})
				.catch((error) => {
					console.error("Error fetching data:", error);
					this.setState({ loading: false }); // Set loading state to false in case of error
				});
		}
	};
	handleNextPage = () => {
		const { itemsPerPage } = this.state; // Extracting itemsPerPage from state
		this.setState(
			(prevState) => ({
				currentPage: prevState.currentPage + 1,
			}),
			() => {
				this.handleItemsPerPageChange({
					target: { value: itemsPerPage },
				}); // Passing itemsPerPage value
			}
		);
	};
	handlePrevPage = () => {
		const { itemsPerPage } = this.state; // Extracting itemsPerPage from state
		this.setState(
			(prevState) => ({
				currentPage: prevState.currentPage - 1,
			}),
			() => {
				this.handleItemsPerPageChange({
					target: { value: itemsPerPage },
				}); // Passing itemsPerPage value
			}
		);
	};

	cancelLinkProduct() {

		document.body.classList.remove('disable-scroll');

		if (!this.state.linkProductLoading) {
        // Call resetModalStateAndProductOptions function to reset modal state and productOptions
			this.resetModalStateAndProductOptions();
		}

		// console.log('anshu22',this.productOptions);
		
		if (this.state.linkProductLoading === false) {			

			this.setState({
				product_id: "",
				listing_id: "",
				autocompleteTextFieldValue: "",
				selectedProduct: [],
				productOptions: [],
				showLinkProductModel: false,
				linkListingVariants: [],
				linkProductVariants: [],
				variantsMapping: {},
				linkProductErrMsg: null,
				linkProductErr: ""
			});
			this.aProductOptions = this.productOptions;
			
			
		}
	}

	// Function to reset modal state and productOptions
resetModalStateAndProductOptions() {
    this.setState({
        product_id: "",
        listing_id: "",
        autocompleteTextFieldValue: "",
        selectedProduct: [],
        productOptions: [], // Resetting productOptions to blank array
        showLinkProductModel: false,
        linkListingVariants: [],
        linkProductVariants: [],
        variantsMapping: {},
        linkProductErrMsg: null,
        linkProductErr: ""
    });

    // Assigning the updated value of this.productOptions to this.aProductOptions
    this.aProductOptions = this.productOptions;
}

	render() {
		const { loading } = this.state;
		if (loading) {
			return (
				<div
					style={{
						display: "flex",
						justifyContent: "center",
						alignItems: "center",
						height: "100vh",
					}}
				>
					<Spinner accessibilityLabel="Loading" size="large" />
					{/* Render Spinner while loading */}
				</div>
			);
		}
		return (
			<Layout>
				<Layout.Section>
					<Page title="" fullWidth="true">
						{this.state.error_message && (
							<Banner title="Error" status="critical">
								<p>{this.state.error_message}</p>
							</Banner>
						)}
						{this.state.success_message && (
							<Banner title="Success" status="success">
								<p>{this.state.success_message}</p>
							</Banner>
						)}
					</Page>
				</Layout.Section>
				<Layout.Section>
					{this.getListingsData()}
					<FooterHelp>
						For more details on App, visit our{" "}
						<Link
							url="https://app1.ecomshore.com/Manage_Listings.pdf"
							external="true"
						>
							documentation
						</Link>
						.
					</FooterHelp>
				</Layout.Section>
			</Layout>
		);
	}
}
export default Listings;
