import React, {Component} from 'react';
import {Page, Layout, Card, DataTable, ChoiceList, Filters, Banner, Pagination ,EmptyState} from '@shopify/polaris';

class Logs extends Component
{
  _isMounted = false;
  
  state = {
    logs:{},
    actions:{},
    checkboxes:{},
    queryValue:"",
    queryType:"",
    logStatus:"",
    appliedFilters : [],
    hasActiveCheckBox : false,
    lastQueryType:"",
    sortBy:"created_at",
    sortOrder:"desc",
  };

  constructor(props){
    super(props);
    this.getLogs = this.getLogs.bind(this);
    this.getLogsData = this.getLogsData.bind(this);
    this.toggleAction = this.toggleAction.bind(this);
    this.toggleCheckbox = this.toggleCheckbox.bind(this);

    this.handleQueryChange = this.handleQueryChange.bind(this);
    this.handleLogStatusChange = this.handleLogStatusChange.bind(this);
    this.handleQueryTypeChange = this.handleQueryTypeChange.bind(this);
    this.handleQueryRemove = this.handleQueryRemove.bind(this);
    this.handleFiltersClearAll = this.handleFiltersClearAll.bind(this);

    this.clearQueryTypeChange = this.clearQueryTypeChange.bind(this);
    this.clearLogStatusChange = this.clearLogStatusChange.bind(this);
    this.handleSort = this.handleSort.bind(this);
  }

  componentWillUnmount(){
    this._isMounted = false;
  }

  componentDidMount(){
    this._isMounted = true;
    document.title = 'Activity Logs - ' + document.title;
    this.getLogs();
  }

  getLogs(pageno=1){
    if(this._isMounted === true){
      var queryData = [];
      
      if(this.state.queryValue && this.state.queryValue.length > 0){
        if(this.state.queryType.length > 0){queryData.push(this.state.queryType + "=" + this.state.queryValue);}
        else{queryData.push("log_type=" + this.state.queryValue);}
      }
      if(this.state.logStatus && this.state.logStatus.length > 0){queryData.push("status=" + this.state.logStatus);}
      queryData.push("sort_by=" + this.state.sortBy);
      queryData.push("sort_order=" + this.state.sortOrder);
      queryData.push("page=" + pageno);
      queryData.push("shopify_url=" + this.props.store_data.shopify_url);
      queryData.push("api_token=" + this.props.store_data.user.api_token);
      var queryStr = queryData.join("&");
      fetch(this.props.api_url+'/logs?'+queryStr)
      .then(res => res.json())
      .then((data) => {
        this.setState({ logs: data });
      })
      .catch(console.log);
    }
  }

  handleSort(colind){
    var sortBy = this.state.sortBy;
    var sortOrder = this.state.sortOrder;
    if(colind === 2){sortBy = "created_at";}

    if(sortOrder === "asc"){sortOrder = "desc";}
    else{sortOrder = "asc";}

    this.setState({sortBy: sortBy,sortOrder: sortOrder},() => {
      this.getLogs();
    });
  }

  handleQueryTypeChange(value){
    var queryType = value[0] || "";
    var appliedFilters = this.state.appliedFilters;
    var fk = null;
    for(var key in appliedFilters){if(appliedFilters[key]["key"] === "queryType"){fk = key;}}
    var filterObj = {key: 'queryType',label: "Query Type : " + queryType,onRemove: this.clearQueryTypeChange};
    if(fk && fk !== null){
      appliedFilters[fk] = filterObj;
    }
    else{appliedFilters.push(filterObj);}
    this.setState({appliedFilters: appliedFilters,queryType: queryType,lastQueryType:queryType},() => {
      this.getLogs();
    });
    
  }

  clearQueryTypeChange(){
    var appliedFilters = this.state.appliedFilters;
    var fk = null;
    for(var key in appliedFilters){if(appliedFilters[key]["key"] === "queryType"){fk = key;}}
    if(fk && fk !== null){appliedFilters.splice(fk,1);}

    fk = null;
    for(key in appliedFilters){if(appliedFilters[key]["key"] === "queryValue"){fk = key;}}
    if(fk && fk !== null){appliedFilters.splice(fk,1);}

    this.setState({appliedFilters: appliedFilters,queryType: "",queryValue: ""},() => {
      this.getLogs();
    });
    
  }

  handleLogStatusChange(value){
    var logStatus = value[0] || "";

    var appliedFilters = this.state.appliedFilters;
    var fk = null;
    for(var key in appliedFilters){if(appliedFilters[key]["key"] === "logStatus"){fk = key;}}
    var filterObj = {key: 'logStatus',label: "Status : " + logStatus,onRemove: this.clearLogStatusChange};
    if(fk && fk !== null){appliedFilters[fk] = filterObj;}
    else{appliedFilters.push(filterObj);}
    this.setState({appliedFilters: appliedFilters,logStatus: logStatus},() => {
      this.getLogs();
    });
    
  }

  clearLogStatusChange(){
    var appliedFilters = this.state.appliedFilters;
    var fk = null;
    for(var key in appliedFilters){if(appliedFilters[key]["key"] === "logStatus"){fk = key;}}
    if(fk && fk !== null){appliedFilters.splice(fk,1);}
    this.setState({appliedFilters: appliedFilters,logStatus: ""},() => {
      this.getLogs();
    });
  }

  handleQueryChange(value){
    var appliedFilters = this.state.appliedFilters;
    var fk = null;
    for(var key in appliedFilters){if(appliedFilters[key]["key"] === "queryValue"){fk = key;}}

    if(!value || value.length === 0){
      if(fk && fk !== null){appliedFilters.splice(fk,1);}
      fk = null;
      for(key in appliedFilters){if(appliedFilters[key]["key"] === "queryType"){fk = key;}}
      if(fk && fk !== null){appliedFilters.splice(fk,1);}
    }
    else{
      var filterObj = {key: 'queryValue',label: "Query : " + value,onRemove: this.handleQueryRemove};
      if(fk && fk !== null){appliedFilters[fk] = filterObj;}
      else{appliedFilters.push(filterObj);}

      fk = null;
      for(key in appliedFilters){if(appliedFilters[key]["key"] === "queryType"){fk = key;}}
      if(!fk || fk === null){
        var queryType = this.state.lastQueryType;
        if(!queryType || queryType === "" || queryType.length === 0){queryType = "logtype";}
        filterObj = {key: 'queryType',label: "Query Type : " + queryType,onRemove: this.clearQueryTypeChange};
        appliedFilters.push(filterObj);
        this.setState({queryType: queryType});
      }
    }

    this.setState({queryValue: value,appliedFilters: appliedFilters},() => {
      this.getLogs();
    });
  }

  handleQueryRemove(){
    var appliedFilters = this.state.appliedFilters;
    var fk = null;
    for(var key in appliedFilters){if(appliedFilters[key]["key"] === "queryValue"){fk = key;}}
    if(fk && fk !== null){appliedFilters.splice(fk,1);}

    fk = null;
    for(key in appliedFilters){if(appliedFilters[key]["key"] === "queryType"){fk = key;}}
    if(fk && fk !== null){appliedFilters.splice(fk,1);}

    this.setState({queryValue: "",queryType: "",appliedFilters: appliedFilters},() => {
      this.getLogs();
    });
  }
  
  handleFiltersClearAll(value){
    this.setState({appliedFilters: [],queryValue: null,queryType: "",logStatus: ""},() => {
      this.getLogs();
    });
  }

  toggleAction(value){
    var actions = this.state.actions;
    if(actions[value]){
      actions[value] = false;
    }
    else{
      actions[value] = true;
    }
    this.setState({ actions: actions });
  }

  toggleCheckbox(value){
    var checkboxes = this.state.checkboxes;
    if(checkboxes[value]){
      checkboxes[value] = false;
    }
    else{
      checkboxes[value] = true;
    }
    this.setState({ checkboxes: checkboxes });
    var hasActiveCheckBox = false;
    for(var key in checkboxes){
      if(checkboxes[key] === true){
        hasActiveCheckBox = true;
        break;
      }
    }
    this.setState({ hasActiveCheckBox: hasActiveCheckBox });
  }

  getLogsData(){
    var filters = [
      {
        key: 'queryType',
        label: 'Query Type',
        filter: (
          <ChoiceList
            title="Query Type"
            titleHidden
            choices={[
              {label: 'Type', value: 'logtype'},
              {label: 'Log Date', value: 'logdate'},
              {label: 'Remarks', value: 'remarks'}
            ]}
            selected={this.state.queryType || ""}
            onChange={this.handleQueryTypeChange}
          />
        ),
        shortcut: true,
      },
      {
        key: 'logStatus',
        label: 'Order Status',
        filter: (
          <ChoiceList
            title="Order Status"
            titleHidden
            choices={[
              {label: 'Success', value: 'success'},
              {label: 'Error', value: 'error'}
            ]}
            selected={this.state.logStatus || ""}
            onChange={this.handleLogStatusChange}
          />
        ),
      }
    ];

    const rows = [];
    if(this.state.logs && this.state.logs.total > 0){
      for(var key in this.state.logs.data){
        var log = this.state.logs.data[key];
        rows.push([
          log.id,
          log.log_type,
          log.status,
          log.created_at,
          log.remarks,
          log.output_data
        ]);
      }
      //this.setState({active: active});
    }
    var currentPage = 1;
    var hasNext = false;
    var nextPage = 0;
    var hasPrevious = false;
    var previousPage = 0;
    if(this.state.logs){
      currentPage = this.state.logs.current_page;
      if(this.state.logs.next_page_url){
        hasNext = true;
        nextPage = currentPage + 1;
      }
      if(this.state.logs.prev_page_url){
        hasPrevious = true;
        previousPage = currentPage - 1;
      }      
    }
    return (
      <Page fullWidth="true" title="Logs">
        {this.state.logs && this.state.logs.total > 0 && (
        <Card>
         
        
        <Card.Section>
            <Filters
              queryValue={this.state.queryValue}
              filters={filters}
              appliedFilters={this.state.appliedFilters}
              onQueryChange={this.handleQueryChange}
              onQueryClear={this.handleQueryRemove}
              onClearAll={this.handleFiltersClearAll}
            />
          </Card.Section>
         
          <DataTable
            columnContentTypes={[
              'text',
              'text',
              'text',
              'text',
              'text',
              'text'
            ]}
            headings={[
              'Log ID',
              'Log Type',
              'Log Status',
              'Log Date',
              'Remarks',
              'Output Data'
            ]}
            rows={rows}
            sortable={[false,false,true,false]}
            defaultSortDirection="descending"
            initialSortColumnIndex={2}
            onSort={this.handleSort}
            truncate="true"
            footerContent={`Showing from ${this.state.logs.from} to ${this.state.logs.to} of total ${this.state.logs.total}`}
          />

          {rows && rows.length > 0 &&
          <Card.Section align="center">
            <Pagination
              hasPrevious={hasPrevious}
              previousKeys={[74]}
              previousTooltip={previousPage}
              onPrevious={() => {
                console.log('Previous');
                this.getLogs(previousPage);
              }}
              hasNext={hasNext}
              nextKeys={[75]}
              nextTooltip={nextPage}
              onNext={() => {
                console.log('Next');
                this.getLogs(nextPage);
              }}
            />
          </Card.Section>
          }
        
        
        </Card>
        )}
        <Card>
        {this.state.logs && this.state.logs.total <= 0 && (
                <>
                <Card.Section>
					<EmptyState heading="" image="https://cdn.shopify.com/s/files/1/0262/4071/2726/files/emptystate-files.png">
						<p>
							No Activity Logs Found .
						</p>
					</EmptyState>
				</Card.Section>
                </>
                )}
                </Card>
      </Page>
    );
  }
  render(){
    return(
      <Layout>
        <Layout.Section>
          <Page title="" fullWidth="true">
            {this.state.error_message &&
            <Banner title="Error" status="critical"><p>{this.state.error_message}</p></Banner>
            }
            {this.state.success_message &&
            <Banner title="Success" status="success"><p>{this.state.success_message}</p></Banner>
            }
          </Page>
        </Layout.Section>
        <Layout.Section>
          {this.getLogsData()}
        </Layout.Section>
      </Layout>
    );
  }
}

export default Logs;