import React, {Component} from 'react';

import {Page, Button, Layout, Card, DataTable, TextStyle, Popover, ActionList, Thumbnail, Badge} from '@shopify/polaris';

import {ImportMinor} from '@shopify/polaris-icons';

class OrderView extends Component
{
  _isMounted = false;
  
  state = {
    order:{},
    actions:{}
  };

  constructor(props){
    super(props);
    this.getOrder = this.getOrder.bind(this);
    this.getOrderItemsData = this.getOrderItemsData.bind(this);
    this.toggleAction = this.toggleAction.bind(this);
    this.getOrderTotalsData = this.getOrderTotalsData.bind(this);
    this.getCustomerData = this.getCustomerData.bind(this);
    this.getOrderData = this.getOrderData.bind(this);
    
  }
  
  componentWillUnmount(){
    this._isMounted = false;
  }

  componentDidMount(){
    this._isMounted = true;
    document.title = 'Order Details - ' + document.title;
    this.getOrder();
  }

  getOrder(){
    if(this._isMounted === true){
      fetch(this.props.api_url+'/order/'+this.props.order_id+'?shopify_url='+this.props.store_data.shopify_url+'&api_token='+this.props.store_data.user.api_token)
      .then(res => res.json())
      .then((data) => {
        console.log(data);
        this.setState({ order: data });
      })
      .catch(console.log);
    }
  }

  getOrderItemsData(){
    var rows = [];
    if(this.state.order.order_details && this.state.order.order_details.line_item && this.state.order.order_details.line_item.title){
    //  for(var key in this.state.order.order_details.line_item){
        var line_item = this.state.order.order_details.line_item;

        var img_url = line_item.image;
        if(!img_url || img_url === ""){img_url = process.env.PUBLIC_URL + '/no_image.png';}
        var thumbnail = <Thumbnail source={img_url} alt={line_item.title} />;

        rows.push([
          <div style={{width: '50px'}}>{thumbnail}</div>,
          <div style={{maxWidth: '400px',overflow: 'hidden'}}>
            {this.state.order.order_details.line_item.title}
            <br />
            {this.state.order.order_details.line_item.sku}
          </div>,
          line_item.currency + " " + line_item.price + " x " + line_item.quantity,
          line_item.currency + " " + line_item.item_total
        ]);
      //}
   }

    return (
      <Card >
        <DataTable
          columnContentTypes={[
            'text',
            'text',
            'numeric',
            'numeric'
          ]}
          headings={[]}
          rows={rows}
          totals={['','','',this.state.order.order_details.currency + " " + this.state.order.order_details.order_total]}
          showTotalsInFooter
        />
      </Card>
    );
  }


  getOrderTotalsData(){
    var rows = [];
    rows.push([
      'Sub Total',
      this.state.order.order_details.currency + " " + this.state.order.order_details.order_total
    ]);

    var shipping_total = this.state.order.order_details.currency + " 0.00" ;
    var tax_total = this.state.order.order_details.currency + " 0.00" ;
    var discount_total = this.state.order.order_details.currency + " 0.00" ;
    
    if(this.state.order.order_details.order_shipping_total) shipping_total = this.state.order.order_details.currency + " " + this.state.order.order_details.order_shipping_total;
    if(this.state.order.order_details.order_tax_total) tax_total = this.state.order.order_details.currency + " " + this.state.order.order_details.order_tax_total;
    if(this.state.order.order_details.order_discount_total) discount_total = this.state.order.order_details.currency + " " + this.state.order.order_details.order_discount_total;

    rows.push([
      'Discount',
      discount_total
    ]);

    rows.push([
      'Shipping',
      shipping_total
    ]);

    rows.push([
      'Tax',
      tax_total
    ]);

    return (
      <Card title="Order Totals">
        <DataTable
          columnContentTypes={[
            'text',
            'numeric'
          ]}
          headings={[]}
          rows={rows}
          totals={['',this.state.order.order_details.currency + " " + this.state.order.order_details.order_total]}
          showTotalsInFooter
        />
      </Card>
    );
  }

  getOrderData(){
    // return (
    //   // <Card title="Order Api Data">
    //   //   <Card.Section>
    //   //     <p>
    //   //       {this.state.order.order_data_json}
    //   //     </p>
    //   //   </Card.Section>
    //   // </Card>
    // );
  }

  getCustomerData(){
    return (
      <Card title="Customer">
        <Card.Section>
          <p>{this.state.order.order_details.customer_name}</p>
        </Card.Section>
        <Card.Section title="Contact information">
          <p>{this.state.order.order_details.email}</p>
          {this.state.order.order_details.phone &&
          <p>{this.state.order.order_details.phone}</p>
          }
          {!this.state.order.order_details.phone &&
          <TextStyle variation="subdued">No phone number</TextStyle>
          }
        </Card.Section>

        <Card.Section title="Shipping Address">
          {!this.state.order.order_details.shipping_address &&
          <TextStyle variation="subdued">No Shipping Address</TextStyle>
          }

          {this.state.order.order_details.shipping_address.address1 &&
          <p>{this.state.order.order_details.shipping_address.address1}</p>
          }
          {this.state.order.order_details.shipping_address.address2 &&
          <p>{this.state.order.order_details.shipping_address.address2}</p>
          }
          {this.state.order.order_details.shipping_address.city &&
          <p>{this.state.order.order_details.shipping_address.city}, {this.state.order.order_details.shipping_address.postal_code}</p>
          }
          {this.state.order.order_details.shipping_address.state &&
          <p>{this.state.order.order_details.shipping_address.state}</p>
          }
          {this.state.order.order_details.shipping_address.country &&
          <p>{this.state.order.order_details.shipping_address.country}</p>
          }
         
        </Card.Section>

        <Card.Section title="Billing Address">
          {!this.state.order.order_details.billing_address &&
          <TextStyle variation="subdued">No Billing Address</TextStyle>
          }

          {this.state.order.order_details.billing_address.address1 &&
          <p>{this.state.order.order_details.billing_address.address1}</p>
          }
          {this.state.order.order_details.billing_address.address2 &&
          <p>{this.state.order.order_details.billing_address.address2}</p>
          }
          {this.state.order.order_details.billing_address.city &&
          <p>{this.state.order.order_details.billing_address.city}, {this.state.order.order_details.billing_address.postal_code}</p>
          }
          {this.state.order.order_details.billing_address.state &&
          <p>{this.state.order.order_details.billing_address.state}</p>
          }
          {this.state.order.order_details.billing_address.country &&
          <p>{this.state.order.order_details.billing_address.country}</p>
          }
         
        </Card.Section>

      </Card>
    );
  }

  toggleAction(value){
    var actions = this.state.actions;
    if(actions[value]){
      actions[value] = false;
    }
    else{
      actions[value] = true;
    }
    this.setState({ actions: actions });
  }

  render(){
    var activator = <Button onClick={this.toggleAction.bind(this,"common")} disclosure>Actions</Button>;

    return(
      
      <Page fullWidth="true" title={"#" +  this.state.order.order_id} breadcrumbs={[{content: 'Orders', url: this.props.base_url + '/orders'}]} subtitle={"Added at : " + this.state.order.order_date_str} separator titleMetadata={<Badge>{this.state.order.status}</Badge>} >
        {/* {!this.state.order.id &&
        <Popover active={this.state.actions["common"]} activator={activator} onClose={this.toggleAction.bind(this,"common")}>
          <ActionList
            items={[
              {
                content: 'Publish',
                icon: ImportMinor,
                onAction: this.toggleAction
              },
              {
                content: 'Unpublish',
                icon: ImportMinor,
                onAction: this.toggleAction
              },
            ]}
          />
        </Popover>
        } */}
        <br />
        <Layout>
       
          <Layout.Section>
            {this.state.order.id &&
            this.getOrderItemsData()
            }
            
            {this.state.order.id &&
            this.getOrderTotalsData()
            }

          </Layout.Section>

          <Layout.Section secondary>
            {this.state.order.id &&
            this.getCustomerData()
            }
          </Layout.Section>

          <Layout.Section>
            {this.state.order.id &&
            this.getOrderData()
            }
          </Layout.Section>
        </Layout>
      </Page>
    );
  }
}

export default OrderView;